/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.html;

import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.document.Link;
import com.apcc.m11.components.webserver.html.document.Script;
import java.util.ArrayList;
import java.util.List;

public class Container
implements HTML {
    private List<HTML> theContents;

    public void add(HTML hTML) {
        if (hTML == null) {
            throw new NullPointerException("cannot add null element to HTML container");
        }
        if (this.theContents == null) {
            this.theContents = new ArrayList<HTML>();
        }
        this.theContents.add(hTML);
    }

    public void addAsFirst(HTML hTML) {
        if (hTML == null) {
            throw new NullPointerException("cannot add null element to HTML container");
        }
        if (this.theContents == null) {
            this.theContents = new ArrayList<HTML>();
        }
        this.theContents.add(0, hTML);
    }

    public void clear() {
        if (this.theContents != null) {
            this.theContents.clear();
        }
    }

    public void addStyleSheet(String string) {
        Link link = new Link();
        link.setRelationship("stylesheet");
        link.setHypertextReference(string);
        link.setMIMEType("text/css");
        this.add(link);
    }

    public void addScript(String string) {
        Script script = new Script();
        script.setSource(string);
        this.add(script);
    }

    public StringBuilder contentsToHTML(PageContext pageContext) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.theContents != null) {
            for (HTML hTML : this.theContents) {
                stringBuilder.append((CharSequence)hTML.toHTML(pageContext));
            }
        }
        stringBuilder.trimToSize();
        return stringBuilder;
    }

    public List<HTML> getContents() {
        return this.theContents;
    }

    @Override
    public StringBuilder toHTML(PageContext pageContext) {
        return this.contentsToHTML(pageContext);
    }
}

