/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.html;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.FormatterException;
import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.UnsupportedLocaleException;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.form.Form;
import com.apcc.m11.components.webserver.html.form.Input;
import com.apcc.m11.components.webserver.servlets.cfgwizard.M11DataSourceAccessor;
import java.io.PrintWriter;
import java.text.Normalizer;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PageContext {
    private static final Logger logger = LogManager.getLogger(PageContext.class);
    private Hashtable<String, Object> theValues = new Hashtable();
    private M11DataSourceAccessor dataSourceAccessor = null;
    private Locale theLocale = null;
    private PrintWriter theOutputWriter = null;
    private Map<String, String[]> thePostOrQueryString = null;
    private HttpSession theSession = null;
    private HttpServletRequest theRequest;
    private HttpServletResponse theResponse;

    public PageContext(Locale locale, PrintWriter printWriter, IDataSource iDataSource, HttpSession httpSession, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.theLocale = locale;
        this.theOutputWriter = printWriter;
        this.dataSourceAccessor = new M11DataSourceAccessor(iDataSource);
        this.theSession = httpSession;
        this.theRequest = httpServletRequest;
        this.theResponse = httpServletResponse;
        if (this.theRequest != null) {
            this.thePostOrQueryString = this.normalizeQueryParameters(this.theRequest.getParameterMap());
        }
    }

    private Map<String, String[]> normalizeQueryParameters(@NonNull Map<String, String[]> map) {
        if (map == null) {
            throw new IllegalArgumentException("parameterMap is marked non-null but is null");
        }
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        for (Map.Entry<String, String[]> entry : map.entrySet()) {
            hashMap.put(entry.getKey(), this.normalizeQueryParameter(entry.getValue()));
        }
        return hashMap;
    }

    private String[] normalizeQueryParameter(String[] stringArray) {
        if (stringArray == null || ArrayUtils.isEmpty((Object[])stringArray)) {
            return stringArray;
        }
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = StringUtils.isNotBlank((CharSequence)stringArray[i]) ? Normalizer.normalize(stringArray[i], Normalizer.Form.NFKC) : stringArray[i];
        }
        return stringArray2;
    }

    public HttpSession getSession() {
        return this.theSession;
    }

    public HttpServletRequest getRequest() {
        return this.theRequest;
    }

    public HttpServletResponse getResponse() {
        return this.theResponse;
    }

    public Locale getLocale() {
        return this.theLocale;
    }

    public PrintWriter getOutputWriter() {
        return this.theOutputWriter;
    }

    public Object get(ObjectId objectId) {
        return this.dataSourceAccessor.get(objectId);
    }

    public Object get(ObjectId objectId, Object object) {
        return this.dataSourceAccessor.get(objectId, object);
    }

    public IFormatter getFormatter(ObjectId objectId) {
        return this.dataSourceAccessor.getFormatter(objectId);
    }

    public boolean set(ObjectId objectId, Object object) {
        boolean bl = false;
        SetResult setResult = this.setNoWait(objectId, object);
        try {
            bl = setResult.wasSuccessful();
        }
        catch (CommunicationException communicationException) {
            logger.error((Object)communicationException);
            logger.error("set failed oid=" + String.valueOf(objectId) + " value=" + String.valueOf(object));
        }
        return bl;
    }

    public SetResult setNoWait(ObjectId objectId, Object object) {
        return this.dataSourceAccessor.setNoWait(objectId, object);
    }

    public boolean hasValue(String string) {
        return this.theValues.containsKey(string);
    }

    public void setValue(String string, Object object) {
        this.theValues.put(string, object);
    }

    public Object getValue(String string) {
        return this.theValues.get(string);
    }

    public String stringValue(String string) {
        String string2 = (String)this.getValue(string);
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    public boolean booleanValue(String string) {
        Boolean bl = (Boolean)this.getValue(string);
        if (bl == null) {
            bl = Boolean.FALSE;
        }
        return bl;
    }

    public String getPostQueryValue(String string) {
        Object object = null;
        Object[] objectArray = null;
        if (this.thePostOrQueryString != null) {
            objectArray = this.thePostOrQueryString.get(string);
            if (ArrayUtils.isNotEmpty((Object[])objectArray)) {
                object = objectArray[0];
            }
            if (StringUtils.isNotBlank(object)) {
                logger.debug("getPostQueryValue() - found entry for key: {}", (Object)string);
            } else {
                logger.debug("getPostQueryValue() - no value found for for key: {}", (Object)string);
            }
        } else {
            logger.info("getPostQueryValue is null");
        }
        return object;
    }

    public Map<String, String[]> getPostQueryValues() {
        return this.thePostOrQueryString;
    }

    public boolean hasPostQueryValue(String string) {
        return this.getPostQueryValue(string) != null;
    }

    public void writeHTML(HTML hTML) {
        StringBuilder stringBuilder = hTML.toHTML(this);
        stringBuilder.trimToSize();
        this.theOutputWriter.print(stringBuilder.toString());
    }

    public String format(ObjectId objectId) {
        String string = null;
        Object object = this.get(objectId);
        if (object != null) {
            try {
                IFormatter iFormatter = this.getFormatter(objectId);
                if (iFormatter != null) {
                    string = iFormatter.format(object, this.getLocale());
                } else {
                    logger.warn("format: No formatter supported - " + objectId.toString());
                }
            }
            catch (FormatterException formatterException) {
                logger.error((Object)formatterException);
            }
            catch (UnsupportedLocaleException unsupportedLocaleException) {
                logger.error((Object)unsupportedLocaleException);
            }
        }
        return string;
    }

    public static Hashtable<String, String> parsePostedData(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), "=");
            String string2 = stringTokenizer2.nextToken();
            String string3 = stringTokenizer2.nextToken();
            hashtable.put(string2, string3);
        }
        return hashtable;
    }

    public void addFormToken(Form form) {
        if (this.theRequest != null) {
            String string = (String)this.theRequest.getAttribute("formtoken");
            String string2 = (String)this.theRequest.getAttribute("formtokenid");
            if (string != null && string2 != null) {
                Input input = new Input();
                input.setName("formtoken");
                input.setId("formtoken");
                input.setType("hidden");
                input.setValue(string);
                form.add(input);
                Input input2 = new Input();
                input2.setName("formtokenid");
                input2.setId("formtokenid");
                input2.setType("hidden");
                input2.setValue(string2);
                form.add(input2);
            }
        }
    }

    @Generated
    public M11DataSourceAccessor getDataSourceAccessor() {
        return this.dataSourceAccessor;
    }
}

