/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.html.apc;

import com.apcc.m11.components.webserver.html.Container;
import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.HTMLTagWithClassStyle;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.Text;
import com.apcc.m11.components.webserver.html.apc.ApcHelp;
import com.apcc.m11.components.webserver.html.apc.ApcPage;
import com.apcc.m11.components.webserver.html.apc.ApcSectionHeader;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.html.util.Anchor;
import com.apcc.m11.components.webserver.util.FormHelper;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.util.Locale;

public class ApcErrorPage
implements HTML {
    public static final String ATTR_ERROR_MESSAGE = "message";
    public static final String ATTR_ERROR_CODE = "code";
    public static final String ATTR_ERROR_URL = "uri";
    private static final String kErrorHeader = "PCNS.ErrorHeader";
    private static final String kURLLabel = "PCNS.ErrorURLLabel";
    private static final String kReasonLabel = "PCNS.ErrorReasonLabel";
    private static final String kBackLink = "PCNS.ErrorBackLink";
    private String theErrorHeaderText;
    private ApcPage thePage;
    private String theURLLabelText;
    private String theReasonLabelText;
    private String theBackLinkText;

    public ApcErrorPage(boolean bl, ServiceManager serviceManager) {
        this.thePage = new ApcPage(bl, bl, serviceManager);
    }

    @Override
    public StringBuilder toHTML(PageContext pageContext) {
        Object object;
        this.setupLanguage(pageContext.getLocale());
        this.thePage.addStyleSheet("styles/form.css");
        ApcSectionHeader apcSectionHeader = new ApcSectionHeader(this.theErrorHeaderText, "");
        apcSectionHeader.setHelpId(ApcHelp.NO_HELP);
        this.thePage.add(apcSectionHeader);
        Division division = new Division();
        this.thePage.add(division);
        division.setId("maindiv");
        division.setCssClass("formdiv");
        if (pageContext.getRequest().getAttribute(ATTR_ERROR_URL) != null) {
            division.add(FormHelper.createLabelValueDiv(ATTR_ERROR_URL, this.theURLLabelText, (String)pageContext.getRequest().getAttribute(ATTR_ERROR_URL), null));
        }
        if (pageContext.getRequest().getAttribute(ATTR_ERROR_CODE) != null) {
            object = String.valueOf(pageContext.getRequest().getAttribute(ATTR_ERROR_CODE)) + " " + String.valueOf(pageContext.getRequest().getAttribute(ATTR_ERROR_MESSAGE));
            division.add(FormHelper.createLabelValueDiv("reason", this.theReasonLabelText, (String)object, null));
        } else if (pageContext.getRequest().getAttribute(ATTR_ERROR_MESSAGE) != null) {
            division.add(FormHelper.createLabelValueDiv(ATTR_ERROR_MESSAGE, this.theReasonLabelText, (String)pageContext.getRequest().getAttribute(ATTR_ERROR_MESSAGE), null));
        }
        object = new Anchor();
        division.add((HTML)object);
        ((HTMLTagWithClassStyle)object).setId("buttondiv");
        ((Anchor)object).setHypertextReference("/index.html");
        ((Container)object).add(new Text(this.theBackLinkText));
        return this.thePage.toHTML(pageContext);
    }

    private void setupLanguage(Locale locale) {
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        this.theErrorHeaderText = Utils.getResourceString(resourceBundleWrapper, kErrorHeader);
        this.theURLLabelText = Utils.getResourceString(resourceBundleWrapper, kURLLabel);
        this.theReasonLabelText = Utils.getResourceString(resourceBundleWrapper, kReasonLabel);
        this.theBackLinkText = Utils.getResourceString(resourceBundleWrapper, kBackLink);
    }
}

