/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.html.apc;

import com.apcc.m11.components.autoupdate.AutoUpdateComponent;
import com.apcc.m11.components.webserver.html.Container;
import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.HTMLTagWithAlignClassStyle;
import com.apcc.m11.components.webserver.html.HTMLTagWithClassStyle;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.Text;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.html.document.Nav;
import com.apcc.m11.components.webserver.html.list.ListItem;
import com.apcc.m11.components.webserver.html.list.UnOrderedList;
import com.apcc.m11.components.webserver.html.util.Anchor;
import com.apcc.m11.components.webserver.model.MenuItem;
import com.apcc.m11.components.webserver.util.MenuHelper;
import com.apcc.pcns.ServiceManager;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ApcMenu
implements HTML {
    private static final Logger logger = LogManager.getLogger(ApcMenu.class);
    private ServiceManager services;
    private List<MenuItem> menuList = new ArrayList<MenuItem>();

    public ApcMenu(@NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
    }

    private String getServletPath(PageContext pageContext) {
        Object object = pageContext.getRequest().getServletPath();
        if (((String)object).equals("/upsconfig")) {
            String string = (String)pageContext.getSession().getAttribute("nmcip");
            if (string != null) {
                object = (String)object + "?nmcip=" + string;
            }
        } else if (((String)object).equals("/ConnectedServers")) {
            String string = pageContext.getPostQueryValue("setup");
            if (string != null) {
                object = (String)object + "?setup=" + string;
            }
        } else if (((String)object).equals("/individualvmsettings")) {
            String string = pageContext.getPostQueryValue("setup");
            if (string != null) {
                object = (String)object + "?setup=" + string;
            }
        } else if (((String)object).equals("/advancedsshsettings")) {
            String string = pageContext.getPostQueryValue("setup");
            if (string != null) {
                object = (String)object + "?setup=" + string;
            }
        } else if (((String)object).startsWith("/DisplayEventDetails") || ((String)object).startsWith("/cfglogevent") || ((String)object).startsWith("/cfgnotifyusers") || ((String)object).startsWith("/cfgruncmdfile") || ((String)object).startsWith("/cfgshutdown")) {
            object = "/selectevents";
        }
        logger.debug("servletPath=" + (String)object);
        return object;
    }

    public List<MenuItem> getMenuList() {
        return this.menuList;
    }

    public void addMenu(MenuItem menuItem) {
        this.menuList.add(menuItem);
    }

    public void clearMenuList() {
        this.menuList.clear();
    }

    @Override
    public StringBuilder toHTML(PageContext pageContext) {
        Object object;
        HTMLTagWithAlignClassStyle hTMLTagWithAlignClassStyle;
        MenuHelper menuHelper = new MenuHelper(this.services);
        menuHelper.createMenu(this, pageContext);
        String string = this.getServletPath(pageContext);
        StringBuilder stringBuilder = new StringBuilder();
        Nav nav = new Nav();
        nav.setId("menu");
        if (AutoUpdateComponent.isJapanese()) {
            nav.setCssClass("ui-corner-all japanese");
        } else {
            nav.setCssClass("ui-corner-all");
        }
        UnOrderedList unOrderedList = new UnOrderedList();
        nav.add(unOrderedList);
        for (MenuItem object22 : this.menuList) {
            hTMLTagWithAlignClassStyle = this.createMenuListItem(object22, "mainMenuLevelListItem");
            unOrderedList.add(hTMLTagWithAlignClassStyle);
            if (!object22.hasSubMenu()) continue;
            object = new UnOrderedList();
            ((HTMLTagWithClassStyle)object).setCssClass("firstLevelMenuList");
            hTMLTagWithAlignClassStyle.add((HTML)object);
            for (MenuItem menuItem : object22.getSubMenu()) {
                ListItem listItem = this.createMenuListItem(menuItem, "firstLevelListItem");
                ((Container)object).add(listItem);
                if (!menuItem.hasSubMenu()) continue;
                UnOrderedList unOrderedList2 = new UnOrderedList();
                unOrderedList2.setCssClass("secondLevelMenuList");
                listItem.add(unOrderedList2);
                for (MenuItem menuItem2 : menuItem.getSubMenu()) {
                    unOrderedList2.add(this.createMenuListItem(menuItem2, null));
                }
            }
        }
        Division division = new Division();
        nav.add(division);
        division.setCssClass("StatusIconTray");
        division.setId("StatusIconTray");
        Division division2 = new Division();
        division2.setId("aboutDialog");
        hTMLTagWithAlignClassStyle = new Division();
        hTMLTagWithAlignClassStyle.setId("aboutContainer");
        division2.add(hTMLTagWithAlignClassStyle);
        object = new MenuHelper(this.services);
        division2.add(((MenuHelper)object).getAboutPageResourceStrings(pageContext));
        stringBuilder.append((CharSequence)nav.toHTML(pageContext));
        stringBuilder.append((CharSequence)division2.toHTML(pageContext));
        stringBuilder.trimToSize();
        return stringBuilder;
    }

    private ListItem createMenuListItem(MenuItem menuItem, String string) {
        ListItem listItem = new ListItem();
        listItem.add(this.createMenuAnchor(menuItem));
        if (string != null) {
            listItem.setCssClass(string);
        }
        return listItem;
    }

    private Anchor createMenuAnchor(MenuItem menuItem) {
        Anchor anchor = new Anchor();
        anchor.setHypertextReference("#");
        anchor.setCssClass("menuAnchor");
        if (menuItem.getPath() != null) {
            anchor.setHypertextReference(menuItem.getPath());
            if (menuItem.isOpenInNewPage()) {
                anchor.setTarget("_blank");
            }
            if (menuItem.getId() != null && !menuItem.getId().isEmpty()) {
                anchor.setId(menuItem.getId());
            }
        }
        anchor.add(new Text(menuItem.getName()));
        return anchor;
    }

    private void setupMenu(PageContext pageContext) {
    }
}

