/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.html.apc;

import com.apcc.m11.components.webserver.cfgwizard.states.CfgWizardState;
import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.Text;
import com.apcc.m11.components.webserver.html.apc.ApcBanner;
import com.apcc.m11.components.webserver.html.apc.ApcMenu;
import com.apcc.m11.components.webserver.html.apc.ApcSectionHeader;
import com.apcc.m11.components.webserver.html.document.Body;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.html.document.Head;
import com.apcc.m11.components.webserver.html.document.Html;
import com.apcc.m11.components.webserver.html.document.Meta;
import com.apcc.m11.components.webserver.html.document.Script;
import com.apcc.m11.components.webserver.html.document.Section;
import com.apcc.m11.components.webserver.html.document.Span;
import com.apcc.m11.components.webserver.html.document.Title;
import com.apcc.m11.components.webserver.html.html5.HTML5Shiv;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.util.Locale;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ApcPage
implements HTML {
    public static final String CLASS_HIDDEN = "hidden";
    private static final Logger logger = LogManager.getLogger(ApcPage.class);
    private static final String PRODUCT_ID = "Login.Product";
    private static final String BLOCK_NAVIGATION = "PCNS.BlockNavWarningText";
    private Html thePage = new Html();
    private Body theBody = new Body();
    private Division theContainer = new Division();
    private Section theContent = new Section();
    private Head theHead = new Head();
    private ApcBanner theBanner = new ApcBanner();
    private ApcMenu theMenu = null;
    private String defaultPageTitle = "PowerChute Network Shutdown";
    private String blockNavWarningText;
    private boolean hasTitle = false;
    private boolean usageTracking = true;
    private ServiceManager services;

    public ApcPage(ServiceManager serviceManager) {
        this(true, true, serviceManager);
    }

    public ApcPage(boolean bl, boolean bl2, @NonNull ServiceManager serviceManager) {
        this(bl, bl2, true, serviceManager);
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
    }

    public ApcPage(boolean bl, boolean bl2, boolean bl3, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
        this.usageTracking = bl3;
        this.thePage.add(this.theHead);
        this.thePage.add(this.theBody);
        this.theBody.add(this.theContainer);
        this.theContainer.add(this.theBanner);
        if (bl2) {
            this.theMenu = new ApcMenu(this.services);
            this.theContainer.add(this.theMenu);
        }
        this.theContainer.add(this.theContent);
        this.theContainer.setId("container");
        this.theContent.setId("content");
        Meta meta = new Meta();
        meta.setCharset("utf-8");
        this.theHead.add(meta);
        meta = new Meta();
        meta.setName("viewport");
        meta.setContent("width=980");
        this.theHead.add(meta);
        this.theHead.addStyleSheet("styles/normalize.css");
        this.theHead.addStyleSheet("styles/jquery-ui.min.css");
        this.theHead.addStyleSheet("styles/common.css");
        if (bl2) {
            this.theHead.addStyleSheet("styles/menu.css");
        }
        this.theHead.add(new HTML5Shiv());
        this.theHead.addScript("scripts/jquery.min.js");
        this.theHead.addScript("scripts/jquery-ui.min.js");
        this.theHead.addScript("scripts/uidialoghelpbtn.js");
        this.theHead.addScript("scripts/all.js");
        this.theHead.addScript("scripts/RoboHelp_CSH.js");
        this.theHead.addScript("scripts/content.js");
        if (bl3) {
            this.theHead.addScript("scripts/countlySDK.js");
            this.theHead.addScript("scripts/countlyPCNS.js");
        }
        if (bl2) {
            this.theHead.addScript("scripts/menu.js");
        }
        if (bl) {
            Division division = new Division();
            division.setId("heartbeat");
            division.setCssClass("Heartbeat");
            this.theContent.add(division);
        }
    }

    public void addSection(String string, String string2) {
        this.theContent.add(new ApcSectionHeader(string, string2));
    }

    public void addSection(String string) {
        this.theContent.add(new ApcSectionHeader(string, null));
    }

    public void add(HTML hTML) {
        this.theContent.add(hTML);
    }

    public void addScript(Script script) {
        this.theHead.add(script);
    }

    public void addScript(String string) {
        this.theHead.addScript(string);
    }

    public void addStyleSheet(String string) {
        this.theHead.addStyleSheet(string);
    }

    public void addToHeader(HTML hTML) {
        this.theHead.add(hTML);
    }

    public void addTitle(String string) {
        if (!this.hasTitle) {
            Title title = new Title();
            title.add(new Text(string));
            this.theHead.addAsFirst(title);
            this.hasTitle = true;
        }
    }

    public void addOnLoad(String string) {
        this.theBody.addOnLoad(string);
    }

    public void clearOnLoad() {
        this.theBody.clearOnLoad();
    }

    @Override
    public StringBuilder toHTML(PageContext pageContext) {
        if (Utils.isSupportedLocale(pageContext.getLocale())) {
            this.thePage.setLanguage(pageContext.getLocale().getLanguage());
        } else {
            this.thePage.setLanguage(Locale.ENGLISH.getLanguage());
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.setupLanguage(pageContext.getLocale());
        if (!this.hasTitle) {
            this.addTitle(this.defaultPageTitle);
        }
        Span span = new Span(this.blockNavWarningText);
        span.setId("blockNavigationWarning");
        span.setStyle("display: none;");
        this.theBody.add(span);
        if (this.usageTracking) {
            CfgWizardState cfgWizardState;
            String string;
            Object object = pageContext.getSession().getAttribute("currentState");
            if (object instanceof CfgWizardState && (string = (cfgWizardState = (CfgWizardState)object).getId()) != null) {
                this.theBody.add(new Span("countlyWizPage", string).setCssClass(CLASS_HIDDEN));
            }
            this.theBody.add(new Span("countlyApplicationKey", this.services.getAnalyticsService().getApplicationKey()).setCssClass(CLASS_HIDDEN));
            this.theBody.add(new Span("countlyApplicationURL", this.services.getAnalyticsService().getApplicationURL()).setCssClass(CLASS_HIDDEN));
            this.theBody.add(new Span("countlyApplicationSalt", this.services.getAnalyticsService().getApplicationSalt()).setCssClass(CLASS_HIDDEN));
            this.theBody.add(new Span("countlyServerID", this.services.getProductVersion().getServerID()).setCssClass(CLASS_HIDDEN));
            this.theBody.add(new Span("countlyVersion", this.services.getProductVersion().getVersion()).setCssClass(CLASS_HIDDEN));
            boolean bl = !Boolean.FALSE.equals(this.services.getAnalyticsService().isCEIPEnabled());
            this.theBody.add(new Span("countlyHasConsent", Boolean.toString(bl)).setCssClass(CLASS_HIDDEN));
        }
        stringBuilder.append((CharSequence)this.thePage.toHTML(pageContext));
        stringBuilder.trimToSize();
        return stringBuilder;
    }

    private void setupLanguage(Locale locale) {
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        this.defaultPageTitle = Utils.getResourceString(resourceBundleWrapper, PRODUCT_ID);
        this.blockNavWarningText = Utils.getResourceString(resourceBundleWrapper, BLOCK_NAVIGATION);
    }
}

