/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.html.apc;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ApcServerName {
    private static final Logger logger = LogManager.getLogger(ApcServerName.class);
    private static ApcServerName theInstance = null;
    private String serverName = null;

    protected ApcServerName() {
        this.initialize();
    }

    public static synchronized ApcServerName getInstance() {
        if (theInstance == null) {
            theInstance = new ApcServerName();
        }
        return theInstance;
    }

    private synchronized void initialize() {
        this.serverName = "*";
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            logger.trace("UnknownHostException", (Throwable)unknownHostException);
            try {
                Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
                while (enumeration.hasMoreElements()) {
                    Enumeration<InetAddress> enumeration2 = enumeration.nextElement().getInetAddresses();
                    InetAddress inetAddress2 = null;
                    while (enumeration2.hasMoreElements()) {
                        inetAddress2 = enumeration2.nextElement();
                        if (inetAddress2.isLoopbackAddress()) continue;
                        inetAddress = inetAddress2;
                    }
                    if (inetAddress != null) continue;
                    logger.trace("Use the loopback if there is one" + String.valueOf(inetAddress2));
                    inetAddress = inetAddress2;
                }
            }
            catch (SocketException socketException) {
                logger.trace("getName SocketException:", (Throwable)unknownHostException);
            }
        }
        if (inetAddress != null) {
            int n;
            logger.trace("Using localhost");
            String string = inetAddress.getHostAddress();
            this.serverName = inetAddress.getHostName();
            if (!string.equalsIgnoreCase(this.serverName) && (n = this.serverName.indexOf(".")) > 0) {
                this.serverName = this.serverName.substring(0, n);
            }
            logger.trace("Using localhost done " + this.serverName);
        }
    }

    public String getName() {
        return this.serverName;
    }
}

