/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.html.form;

import com.apcc.m11.components.webserver.html.HTMLwithId;
import com.apcc.m11.components.webserver.html.PageContext;
import org.apache.commons.text.StringEscapeUtils;

public class Input
implements HTMLwithId {
    private String theAlignment = null;
    private boolean theCheck = false;
    private String theMaxLength = null;
    private String theName = null;
    private String theSize = null;
    private String theType = null;
    private String theClass = null;
    private String theValue = null;
    private String theId = null;
    private String theOnClick = null;
    private String theOnKeyPress = null;
    private String theOnKeyUp = null;
    private Boolean theDisable = null;
    private Boolean theAutoComplete = null;
    private String theTitle = null;
    private String theFileType = null;

    public void setClassName(String string) {
        this.theClass = string;
    }

    public void addClass(String string) {
        this.theClass = this.theClass != null && !this.theClass.trim().isEmpty() ? this.theClass + " " + string : string;
    }

    public void setAlignment(String string) {
        this.theAlignment = string;
    }

    public void setCheck(boolean bl) {
        this.theCheck = bl;
    }

    public void setDisable(boolean bl) {
        this.theDisable = bl;
    }

    public void setAutoComplete(boolean bl) {
        this.theAutoComplete = bl;
    }

    public void setTitle(String string) {
        this.theTitle = string;
    }

    public void setMaxLength(String string) {
        this.theMaxLength = string;
    }

    @Override
    public void setName(String string) {
        this.theName = string;
    }

    public void setSize(String string) {
        this.theSize = string;
    }

    public void setType(String string) {
        this.theType = string;
        this.theClass = string.equalsIgnoreCase("submit") || string.equalsIgnoreCase("reset") || string.equalsIgnoreCase("button") ? "newbutton" : (string.equalsIgnoreCase("PASSWORD") ? "password" : this.theType);
    }

    public void setValue(String string) {
        this.theValue = string;
    }

    public String getId() {
        return this.theId;
    }

    @Override
    public void setId(String string) {
        this.theId = string;
    }

    public void setOnClick(String string) {
        this.theOnClick = string;
    }

    public void setOnKeyPress(String string) {
        this.theOnKeyPress = string;
    }

    public void setOnKeyUp(String string) {
        this.theOnKeyUp = string;
    }

    public void setAcceptFileType(String string) {
        this.theFileType = string;
    }

    @Override
    public void setDataJstree(String string) {
    }

    @Override
    public StringBuilder toHTML(PageContext pageContext) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<input ");
        if (this.theId != null) {
            stringBuilder.append(" id=\"" + this.theId + "\"");
        }
        if (this.theAlignment != null) {
            stringBuilder.append(" align=\"" + this.theAlignment + "\"");
        }
        if (this.theCheck) {
            stringBuilder.append(" checked=\"checked\"");
        }
        if (this.theDisable != null && this.theDisable.booleanValue()) {
            stringBuilder.append(" disabled=\"disabled\"");
        }
        if (this.theMaxLength != null) {
            stringBuilder.append(" maxlength=\"" + this.theMaxLength + "\"");
        }
        if (this.theName != null) {
            stringBuilder.append(" name=\"" + this.theName + "\"");
        }
        if (this.theSize != null) {
            stringBuilder.append(" size=\"" + this.theSize + "\"");
        }
        if (this.theType != null) {
            stringBuilder.append(" type=\"" + this.theType + "\"");
        }
        if (this.theClass != null && !this.theClass.trim().isEmpty()) {
            stringBuilder.append(" class=\"" + this.theClass + "\"");
        }
        if (this.theAutoComplete != null) {
            if (this.theAutoComplete.booleanValue()) {
                stringBuilder.append(" autocomplete=\"on\"");
            } else {
                stringBuilder.append(" autocomplete=\"off\"");
            }
        }
        if (this.theValue != null) {
            String string = StringEscapeUtils.escapeHtml4((String)this.theValue);
            stringBuilder.append(" value=\"" + string + "\"");
        }
        if (this.theTitle != null) {
            stringBuilder.append(" title=\"" + this.theTitle + "\"");
        }
        if (this.theOnClick != null) {
            stringBuilder.append(" onclick=\"" + this.theOnClick + "\"");
        }
        if (this.theOnKeyPress != null) {
            stringBuilder.append(" onkeypress=\"" + this.theOnKeyPress + "\"");
        }
        if (this.theOnKeyUp != null) {
            stringBuilder.append(" onkeyup=\"" + this.theOnKeyUp + "\"");
        }
        if (this.theFileType != null) {
            stringBuilder.append("accept=\"" + this.theFileType + "\"");
        }
        stringBuilder.append(">");
        stringBuilder.trimToSize();
        return stringBuilder;
    }

    protected String getValue() {
        return this.theValue;
    }
}

