/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.html.table;

import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.HTMLDebug;
import com.apcc.m11.components.webserver.html.HTMLTagWithAlignBackgroundColorClassStyle;
import com.apcc.m11.components.webserver.html.table.TableBody;
import com.apcc.m11.components.webserver.html.table.TableHead;
import com.apcc.m11.components.webserver.html.table.TableRow;

public class Table
extends HTMLTagWithAlignBackgroundColorClassStyle {
    private static final String kTag = "table";
    private static final String kBorderOption = "border";
    private static final String kCellPaddingOption = "cellpadding";
    private static final String kCellSpacingOption = "cellspacing";
    private static final String kColumnsOption = "cols";
    private static final String kFrameOption = "frame";
    private static final String kHorizontalSpaceOption = "hspace";
    private static final String kVerticalSpaceOption = "vspace";
    private static final String kWidthOption = "width";
    private static final String kHeightOption = "height";
    private TableHead head = null;
    private TableBody body = null;

    public Table() {
        this.setTag(kTag);
        if (HTMLDebug.isLoudTablesEnabled()) {
            this.setBorder("");
        }
    }

    public Table(boolean bl) {
        this();
        if (bl) {
            this.head = new TableHead();
            this.add(this.head);
            this.body = new TableBody();
            this.add(this.body);
        }
    }

    public void setBorder(String string) {
        if (HTMLDebug.isLoudTablesEnabled()) {
            this.setOption(kBorderOption, "1");
        } else {
            this.setOption(kBorderOption, string);
        }
    }

    public void addRow(HTML hTML) {
        if (this.body != null) {
            this.body.add(hTML);
        } else {
            this.add(new TableRow(hTML));
        }
    }

    public void addHeaderRow(HTML hTML) {
        if (this.head != null) {
            this.head.add(hTML);
        }
    }

    public void setCellPadding(String string) {
        this.setOption(kCellPaddingOption, string);
    }

    public void setCellSpacing(String string) {
        this.setOption(kCellSpacingOption, string);
    }

    public void setColumns(String string) {
        this.setOption(kColumnsOption, string);
    }

    public void setFrame(String string) {
        this.setOption(kFrameOption, string);
    }

    public void setHorizontalSpace(String string) {
        this.setOption(kHorizontalSpaceOption, string);
    }

    public void setVerticalSpace(String string) {
        this.setOption(kVerticalSpaceOption, string);
    }

    public void setWidth(String string) {
        this.setOption(kWidthOption, string);
    }

    public void setHeight(String string) {
        this.setOption(kHeightOption, string);
    }
}

