/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.model;

import com.apcc.m11.components.webserver.model.Cluster;
import com.apcc.m11.components.webserver.model.Host;
import com.apcc.m11.components.webserver.model.VM;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Datacenter {
    private String name;
    private List<Host> hostList = new ArrayList<Host>();
    private List<VM> vMList = new ArrayList<VM>();
    private List<Cluster> clusterList = new ArrayList<Cluster>();

    public Datacenter(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public List<Host> getHostList() {
        return this.hostList;
    }

    public List<VM> getVMList() {
        return this.vMList;
    }

    public List<Cluster> getClusterList() {
        return this.clusterList;
    }

    public void addHost(Host host) {
        if (host.getCluster() != null) {
            Cluster cluster = this.findCluster(host.getCluster());
            if (cluster == null) {
                cluster = new Cluster(host.getCluster());
                this.clusterList.add(cluster);
            }
            cluster.addHost(host);
        } else {
            this.hostList.add(host);
        }
    }

    public void addVM(VM vM) {
        if (vM.getCluster() != null) {
            Cluster cluster = this.findCluster(vM.getCluster());
            if (cluster == null) {
                cluster = new Cluster(vM.getCluster());
                this.clusterList.add(cluster);
            }
            cluster.addVM(vM);
        } else {
            this.vMList.add(vM);
        }
    }

    public Cluster findCluster(String string) {
        for (Cluster cluster : this.clusterList) {
            if (!cluster.getName().equals(string)) continue;
            return cluster;
        }
        return null;
    }

    public boolean isEmpty() {
        boolean bl;
        block1: {
            Cluster cluster;
            bl = this.hostList.isEmpty();
            if (!bl) break block1;
            Iterator<Cluster> iterator = this.clusterList.iterator();
            while (iterator.hasNext() && (bl = (cluster = iterator.next()).isEmpty())) {
            }
        }
        return bl;
    }
}

