/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.model;

import com.apcc.m11.components.webserver.model.SSHActionTrigger;
import com.apcc.pcns.sshservice.SshSession;
import com.github.cliftonlabs.json_simple.JsonObject;
import com.github.cliftonlabs.json_simple.Jsonable;
import java.io.IOException;
import java.io.Writer;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class SSHSettings
implements Jsonable {
    private int index;
    @NonNull
    private String name;
    @NonNull
    private String username;
    private String password;
    private String sshKeyPath;
    private String sshKeyPassword;
    @NonNull
    private String targetHost;
    private int port = 22;
    @NonNull
    private String commandFilePath;
    private int delay = 0;
    private int duration = 120;
    private SSHActionTrigger trigger = SSHActionTrigger.AFTER_HOST_SHUTDOWN;
    private boolean enabled = false;
    private String customPrompt = null;

    public int getRuntime() {
        return this.delay + this.duration;
    }

    public String getSection() {
        return "SSHAction" + this.index;
    }

    public SshSession.SshConnectionConfig getSSHConnectionConfig() {
        SshSession.SshConnectionConfig sshConnectionConfig = new SshSession.SshConnectionConfig();
        sshConnectionConfig.username = this.username;
        sshConnectionConfig.host = this.targetHost;
        sshConnectionConfig.password = this.password;
        sshConnectionConfig.sshKeyLocation = this.sshKeyPath;
        sshConnectionConfig.keyPassphrase = this.sshKeyPassword;
        sshConnectionConfig.port = this.port;
        return sshConnectionConfig;
    }

    public String toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.put((Object)"index", (Object)this.index);
        jsonObject.put((Object)"name", (Object)this.name);
        jsonObject.put((Object)"username", (Object)this.username);
        if (StringUtils.isNotEmpty((CharSequence)this.password)) {
            jsonObject.put((Object)"password", (Object)this.password);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.sshKeyPath)) {
            jsonObject.put((Object)"sshKeyPath", (Object)this.sshKeyPath);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.sshKeyPassword)) {
            jsonObject.put((Object)"sshKeyPassword", (Object)this.sshKeyPassword);
        }
        jsonObject.put((Object)"host", (Object)this.targetHost);
        jsonObject.put((Object)"port", (Object)this.port);
        jsonObject.put((Object)"commandFilePath", (Object)this.commandFilePath);
        jsonObject.put((Object)"delay", (Object)this.delay);
        jsonObject.put((Object)"duration", (Object)this.duration);
        jsonObject.put((Object)"trigger", (Object)this.trigger.getIniSetting());
        jsonObject.put((Object)"enabled", (Object)this.enabled);
        return jsonObject.toJson();
    }

    public void toJson(Writer writer) throws IOException {
        writer.write(this.toJson());
    }

    public boolean hasSshKeyPassword() {
        return StringUtils.isNotEmpty((CharSequence)this.sshKeyPassword);
    }

    public boolean hasUsername() {
        return StringUtils.isNotEmpty((CharSequence)this.username);
    }

    public boolean hasPassword() {
        return StringUtils.isNotEmpty((CharSequence)this.password);
    }

    @Generated
    public SSHSettings(@NonNull String string, @NonNull String string2, @NonNull String string3, @NonNull String string4) {
        if (string == null) {
            throw new IllegalArgumentException("name is marked non-null but is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("username is marked non-null but is null");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("targetHost is marked non-null but is null");
        }
        if (string4 == null) {
            throw new IllegalArgumentException("commandFilePath is marked non-null but is null");
        }
        this.name = string;
        this.username = string2;
        this.targetHost = string3;
        this.commandFilePath = string4;
    }

    @Generated
    public int getIndex() {
        return this.index;
    }

    @NonNull
    @Generated
    public String getName() {
        return this.name;
    }

    @NonNull
    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getSshKeyPath() {
        return this.sshKeyPath;
    }

    @Generated
    public String getSshKeyPassword() {
        return this.sshKeyPassword;
    }

    @NonNull
    @Generated
    public String getTargetHost() {
        return this.targetHost;
    }

    @Generated
    public int getPort() {
        return this.port;
    }

    @NonNull
    @Generated
    public String getCommandFilePath() {
        return this.commandFilePath;
    }

    @Generated
    public int getDelay() {
        return this.delay;
    }

    @Generated
    public int getDuration() {
        return this.duration;
    }

    @Generated
    public SSHActionTrigger getTrigger() {
        return this.trigger;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public String getCustomPrompt() {
        return this.customPrompt;
    }

    @Generated
    public void setIndex(int n) {
        this.index = n;
    }

    @Generated
    public void setName(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("name is marked non-null but is null");
        }
        this.name = string;
    }

    @Generated
    public void setUsername(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("username is marked non-null but is null");
        }
        this.username = string;
    }

    @Generated
    public void setPassword(String string) {
        this.password = string;
    }

    @Generated
    public void setSshKeyPath(String string) {
        this.sshKeyPath = string;
    }

    @Generated
    public void setSshKeyPassword(String string) {
        this.sshKeyPassword = string;
    }

    @Generated
    public void setTargetHost(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("targetHost is marked non-null but is null");
        }
        this.targetHost = string;
    }

    @Generated
    public void setPort(int n) {
        this.port = n;
    }

    @Generated
    public void setCommandFilePath(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("commandFilePath is marked non-null but is null");
        }
        this.commandFilePath = string;
    }

    @Generated
    public void setDelay(int n) {
        this.delay = n;
    }

    @Generated
    public void setDuration(int n) {
        this.duration = n;
    }

    @Generated
    public void setTrigger(SSHActionTrigger sSHActionTrigger) {
        this.trigger = sSHActionTrigger;
    }

    @Generated
    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @Generated
    public void setCustomPrompt(String string) {
        this.customPrompt = string;
    }

    @Generated
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SSHSettings)) {
            return false;
        }
        SSHSettings sSHSettings = (SSHSettings)object;
        if (!sSHSettings.canEqual(this)) {
            return false;
        }
        if (this.getIndex() != sSHSettings.getIndex()) {
            return false;
        }
        if (this.getPort() != sSHSettings.getPort()) {
            return false;
        }
        if (this.getDelay() != sSHSettings.getDelay()) {
            return false;
        }
        if (this.getDuration() != sSHSettings.getDuration()) {
            return false;
        }
        if (this.isEnabled() != sSHSettings.isEnabled()) {
            return false;
        }
        String string = this.getName();
        String string2 = sSHSettings.getName();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        String string3 = this.getUsername();
        String string4 = sSHSettings.getUsername();
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            return false;
        }
        String string5 = this.getPassword();
        String string6 = sSHSettings.getPassword();
        if (string5 == null ? string6 != null : !string5.equals(string6)) {
            return false;
        }
        String string7 = this.getSshKeyPath();
        String string8 = sSHSettings.getSshKeyPath();
        if (string7 == null ? string8 != null : !string7.equals(string8)) {
            return false;
        }
        String string9 = this.getSshKeyPassword();
        String string10 = sSHSettings.getSshKeyPassword();
        if (string9 == null ? string10 != null : !string9.equals(string10)) {
            return false;
        }
        String string11 = this.getTargetHost();
        String string12 = sSHSettings.getTargetHost();
        if (string11 == null ? string12 != null : !string11.equals(string12)) {
            return false;
        }
        String string13 = this.getCommandFilePath();
        String string14 = sSHSettings.getCommandFilePath();
        if (string13 == null ? string14 != null : !string13.equals(string14)) {
            return false;
        }
        SSHActionTrigger sSHActionTrigger = this.getTrigger();
        SSHActionTrigger sSHActionTrigger2 = sSHSettings.getTrigger();
        if (sSHActionTrigger == null ? sSHActionTrigger2 != null : !((Object)((Object)sSHActionTrigger)).equals((Object)sSHActionTrigger2)) {
            return false;
        }
        String string15 = this.getCustomPrompt();
        String string16 = sSHSettings.getCustomPrompt();
        return !(string15 == null ? string16 != null : !string15.equals(string16));
    }

    @Generated
    protected boolean canEqual(Object object) {
        return object instanceof SSHSettings;
    }

    @Generated
    public int hashCode() {
        int n = 1;
        n = n * 59 + this.getIndex();
        n = n * 59 + this.getPort();
        n = n * 59 + this.getDelay();
        n = n * 59 + this.getDuration();
        n = n * 59 + (this.isEnabled() ? 79 : 97);
        String string = this.getName();
        n = n * 59 + (string == null ? 43 : string.hashCode());
        String string2 = this.getUsername();
        n = n * 59 + (string2 == null ? 43 : string2.hashCode());
        String string3 = this.getPassword();
        n = n * 59 + (string3 == null ? 43 : string3.hashCode());
        String string4 = this.getSshKeyPath();
        n = n * 59 + (string4 == null ? 43 : string4.hashCode());
        String string5 = this.getSshKeyPassword();
        n = n * 59 + (string5 == null ? 43 : string5.hashCode());
        String string6 = this.getTargetHost();
        n = n * 59 + (string6 == null ? 43 : string6.hashCode());
        String string7 = this.getCommandFilePath();
        n = n * 59 + (string7 == null ? 43 : string7.hashCode());
        SSHActionTrigger sSHActionTrigger = this.getTrigger();
        n = n * 59 + (sSHActionTrigger == null ? 43 : ((Object)((Object)sSHActionTrigger)).hashCode());
        String string8 = this.getCustomPrompt();
        n = n * 59 + (string8 == null ? 43 : string8.hashCode());
        return n;
    }

    @Generated
    public String toString() {
        return "SSHSettings(index=" + this.getIndex() + ", name=" + this.getName() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", sshKeyPath=" + this.getSshKeyPath() + ", sshKeyPassword=" + this.getSshKeyPassword() + ", targetHost=" + this.getTargetHost() + ", port=" + this.getPort() + ", commandFilePath=" + this.getCommandFilePath() + ", delay=" + this.getDelay() + ", duration=" + this.getDuration() + ", trigger=" + String.valueOf((Object)this.getTrigger()) + ", enabled=" + this.isEnabled() + ", customPrompt=" + this.getCustomPrompt() + ")";
    }
}

