/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.model;

import com.apcc.m11.components.stdpowersource.CommunicationsStatusLogEntry;
import com.apcc.m11.components.webserver.model.VMSettings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UPSSetup
implements Serializable {
    private static final long serialVersionUID = -2864804488892427243L;
    private static final Logger logger = LogManager.getLogger(UPSSetup.class);
    private int groupNo;
    private String nameEsc;
    private String name;
    private List<String> NMCList = new ArrayList<String>();
    private int upsRequiredForLoad = 1;
    private boolean cmdFileEnabled;
    private String cmdFilePath;
    private int cmdFileDuration;
    private int cmdFileDelay = 0;
    private boolean executeCommandFileAfterHostShutdown = false;
    private boolean localMachineShutdownEnabled = true;
    private boolean virtualHostsShutdownEnabled = false;
    private boolean redundancyLostShutdownEnabled;
    private Boolean turnOffUps = false;
    private Boolean turnOffSOG = false;
    private VMSettings vmSettings = new VMSettings();
    private Map<String, Boolean> sshSettings = new HashMap<String, Boolean>();
    private LinkedHashMap<String, Integer> HostList = new LinkedHashMap();
    private List<CommunicationsStatusLogEntry> logs;
    private List<String> NMCWithOGList = new ArrayList<String>();
    private Boolean configMixed = false;

    public UPSSetup() {
        this.logs = new ArrayList<CommunicationsStatusLogEntry>();
    }

    public String getName() {
        return this.name;
    }

    public String getNameEsc() {
        return this.nameEsc;
    }

    public void setName(String string) {
        this.name = string;
        this.nameEsc = StringEscapeUtils.escapeHtml4((String)string);
    }

    public List<String> getNMCList() {
        return this.NMCList;
    }

    public void addNMC(String string) {
        this.NMCList.add(string);
    }

    public int getUpsRequiredForLoad() {
        return this.upsRequiredForLoad;
    }

    public void setUpsRequiredForLoad(int n) {
        this.upsRequiredForLoad = n;
    }

    public boolean getCmdFileEnabled() {
        return this.cmdFileEnabled;
    }

    public void setCmdFileEnabled(boolean bl) {
        this.cmdFileEnabled = bl;
    }

    public String getCmdFilePath() {
        return this.cmdFilePath;
    }

    public void setCmdFilePath(String string) {
        this.cmdFilePath = string;
    }

    public int getCmdFileDuration() {
        return this.cmdFileDuration;
    }

    public void setCmdFileDuration(int n) {
        this.cmdFileDuration = n;
    }

    public int getCmdFileDelay() {
        return this.cmdFileDelay;
    }

    public void setCmdFileDelay(int n) {
        this.cmdFileDelay = n;
    }

    public boolean isExecuteCommandFileAfterHostShutdown() {
        return this.executeCommandFileAfterHostShutdown;
    }

    public void setExecuteCommandFileAfterHostShutdown(boolean bl) {
        this.executeCommandFileAfterHostShutdown = bl;
    }

    public boolean getLocalMachineShutdownEnabled() {
        return this.localMachineShutdownEnabled;
    }

    public void setLocalMachineShutdownEnabled(boolean bl) {
        this.localMachineShutdownEnabled = bl;
    }

    public boolean isVirtualHostsShutdownEnabled() {
        return this.virtualHostsShutdownEnabled;
    }

    public void setVirtualHostsShutdownEnabled(boolean bl) {
        this.virtualHostsShutdownEnabled = bl;
    }

    public VMSettings getVMSettings() {
        return this.vmSettings;
    }

    public boolean getRedundancyLostShutdownEnabled() {
        return this.redundancyLostShutdownEnabled;
    }

    public void setRedundancyLostShutdownEnabled(boolean bl) {
        this.redundancyLostShutdownEnabled = bl;
    }

    public int getTotalNumberOfUPS() {
        int n = 0;
        if (this.NMCList != null) {
            n = this.NMCList.size();
        }
        return n;
    }

    public int getNumberOfRedundantUPS() {
        int n = 0;
        int n2 = this.getTotalNumberOfUPS();
        if (n2 >= this.upsRequiredForLoad) {
            n = n2 - this.upsRequiredForLoad;
        }
        return n;
    }

    public Boolean containsNMC(String string) {
        return this.NMCList.contains(string);
    }

    public Integer getIndexEntry(CommunicationsStatusLogEntry communicationsStatusLogEntry) {
        int n = -1;
        int n2 = 0;
        for (CommunicationsStatusLogEntry communicationsStatusLogEntry2 : this.logs) {
            if (communicationsStatusLogEntry.getIp().equals(communicationsStatusLogEntry2.getIp())) {
                return n2;
            }
            ++n2;
        }
        return n;
    }

    public void addEntry(CommunicationsStatusLogEntry communicationsStatusLogEntry) {
        int n = this.getIndexEntry(communicationsStatusLogEntry);
        if (n != -1 && this.logs.size() > 0) {
            this.logs.set(n, communicationsStatusLogEntry);
        } else {
            this.logs.add(communicationsStatusLogEntry);
        }
    }

    public List<CommunicationsStatusLogEntry> getNMCsWithStatus() {
        return this.logs;
    }

    public void setGroup(int n) {
        this.groupNo = n;
    }

    public int getGroup() {
        return this.groupNo;
    }

    public Boolean getTurnOffUps() {
        return this.turnOffUps;
    }

    public void setTurnOffUps(Boolean bl) {
        this.turnOffUps = bl;
    }

    public Boolean getTurnOffSOG() {
        return this.turnOffSOG;
    }

    public void setTurnOffSOG(Boolean bl) {
        this.turnOffSOG = bl;
    }

    public void addNMCWithOG(String string) {
        if (!this.NMCWithOGList.contains(string)) {
            this.NMCWithOGList.add(string);
        }
    }

    public Boolean hasOutletGroups(String string) {
        return this.NMCWithOGList.contains(string);
    }

    public Boolean hasSetupNMCSWithOG() {
        return this.NMCWithOGList.size() > 0;
    }

    public Boolean isConfigMixed() {
        return this.configMixed;
    }

    public void setConfigMixed(boolean bl) {
        this.configMixed = bl;
    }

    public LinkedHashSet<String> getHosts() {
        return new LinkedHashSet<String>(this.HostList.keySet());
    }

    public Map<String, Integer> getHostsMap() {
        return this.HostList;
    }

    public LinkedHashSet<String> getHosts(int n) {
        logger.debug("getHosts:" + n);
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (Map.Entry<String, Integer> entry : this.HostList.entrySet()) {
            if (entry.getValue() == null || n != entry.getValue()) continue;
            linkedHashSet.add(entry.getKey());
        }
        return linkedHashSet;
    }

    public boolean hasHostsOnOutlets() {
        for (Map.Entry<String, Integer> entry : this.HostList.entrySet()) {
            if (entry.getValue() == null) continue;
            return true;
        }
        return false;
    }

    public void addHost(String string, Integer n) {
        this.HostList.put(string, n);
    }

    public void setSSHSetting(String string, Boolean bl) {
        if (StringUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("Section name can't be null or empty");
        }
        this.sshSettings.put(string, bl);
    }

    public void setSSHSettings(Map<String, Boolean> map) {
        this.sshSettings = new HashMap<String, Boolean>(map);
    }

    public Map<String, Boolean> getSSHSettings() {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>(this.sshSettings);
        return hashMap;
    }

    public boolean getSSHSetting(String string) {
        return this.sshSettings.get(string);
    }

    public void removeSSHSetting(String string) {
        this.sshSettings.remove(string);
    }

    public String toString() {
        return this.groupNo + ":" + this.name + " NMCs:" + String.valueOf(this.NMCList) + " Hosts:" + String.valueOf(this.HostList);
    }
}

