/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.pages;

import com.apcc.m11.components.webserver.html.Container;
import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.HTMLDebug;
import com.apcc.m11.components.webserver.html.HTMLTagWithClassStyle;
import com.apcc.m11.components.webserver.html.HTMLwithId;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.Text;
import com.apcc.m11.components.webserver.html.apc.ApcForm;
import com.apcc.m11.components.webserver.html.apc.ApcHelp;
import com.apcc.m11.components.webserver.html.apc.ApcSection;
import com.apcc.m11.components.webserver.html.apc.ApcSectionHeader;
import com.apcc.m11.components.webserver.html.apc.ApcSectionNote;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.html.form.Button;
import com.apcc.m11.components.webserver.html.form.Input;
import com.apcc.m11.components.webserver.html.util.Anchor;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.m11.ds.services.softwareupdate.SoftwareUpdateGroup;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AJAXCheckForUpdates
implements HTML {
    private static final String kIdPrefix = "Updates.";
    private static final String kAvailableUpdatesHeaderId = "Updates.AvailableUpdatesHeader";
    private static final String kAvailableUpdatesSubHeaderId = "Updates.AvailableUpdatesSubHeader";
    private static final String kAvailableUpdatesSubHeaderNoAutoUpdateId = "Updates.AvaialbleUpdatesSubHeaderNoAutoUpdate";
    private static final String kAvailableUpdatesNoneId = "Updates.AvailableUpdatesNone";
    private static final String kAvailableUpdatesId = "Updates.AvailableUpdates";
    private static final String kAvailableUpdatesDescLabelId = "Updates.AvailableUpdatesDescLabel";
    private static final String kCheckNowButtonTextId = "Updates.CheckNow";
    private static final String kLastCheckedLabelId = "Updates.LastCheckedLabel";
    private static final String kInvalidResponseLabelId = "Updates.InvalidResponse";
    private static final String kInvalidUrlLabelId = "Updates.InvalidUrl";
    private static final String kUnableToConnectLabelId = "Updates.UnableToConnect";
    private static final String kUPSInfoMissingLabelId = "Updates.UPSInfoMissing";
    private String theAvailableUpdatesHeaderText;
    private String theAvailableUpdatesSubHeaderText;
    private String theAvailableUpdatesSubHeaderNoAutoUpdateText;
    private String theAvailableUpdatesNoneText;
    private String theAvailableUpdatesText;
    private String theAvailableUpdatesDescLabelText;
    private String theInvalidResponseLabelText;
    private String theInvalidUrlLabelText;
    private String theUnableToConnectLabelText;
    private String theUPSInfoMissingLabelText;
    private String theCheckNowButtonText;
    private String theLastCheckedLabelText;
    public static final String kCheckNowForm = "CHECKNOW";
    private static final Logger logger = LogManager.getLogger(AJAXCheckForUpdates.class);

    @Override
    public StringBuilder toHTML(PageContext pageContext) {
        StringBuilder stringBuilder = new StringBuilder();
        this.setupLanguage(pageContext.getLocale());
        HTMLDebug.htmlComment(stringBuilder, "Begin AJAXCheckForUpdates");
        this.setupAvailableUpdates(stringBuilder, pageContext);
        HTMLDebug.htmlComment(stringBuilder, "End AJAXCheckForUpdates");
        stringBuilder.trimToSize();
        return stringBuilder;
    }

    private void setupAvailableUpdates(StringBuilder stringBuilder, PageContext pageContext) {
        String string;
        Object object;
        HTMLwithId hTMLwithId;
        logger.debug("setupAvailableUpdates()");
        Long l = (Long)pageContext.get(SoftwareUpdateGroup.UpdateInterval.getObjectId());
        l = l != null ? Long.valueOf(TimeUnit.DAYS.convert(l, TimeUnit.MILLISECONDS)) : Long.valueOf("7");
        boolean bl = false;
        Object object2 = pageContext.get(SoftwareUpdateGroup.AutoUpdateEnabled.getObjectId());
        if (object2 instanceof Boolean) {
            bl = (Boolean)object2;
        }
        String string2 = "";
        string2 = bl ? MessageFormat.format(this.theAvailableUpdatesSubHeaderText, l) : this.theAvailableUpdatesSubHeaderNoAutoUpdateText;
        ApcSectionHeader apcSectionHeader = new ApcSectionHeader(this.theAvailableUpdatesHeaderText, string2);
        apcSectionHeader.setHelpId(ApcHelp.CHECK_UPDATES);
        stringBuilder.append((CharSequence)apcSectionHeader.toHTML(pageContext));
        ApcForm apcForm = new ApcForm(kCheckNowForm, "/AJAXCheckUpdates");
        ApcSection apcSection = new ApcSection();
        String string3 = (String)pageContext.get(SoftwareUpdateGroup.UpdateVersion.getObjectId());
        String string4 = (String)pageContext.get(SoftwareUpdateGroup.UpdateURL.getObjectId());
        String string5 = (String)pageContext.get(SoftwareUpdateGroup.UpdateDescription.getObjectId());
        Date date = (Date)pageContext.get(SoftwareUpdateGroup.LastChecked.getObjectId());
        Integer n = (Integer)pageContext.get(SoftwareUpdateGroup.UpdateStatus.getObjectId());
        logger.debug("setupAvailableUpdates() Status:" + n);
        if (n == 1) {
            logger.debug("setupAvailableUpdates() Status OK.  Des:" + string5 + " URL:" + string4 + " Ver:" + string3);
            hTMLwithId = new ApcSectionNote();
            ((HTMLTagWithClassStyle)hTMLwithId).setStyle("border:0;");
            ((ApcSectionNote)hTMLwithId).setVisible(true);
            ((HTMLTagWithClassStyle)hTMLwithId).setId("AvailableUpdate");
            object = new Division();
            ((Container)((Object)hTMLwithId)).add((HTML)object);
            if (string5 == null && string4 == null) {
                logger.debug("setupAvailableUpdates() No Update available");
                ((HTMLTagWithClassStyle)object).setCssClass("updatemsg ui-state-default ui-corner-all");
                ((HTMLTagWithClassStyle)object).setId("AvailableUpdatesNone");
                ((Container)object).add(new Text(this.theAvailableUpdatesNoneText));
            } else {
                HTMLTagWithClassStyle hTMLTagWithClassStyle;
                logger.debug("setupAvailableUpdates() Update available");
                ((HTMLTagWithClassStyle)object).setCssClass("updatemsg ui-state-default ui-corner-all");
                ((HTMLTagWithClassStyle)object).setId("AvailableUpdatesLabel");
                string = this.theAvailableUpdatesText.replaceAll("\\{0\\}", string3);
                ((Container)object).add(new Text(string));
                if (string4 != null) {
                    logger.debug("setupAvailableUpdates() Add URL");
                    hTMLTagWithClassStyle = new Anchor();
                    hTMLTagWithClassStyle.setId("UpdateURL");
                    ((Anchor)hTMLTagWithClassStyle).setTarget("_blank");
                    ((Anchor)hTMLTagWithClassStyle).setHypertextReference(string4);
                    hTMLTagWithClassStyle.add(new Text(string4));
                    ((Container)object).add(hTMLTagWithClassStyle);
                }
                hTMLTagWithClassStyle = new Division();
                if (string5 != null) {
                    logger.debug("setupAvailableUpdates() Add Desc");
                    hTMLTagWithClassStyle.setId("UpdateDesc");
                    hTMLTagWithClassStyle.add(new Text("<br>"));
                    hTMLTagWithClassStyle.add(new Text(this.theAvailableUpdatesDescLabelText));
                    hTMLTagWithClassStyle.add(new Text(string5));
                }
                ((Container)object).add(hTMLTagWithClassStyle);
            }
            apcSection.add(hTMLwithId, null);
        }
        if (date != null) {
            hTMLwithId = new Division();
            object = DateFormat.getDateTimeInstance(3, 3, pageContext.getLocale());
            string = ((DateFormat)object).format(date);
            ((Container)((Object)hTMLwithId)).add(new Text(this.theLastCheckedLabelText + string));
            apcSection.add(hTMLwithId, null);
        }
        if (n != 1) {
            hTMLwithId = new Division();
            switch (n) {
                case 4: {
                    ((Container)((Object)hTMLwithId)).add(new Text(this.theInvalidResponseLabelText));
                    ((HTMLTagWithClassStyle)hTMLwithId).setCssClass("updatemsg ui-state-error ui-corner-all");
                    break;
                }
                case 2: {
                    ((Container)((Object)hTMLwithId)).add(new Text(this.theInvalidUrlLabelText));
                    ((HTMLTagWithClassStyle)hTMLwithId).setCssClass("updatemsg ui-state-error ui-corner-all");
                    break;
                }
                case 3: {
                    ((Container)((Object)hTMLwithId)).add(new Text(this.theUnableToConnectLabelText));
                    ((HTMLTagWithClassStyle)hTMLwithId).setCssClass("updatemsg ui-state-error ui-corner-all");
                    break;
                }
                case 5: {
                    ((Container)((Object)hTMLwithId)).add(new Text(this.theUPSInfoMissingLabelText));
                    ((HTMLTagWithClassStyle)hTMLwithId).setCssClass("updatemsg ui-state-error ui-corner-all");
                }
            }
            apcSection.add(hTMLwithId, null);
        }
        hTMLwithId = new Button("CheckNow");
        ((Input)hTMLwithId).setId("CheckNow");
        ((Input)hTMLwithId).setClassName("newbutton");
        ((Input)hTMLwithId).setValue(this.theCheckNowButtonText);
        ((Input)hTMLwithId).setOnClick("checkForUpdates()");
        apcSection.add(new Text(""), hTMLwithId);
        apcForm.add(apcSection);
        stringBuilder.append((CharSequence)apcForm.toHTML(pageContext));
    }

    private void setupLanguage(Locale locale) {
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        this.theAvailableUpdatesHeaderText = Utils.getResourceString(resourceBundleWrapper, kAvailableUpdatesHeaderId);
        this.theAvailableUpdatesSubHeaderText = Utils.getResourceString(resourceBundleWrapper, kAvailableUpdatesSubHeaderId);
        this.theAvailableUpdatesSubHeaderNoAutoUpdateText = Utils.getResourceString(resourceBundleWrapper, kAvailableUpdatesSubHeaderNoAutoUpdateId);
        this.theAvailableUpdatesText = Utils.getResourceString(resourceBundleWrapper, kAvailableUpdatesId);
        this.theAvailableUpdatesDescLabelText = Utils.getResourceString(resourceBundleWrapper, kAvailableUpdatesDescLabelId);
        this.theAvailableUpdatesNoneText = Utils.getResourceString(resourceBundleWrapper, kAvailableUpdatesNoneId);
        this.theLastCheckedLabelText = Utils.getResourceString(resourceBundleWrapper, kLastCheckedLabelId);
        this.theUnableToConnectLabelText = Utils.getResourceString(resourceBundleWrapper, kUnableToConnectLabelId);
        this.theUPSInfoMissingLabelText = Utils.getResourceString(resourceBundleWrapper, kUPSInfoMissingLabelId);
        this.theInvalidResponseLabelText = Utils.getResourceString(resourceBundleWrapper, kInvalidResponseLabelId);
        this.theInvalidUrlLabelText = Utils.getResourceString(resourceBundleWrapper, kInvalidUrlLabelId);
        this.theCheckNowButtonText = Utils.getResourceString(resourceBundleWrapper, kCheckNowButtonTextId);
    }
}

