/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.pages;

import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.servlets.AJAXServlet;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.nutanixservice.NutanixService;
import com.apcc.pcns.sshservice.SshSession;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.naming.AuthenticationException;
import javax.servlet.ServletException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AJAXCheckNutanixHostDetails
extends AJAXServlet {
    private Logger logger = LogManager.getLogger(AJAXCheckNutanixHostDetails.class);

    public AJAXCheckNutanixHostDetails(ServiceManager serviceManager) {
        super(serviceManager);
    }

    @Override
    protected void doPost(PageContext pageContext) throws ServletException, IOException {
        if (this.verifyFormToken(pageContext, false)) {
            boolean bl = false;
            if (!this.services.getAdvancedSetupHelper().isAdvancedShutdownMode()) {
                List<String> list = this.services.getVirtualConfigurationManager().parseHostListParameter("HostConfigSettings");
                bl = list.stream().anyMatch(string -> !this.checkNutanixHostConnection((String)string));
            } else {
                List list = this.services.getAdvancedSetupHelper().readUPSSetupsFromConfig().stream().map(uPSSetup -> uPSSetup.getHosts()).collect(Collectors.toList());
                bl = list.stream().anyMatch(linkedHashSet -> linkedHashSet.stream().anyMatch(string -> !this.checkNutanixHostConnection((String)string)));
            }
            if (bl) {
                pageContext.getResponse().sendError(417);
            }
        } else {
            pageContext.getResponse().sendError(401);
        }
    }

    private boolean checkNutanixHostConnection(String string) {
        SshSession sshSession = null;
        boolean bl = true;
        try {
            sshSession = NutanixService.getInstance().getAHVConnection(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl = false;
            this.logger.error("Illegal argument for the Nutanix Host credentials for host {}: {}", (Object)string, (Object)illegalArgumentException.getMessage());
        }
        catch (IOException iOException) {
            bl = false;
            this.logger.error("Unable to load SSH key: ", (Object)iOException.getMessage());
        }
        if (sshSession != null) {
            try {
                sshSession.startConnection();
                bl = true;
                sshSession.closeConnection();
            }
            catch (AuthenticationException authenticationException) {
                bl = false;
                this.logger.error("Failed to connect to {} due to invalid credentials: {}", (Object)string, (Object)authenticationException.getMessage());
            }
            catch (IllegalStateException illegalStateException) {
                bl = false;
                this.logger.error("Cannot connect to {} due to insufficient credentials: {}", (Object)string, (Object)illegalStateException.getMessage());
            }
            catch (IOException iOException) {
                bl = false;
                this.logger.error("Failed to connect to {} over the network: {}", (Object)string, (Object)iOException.getMessage());
            }
        }
        return bl;
    }
}

