/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.pages;

import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.util.DataTablesHelper;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.m11.ds.services.eventlogginggroup.EventLoggingGroup;
import com.apcc.m11.ds.services.eventlogginggroup.ILogAccessor;
import com.apcc.pcns.util.DateTimeFormatUtils;
import com.apcc.pcns.util.ResourceBundleWrapper;
import com.github.cliftonlabs.json_simple.JsonArray;
import com.github.cliftonlabs.json_simple.JsonObject;
import java.util.Date;
import java.util.Locale;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AJAXEventLogPage
implements HTML {
    private static final String kNoLoggedEventsId = "EventLog.NoLoggedEvents";
    private static final String kDateHeaderId = "EventLog.DateHeader";
    private static final String kTimeHeaderId = "EventLog.TimeHeader";
    private static final String kEventHeaderId = "EventLog.EventHeader";
    private String theNoLoggedEventsText;
    private String theDateHeaderText;
    private String theTimeHeaderText;
    private String theEventHeaderText;
    private Integer iDisplayLength;
    private Integer iDisplayStart;
    private Integer sEcho;
    private static final Logger logger = LogManager.getLogger(AJAXEventLogPage.class);
    private DateTimeFormatUtils dateUtils;

    public AJAXEventLogPage(@NonNull DateTimeFormatUtils dateTimeFormatUtils) {
        if (dateTimeFormatUtils == null) {
            throw new IllegalArgumentException("dateFormatter is marked non-null but is null");
        }
        this.dateUtils = dateTimeFormatUtils;
    }

    @Override
    public StringBuilder toHTML(PageContext pageContext) {
        Object object;
        logger.debug("toHtml()");
        this.setupLanguage(pageContext.getLocale());
        this.iDisplayStart = DataTablesHelper.readDisplayStartValueFromSession(pageContext);
        this.iDisplayLength = DataTablesHelper.readLengthValueFromSession(pageContext);
        this.sEcho = DataTablesHelper.readDrawValueFromSession(pageContext);
        JsonObject jsonObject = new JsonObject();
        JsonArray jsonArray = new JsonArray();
        int n = 0;
        ILogAccessor iLogAccessor = (ILogAccessor)pageContext.get(EventLoggingGroup.LoggedEvents.getObjectId());
        if (iLogAccessor != null) {
            object = iLogAccessor.getAll();
            int n2 = object.size();
            if (this.iDisplayLength == -1) {
                this.iDisplayLength = n2;
            }
            n = n2;
            logger.debug("Log contains " + n2 + " rows");
            if (n2 > 0) {
                int n3 = object.size() - 1 - this.iDisplayStart;
                for (int i = 0; n3 >= 0 && i < this.iDisplayLength; --n3, ++i) {
                    JsonArray jsonArray2 = new JsonArray();
                    try {
                        String string = "";
                        String string2 = "";
                        String string3 = "";
                        String string4 = "Unknown";
                        Object e = object.get(n3);
                        if (e instanceof String) {
                            var16_18 = (String)e;
                            if (var16_18.contains("\t")) {
                                var17_19 = var16_18.split("\t", 4);
                                string2 = var17_19[0];
                                string = var17_19[1];
                                string3 = var17_19[2];
                                if (var17_19.length == 4) {
                                    string4 = var17_19[3];
                                }
                            } else {
                                string3 = var16_18;
                            }
                        } else {
                            var16_18 = (Event)e;
                            if (var16_18 != null) {
                                var17_19 = var16_18.getTimestamp();
                                string = this.dateUtils.formatTableTime((Date)var17_19);
                                string2 = this.dateUtils.formatTableDate((Date)var17_19);
                                IFormatter iFormatter = var16_18.getFormatter();
                                if (iFormatter != null) {
                                    string3 = iFormatter.format((Object)var16_18, pageContext.getLocale());
                                }
                                string4 = var16_18.getObjectId().toString();
                            }
                        }
                        jsonArray2.add((Object)string2);
                        jsonArray2.add((Object)string);
                        jsonArray2.add((Object)string3);
                        jsonArray.add((Object)jsonArray2);
                        continue;
                    }
                    catch (Exception exception) {
                        logger.warn("Cannot formate event properly ", (Throwable)exception);
                    }
                }
            } else {
                JsonArray jsonArray3 = new JsonArray();
                n = 0;
            }
        }
        object = new StringBuilder();
        pageContext.getResponse().setContentType("application/json");
        jsonObject.put((Object)"draw", (Object)this.sEcho);
        jsonObject.put((Object)"recordsTotal", (Object)n);
        jsonObject.put((Object)"recordsFiltered", (Object)n);
        jsonObject.put((Object)"data", (Object)jsonArray);
        ((StringBuilder)object).append(jsonObject.toJson());
        return object;
    }

    public void setupLanguage(Locale locale) {
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        this.theNoLoggedEventsText = Utils.getResourceString(resourceBundleWrapper, kNoLoggedEventsId);
        this.theDateHeaderText = Utils.getResourceString(resourceBundleWrapper, kDateHeaderId);
        this.theTimeHeaderText = Utils.getResourceString(resourceBundleWrapper, kTimeHeaderId);
        this.theEventHeaderText = Utils.getResourceString(resourceBundleWrapper, kEventHeaderId);
    }
}

