/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.pages;

import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.apc.ApcForm;
import com.apcc.m11.components.webserver.html.apc.ApcHelp;
import com.apcc.m11.components.webserver.html.apc.ApcPage;
import com.apcc.m11.components.webserver.html.apc.ApcSectionHeader;
import com.apcc.m11.components.webserver.html.form.Form;
import com.apcc.m11.components.webserver.html.form.Input;
import com.apcc.m11.components.webserver.model.SSHSettings;
import com.apcc.m11.components.webserver.util.SSHSettingsHTMLHelper;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.NonNull;

public class AdvancedSSHSettingsPage
implements HTML {
    private static final String HEADER_TEXT = "SSHSettings.SectionHeader";
    private static final String SUBHEADER_TEXT = "SSHSettings.SectionSubHeader";
    private String theHeaderText;
    private String theSubHeaderText;
    private List<SSHSettings> settings;
    private Map<String, Boolean> sshActions;
    private ServiceManager services;

    public AdvancedSSHSettingsPage(List<SSHSettings> list, Map<String, Boolean> map, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.settings = list;
        this.sshActions = map;
        this.services = serviceManager;
    }

    @Override
    public StringBuilder toHTML(PageContext pageContext) {
        SSHSettingsHTMLHelper sSHSettingsHTMLHelper = new SSHSettingsHTMLHelper(pageContext.getLocale(), this.settings, this.services);
        sSHSettingsHTMLHelper.setSSHActions(this.sshActions);
        this.setupLanguage(pageContext.getLocale());
        ApcPage apcPage = new ApcPage(this.services);
        apcPage.addStyleSheet("styles/form.css");
        apcPage.addStyleSheet("styles/ssh_actions.css");
        apcPage.addScript("scripts/jquery.validate.min.js");
        apcPage.addScript("scripts/additional-methods.min.js");
        apcPage.addScript("scripts/advanced_ssh_settings.js");
        apcPage.addScript("scripts/content.js");
        ApcSectionHeader apcSectionHeader = new ApcSectionHeader(this.theHeaderText, this.theSubHeaderText);
        apcSectionHeader.setHelpId(ApcHelp.SSH_SETTINGS);
        apcPage.add(apcSectionHeader);
        apcPage.add(sSHSettingsHTMLHelper.createSelectedActionNotEnabledWarning());
        ApcForm apcForm = new ApcForm("advancedsshsettingsForm", "/advancedsshsettings");
        apcForm.setId("advancedsshsettingsForm");
        apcPage.add(apcForm);
        boolean bl = true;
        apcForm.add(sSHSettingsHTMLHelper.createSSHActionsListPanel(bl));
        apcPage.add(sSHSettingsHTMLHelper.createButtonDiv());
        apcPage.add(sSHSettingsHTMLHelper.createWaitDialog());
        Integer n = (Integer)pageContext.getValue("setup");
        if (n != null) {
            this.addIPHiddenInput(apcForm, n);
        }
        pageContext.addFormToken(apcForm);
        return apcPage.toHTML(pageContext);
    }

    private void addIPHiddenInput(Form form, Integer n) {
        Input input = new Input();
        input.setName("setup");
        input.setValue(n.toString());
        input.setType("hidden");
        form.add(input);
    }

    public void setupLanguage(Locale locale) {
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        this.theHeaderText = Utils.getResourceString(resourceBundleWrapper, HEADER_TEXT);
        this.theSubHeaderText = Utils.getResourceString(resourceBundleWrapper, SUBHEADER_TEXT);
    }
}

