/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.pages;

import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.Text;
import com.apcc.m11.components.webserver.html.util.Anchor;
import com.apcc.m11.components.webserver.util.DataTablesHelper;
import com.apcc.m11.ds.powersource.DependentDevices;
import com.apcc.pcns.ServiceManager;
import com.github.cliftonlabs.json_simple.JsonArray;
import com.github.cliftonlabs.json_simple.JsonObject;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.Vector;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConnectedServersPage
implements HTML {
    private static final int kDefaultWebUIPort = 6547;
    private Vector<HostNameFetcher> fetchers = new Vector();
    private Logger logger = LogManager.getLogger(ConnectedServersPage.class);
    private Integer draw = DataTablesHelper.DRAW_DEFAULT;
    private Integer iDisplayStart = DataTablesHelper.DISPLAY_START_DEFAULT;
    private Integer iDisplayLength = DataTablesHelper.LENGTH_DEFAULT;
    private ServiceManager services;

    public ConnectedServersPage(@NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
    }

    @Override
    public StringBuilder toHTML(PageContext pageContext) {
        Serializable serializable;
        Vector vector = new Vector();
        Integer n = (Integer)pageContext.getSession().getAttribute("setup");
        if (this.services.getAdvancedSetupHelper().isAdvancedShutdownMode()) {
            Vector vector2;
            if (n != null && (vector2 = (Vector)pageContext.get(DependentDevices.GroupListOfDevices.getObjectId())) != null && vector2.size() > n) {
                vector = (Vector)vector2.get(n);
            }
        } else {
            vector = (Vector)pageContext.get(DependentDevices.ListOfDevices.getObjectId());
        }
        int n2 = 0;
        JsonArray jsonArray = new JsonArray();
        if (vector != null) {
            n2 = vector.size();
            for (int i = 0; i < vector.size(); ++i) {
                serializable = (InetAddress)vector.elementAt(i);
                HostNameFetcher hostNameFetcher = new HostNameFetcher((InetAddress)serializable);
                hostNameFetcher.start();
                this.fetchers.add(hostNameFetcher);
            }
            jsonArray = this.getJSONAgents(vector, pageContext);
        }
        this.iDisplayLength = DataTablesHelper.readLengthValueFromSession(pageContext);
        this.draw = DataTablesHelper.readDrawValueFromSession(pageContext);
        this.iDisplayStart = DataTablesHelper.readDisplayStartValueFromSession(pageContext);
        JsonObject jsonObject = new JsonObject();
        jsonObject.put((Object)"draw", (Object)this.draw);
        jsonObject.put((Object)"recordsTotal", (Object)n2);
        jsonObject.put((Object)"recordsFiltered", (Object)n2);
        jsonObject.put((Object)"data", (Object)jsonArray);
        serializable = new StringBuilder();
        ((StringBuilder)serializable).append(jsonObject.toJson());
        return serializable;
    }

    private JsonArray getJSONAgents(Vector<InetAddress> vector, PageContext pageContext) {
        int n = vector.size();
        JsonArray jsonArray = new JsonArray();
        for (int i = this.iDisplayStart.intValue(); i < vector.size() && i < this.iDisplayLength; ++i) {
            JsonArray jsonArray2 = new JsonArray();
            HostNameFetcher hostNameFetcher = this.fetchers.elementAt(i);
            try {
                hostNameFetcher.join();
            }
            catch (InterruptedException interruptedException) {
                this.logger.warn("Fetcher can not join " + String.valueOf(interruptedException));
            }
            Anchor anchor = new Anchor();
            anchor.setTarget("_blank");
            anchor.setHypertextReference("https://" + hostNameFetcher.getHostAddress() + ":6547");
            anchor.add(new Text(hostNameFetcher.getHostAddress()));
            jsonArray2.add((Object)hostNameFetcher.getHostName());
            jsonArray2.add((Object)anchor.toHTML(pageContext).toString());
            jsonArray.add((Object)jsonArray2);
        }
        return jsonArray;
    }

    private static class HostNameFetcher
    extends Thread {
        String hostName;
        String hostAddress;
        InetAddress address;

        HostNameFetcher(InetAddress inetAddress) {
            this.address = inetAddress;
            this.hostName = null;
        }

        @Override
        public void run() {
            this.hostName = this.address.getHostName();
            if (this.address instanceof Inet4Address) {
                this.hostAddress = this.address.getHostAddress();
            } else if (this.address instanceof Inet6Address) {
                this.hostAddress = "[" + this.address.getHostAddress() + "]";
            }
        }

        public String getHostAddress() {
            return this.hostAddress;
        }

        public String getHostName() {
            return this.hostName;
        }
    }
}

