/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.pages;

import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.HTMLDebug;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.pages.OmahaStdPages;
import com.apcc.m11.components.webserver.pages.actions.Action;
import com.apcc.m11.components.webserver.pages.actions.LogEventAction;
import com.apcc.m11.components.webserver.pages.actions.NotifyUsersAction;
import com.apcc.m11.components.webserver.pages.actions.RunCommandFileAction;
import com.apcc.m11.components.webserver.pages.actions.ShutdownAction;
import com.apcc.m11.ds.services.omaha.IFlexEventDescriptor;
import com.apcc.m11.ds.services.omaha.Omaha;
import com.apcc.pcns.ServiceManager;
import java.util.Vector;
import lombok.NonNull;

public class DisplayEventDetailsPage
implements HTML {
    private String theBadActionMsg = "The action specified is not supported.";
    private String theBadParameterMsg = "Unrecognized parameters.";
    private String error = null;
    private ServiceManager services;

    public DisplayEventDetailsPage(String string, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.error = string;
        this.services = serviceManager;
    }

    public DisplayEventDetailsPage(@NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.error = null;
        this.services = serviceManager;
    }

    @Override
    public StringBuilder toHTML(PageContext pageContext) {
        Object object3;
        String string = pageContext.getPostQueryValue("OID");
        String string2 = pageContext.getPostQueryValue("Action");
        Object object2 = null;
        Vector vector = (Vector)pageContext.get(Omaha.FlexEventList.getObjectId());
        if (vector != null) {
            for (Object object3 : vector) {
                if (object3 == null || !object3.getObjectId().toString().equals(string)) continue;
                object2 = object3;
                break;
            }
        }
        Object object4 = null;
        if (object2 != null && string != null && string2 != null) {
            try {
                object3 = object2.getNameFormatter();
                String string3 = object3.format(object2, pageContext.getLocale());
                pageContext.setValue("EventName", string3);
            }
            catch (Exception exception) {
                pageContext.setValue("EventName", object2.getClass().toString());
            }
            object3 = null;
            if (string2.equals("Log")) {
                object3 = new LogEventAction();
            } else if (string2.equals("NotifyUsers")) {
                object3 = new NotifyUsersAction();
            } else if (string2.equals("RunCommandFile")) {
                object3 = new RunCommandFileAction();
            } else if (string2.equals("Shutdown")) {
                object3 = new ShutdownAction();
            }
            if (object3 != null) {
                ((Action)object3).setEvent((IFlexEventDescriptor)object2);
                ((Action)object3).setError(this.error);
                ((Action)object3).refresh(pageContext);
                object4 = object3;
            } else {
                object4 = OmahaStdPages.getProblemReport(pageContext, this.theBadActionMsg, this.services);
            }
        } else {
            object4 = OmahaStdPages.getProblemReport(pageContext, this.theBadParameterMsg, this.services);
        }
        object3 = new StringBuilder();
        HTMLDebug.htmlComment((StringBuilder)object3, "Begin DisplayEventDetailsPage");
        ((StringBuilder)object3).append((CharSequence)object4.toHTML(pageContext));
        HTMLDebug.htmlComment((StringBuilder)object3, "End DisplayEventDetailsPage");
        ((StringBuilder)object3).trimToSize();
        return object3;
    }
}

