/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.pages;

import com.apcc.m11.components.webserver.html.Container;
import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.Text;
import com.apcc.m11.components.webserver.html.apc.ApcHelp;
import com.apcc.m11.components.webserver.html.apc.ApcPage;
import com.apcc.m11.components.webserver.html.apc.ApcSectionHeader;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.html.document.Html;
import com.apcc.m11.components.webserver.html.form.Button;
import com.apcc.m11.components.webserver.html.form.Form;
import com.apcc.m11.components.webserver.util.LicensingHTMLHelper;
import com.apcc.m11.components.webserver.util.LicensingPanelHelper;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.licensing.ILicensingManager;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.util.Locale;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LicensingPage
extends Html {
    private ApcPage thePage;
    private ServiceManager services;
    private ILicensingManager licensingManager;
    private boolean hasLicense;
    private static final Logger logger = LogManager.getLogger(LicensingPage.class);
    public static final String LICENSING_RENEWAL_HEADER = "Licensing.RenewalHeader";
    public static final String LICENSING_RENEWAL_SUBHEADER = "Licensing.RenewalSubHeader";
    private static final String LICENSING_RETURN_BUTTON = "Licensing.ReturnButton";
    private static final String LICENSING_RETURN_DIALOG_TITLE = "Licensing.ReturnLicenseDialogTitle";
    private static final String LICENSING_RETURN_DIALOG_BODY = "Licensing.ReturnLicenseDialogBody";
    public static final String LICENSE_RETURN_BUTTON = "returnLicenseButton";
    private String theRenewalHeader;
    private String theRenewalSubHeader;
    private String theReturnButton;
    private String theReturnDialogTitle;
    private String theReturnDialogBody;

    public LicensingPage(@NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.thePage = new ApcPage(true, true, true, serviceManager);
        this.services = serviceManager;
        this.licensingManager = this.services.getLicensingManager();
        this.licensingManager.init();
        this.hasLicense = this.licensingManager.hasLicense();
        this.licensingManager.restoreConfiguration();
    }

    @Override
    public StringBuilder toHTML(PageContext pageContext) {
        Object object;
        LicensingPanelHelper licensingPanelHelper = new LicensingPanelHelper(pageContext.getLocale(), this.services);
        LicensingHTMLHelper licensingHTMLHelper = new LicensingHTMLHelper(pageContext.getLocale(), this.services);
        this.setupLanguage(pageContext.getLocale());
        this.thePage.addScript("scripts/jquery.validate.min.js");
        this.thePage.addStyleSheet("styles/form.css");
        this.thePage.addStyleSheet("styles/eventcfg.css");
        this.thePage.addStyleSheet("styles/licensingPage.css");
        this.thePage.addScript("scripts/licensing.js");
        this.thePage.addScript("scripts/licensingPage.js");
        Form form = new Form();
        form.setId("CfgWizardForm");
        pageContext.addFormToken(form);
        Division division = new Division();
        form.add(division);
        if (this.hasLicense && !this.licensingManager.isInGracePeriod()) {
            division.add(licensingPanelHelper.createLicensingPanelHTML(pageContext, false));
            if (!this.licensingManager.isOfflineActivationSelected()) {
                this.addReturnLicenseButton(division);
                this.addReturnLicenseWaitDialog(division);
            }
            division.add(licensingHTMLHelper.addUpdateLicenseSection());
        } else {
            object = new ApcSectionHeader(this.theRenewalHeader, this.theRenewalSubHeader);
            ((ApcSectionHeader)object).setHelpId(ApcHelp.LICENSING);
            Division division2 = new Division();
            division2.add((HTML)object);
            division2.setId("renewalDiv");
            division2.add(licensingHTMLHelper.addActivateNewLicenseSection());
            division.add(division2);
        }
        division.add(licensingPanelHelper.addPurchaseLink());
        this.thePage.add(form);
        object = new StringBuilder();
        ((StringBuilder)object).append((CharSequence)this.thePage.toHTML(pageContext));
        ((StringBuilder)object).trimToSize();
        return object;
    }

    private void setupLanguage(Locale locale) {
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        this.theRenewalHeader = Utils.getResourceString(resourceBundleWrapper, LICENSING_RENEWAL_HEADER);
        this.theRenewalSubHeader = Utils.getResourceString(resourceBundleWrapper, LICENSING_RENEWAL_SUBHEADER);
        this.theReturnButton = Utils.getResourceString(resourceBundleWrapper, LICENSING_RETURN_BUTTON);
        this.theReturnDialogTitle = Utils.getResourceString(resourceBundleWrapper, LICENSING_RETURN_DIALOG_TITLE);
        this.theReturnDialogBody = Utils.getResourceString(resourceBundleWrapper, LICENSING_RETURN_DIALOG_BODY);
        logger.debug("SetupLanguage {}", (Object)this.theRenewalHeader, (Object)this.theRenewalSubHeader);
    }

    private void addReturnLicenseButton(Container container) {
        Division division = new Division();
        Button button = new Button();
        button.setId(LICENSE_RETURN_BUTTON);
        button.setValue(this.theReturnButton);
        button.setOnClick("returnLicense()");
        if (this.licensingManager.hasActiveTrialLicense()) {
            button.setDisable(true);
        }
        division.add(button);
        container.add(division);
    }

    private void addReturnLicenseWaitDialog(Container container) {
        Division division = new Division();
        division.setId("returnLicenseDialog");
        division.setCssClass("returnLicenseDialog");
        division.setTitle(this.theReturnDialogTitle);
        division.add(new Text(this.theReturnDialogBody));
        container.add(division);
    }
}

