/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.pages;

import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.apc.ApcPage;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.html.document.Html;
import com.apcc.m11.components.webserver.html.form.Button;
import com.apcc.m11.components.webserver.html.form.Form;
import com.apcc.m11.components.webserver.util.LogBundleHTMLHelper;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.util.Locale;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LogBundlePage
extends Html {
    private ApcPage thePage;
    private ServiceManager services;
    private static final String DOWNLOAD_BUTTON_TEXT = "LogBundle.Main.Download";
    private String theDownloadButtonText;
    private static final Logger logger = LogManager.getLogger(LogBundlePage.class);

    public LogBundlePage(@NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("services is marked non-null but is null");
        }
        this.services = serviceManager;
        this.thePage = new ApcPage(true, true, true, serviceManager);
    }

    @Override
    public StringBuilder toHTML(PageContext pageContext) {
        logger.debug("toHTML() - start");
        LogBundleHTMLHelper logBundleHTMLHelper = new LogBundleHTMLHelper(pageContext.getLocale(), this.services);
        this.setupLanguage(pageContext.getLocale());
        this.thePage.addScript("scripts/jquery.validate.min.js");
        this.thePage.addScript("scripts/additional-methods.min.js");
        this.thePage.addScript("scripts/logBundlePage.js");
        this.thePage.addStyleSheet("styles/form.css");
        Form form = new Form();
        form.setId("CfgWizardForm");
        pageContext.addFormToken(form);
        Division division = new Division();
        form.add(division);
        division.add(logBundleHTMLHelper.createLogBundlePageHTML());
        Division division2 = new Division();
        division2.setStyle("margin-left:10px;");
        Button button = new Button("DownloadLogButton");
        button.setId("DownloadLogButton");
        button.setClassName("newbutton");
        button.setValue(this.theDownloadButtonText);
        button.setOnClick("downloadLogBundle()");
        division2.add(button);
        division.add(division2);
        this.thePage.add(form);
        this.thePage.add(logBundleHTMLHelper.createErrorPanel());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((CharSequence)this.thePage.toHTML(pageContext));
        stringBuilder.trimToSize();
        logger.trace("toHTML() - end");
        return stringBuilder;
    }

    private void setupLanguage(Locale locale) {
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        this.theDownloadButtonText = Utils.getResourceString(resourceBundleWrapper, DOWNLOAD_BUTTON_TEXT);
    }
}

