/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.pages;

import com.apcc.m11.components.webserver.html.Container;
import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.Text;
import com.apcc.m11.components.webserver.html.apc.ApcForm;
import com.apcc.m11.components.webserver.html.apc.ApcHelp;
import com.apcc.m11.components.webserver.html.apc.ApcPage;
import com.apcc.m11.components.webserver.html.apc.ApcSectionHeader;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.html.document.Heading;
import com.apcc.m11.components.webserver.html.document.Span;
import com.apcc.m11.components.webserver.html.form.Input;
import com.apcc.m11.components.webserver.html.form.TextInput;
import com.apcc.m11.components.webserver.model.UPSSetup;
import com.apcc.m11.components.webserver.util.AdvancedSetupHTMLHelper;
import com.apcc.m11.components.webserver.util.FormHelper;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.m11.ds.services.messageBroadcastGroup.AllRecipients;
import com.apcc.m11.ds.services.messageBroadcastGroup.Recipient;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.util.List;
import java.util.Locale;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OmahaAdvancedShutdown
implements HTML {
    private static final Logger logger = LogManager.getLogger(OmahaAdvancedShutdown.class);
    public static final String PARAM_NAME_ACTIVE_ACCORDION = "activeAcc";
    private static final String kShutdownHeader = "AdvancedShutdown.Heading";
    private static final String kShutdownSubHeader = "AdvancedShutdown.SubHeading";
    private static final String kShutdownSettingsError = "Shutdown.ErrorText";
    private static final String kNotifyHeader = "Shutdown.NotifyHeader";
    private static final String kNotifyEnable = "Notifier.Enable";
    private static final String kNotifyAllUsers = "Notifier.All";
    private static final String kNotifySingleUser = "Notifier.Specific";
    private static final String kNotifyInterval = "Shutdown.NotifyInterval";
    private static final String kSecondsUnitLabel = "VMSettings.SecondsUnitLabel";
    private static final String kApplyButton = "PCNS.ApplyButton";
    private static final String kResetButton = "PCNS.UndoButton";
    private static final String kRangeValidation = "PCNS.RangeValidation";
    private static final String kRequiredField = "PCNS.RequiredField";
    private static final String kWaitTitle = "PCNS.WaitTitle";
    private static final String kWaitText = "PCNS.WaitText";
    private String theShutdownHeaderText;
    private String theShutdownSubHeaderText;
    private String theShutdownSettingsErrorText;
    private String theNotifyHeaderText;
    private String theNotifyEnableText;
    private String theNotifyAllUsersText;
    private String theNotifySingleUserText;
    private String theNotifyIntervalLabelText;
    private String theSecondsUnitLabelText;
    private String theRequiredFieldValidationText;
    private String theRangeValidationText;
    private String theApplyButtonText;
    private String theResetButtonText;
    private String theWaitTitle;
    private String theWaitText;
    private ServiceManager services;

    public OmahaAdvancedShutdown(@NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
    }

    @Override
    public StringBuilder toHTML(PageContext pageContext) {
        this.setupLanguage(pageContext.getLocale());
        ApcPage apcPage = new ApcPage(this.services);
        apcPage.addStyleSheet("styles/form.css");
        apcPage.addStyleSheet("styles/groupscfg.css");
        apcPage.addScript("scripts/jquery.validate.min.js");
        apcPage.addScript("scripts/navigation.js");
        apcPage.addScript("scripts/groupscfg.js");
        ApcSectionHeader apcSectionHeader = new ApcSectionHeader(this.theShutdownHeaderText, this.theShutdownSubHeaderText);
        apcSectionHeader.setHelpId(ApcHelp.ADVANCED_SHUTDOWN_SETTINGS);
        apcPage.add(apcSectionHeader);
        ApcForm apcForm = new ApcForm("shuttownsettings", "/advancedshutdown");
        apcForm.setId("shutdownsettingsform");
        apcPage.add(apcForm);
        Division division = new Division();
        division.setId("waitDialog");
        division.setCssClass("waitDialog");
        division.setTitle(this.theWaitTitle);
        division.add(new Text(this.theWaitText));
        apcPage.add(division);
        Division division2 = new Division();
        division2.setId("errorcontainer");
        division2.add(new Text(this.theShutdownSettingsErrorText));
        division2.setCssClass("ui-state-error ui-corner-all");
        apcForm.add(division2);
        Division division3 = new Division();
        division3.setId("maindiv");
        division3.setCssClass("formdiv");
        apcForm.add(division3);
        AdvancedSetupHTMLHelper advancedSetupHTMLHelper = new AdvancedSetupHTMLHelper(pageContext.getLocale(), this.services);
        this.displayUPSSetupGroups(pageContext, advancedSetupHTMLHelper, division3);
        if (((Boolean)pageContext.getValue("is_broadcast_supported")).booleanValue()) {
            this.displayNotifySection(pageContext, division3);
        }
        apcForm.add(advancedSetupHTMLHelper.createResourceStrings());
        apcForm.add(this.createButtonDiv("ShutdownSettings"));
        Input input = new Input();
        input.setName(PARAM_NAME_ACTIVE_ACCORDION);
        input.setId(PARAM_NAME_ACTIVE_ACCORDION);
        input.setType("hidden");
        String string = (String)pageContext.getValue(PARAM_NAME_ACTIVE_ACCORDION);
        input.setValue(string != null ? string : "0");
        apcForm.add(input);
        pageContext.addFormToken(apcForm);
        return apcPage.toHTML(pageContext);
    }

    private void displayUPSSetupGroups(PageContext pageContext, AdvancedSetupHTMLHelper advancedSetupHTMLHelper, Division division) {
        List list = (List)pageContext.getValue("setupgroups");
        int n = 0;
        String string = "UPSSetupGroup";
        String string2 = "UPSSetupSingle";
        if (list != null) {
            for (UPSSetup uPSSetup : list) {
                Heading heading = new Heading(3);
                division.add(heading);
                Span span = new Span();
                String string3 = uPSSetup.getTotalNumberOfUPS() > 1 ? string : string2;
                span.setCssClass(string3);
                heading.add(span);
                heading.add(new Text(uPSSetup.getNameEsc()));
                Division division2 = (Division)advancedSetupHTMLHelper.createGroupShutdownDiv(pageContext, uPSSetup, n);
                division.add(division2);
                ++n;
            }
        } else {
            logger.debug("no UPS Setup groups to display...");
        }
    }

    private void displayNotifySection(PageContext pageContext, Division division) {
        Object object;
        Boolean bl = (Boolean)pageContext.getValue("notifyEnabled");
        if (bl == null) {
            bl = false;
        }
        Integer n = 0;
        String string = "";
        boolean bl2 = true;
        if (bl.booleanValue() && (object = (Recipient)pageContext.getValue("recipient")) != null) {
            n = ((Recipient)object).getPeriodicInterval();
            bl2 = ((Recipient)object).getAddress().equals(AllRecipients.kOid.toString());
            if (!bl2) {
                string = ((Recipient)object).getAddress();
            }
        }
        object = new Heading(3);
        ((Container)object).add(new Text(this.theNotifyHeaderText));
        ApcHelp apcHelp = new ApcHelp();
        apcHelp.setHelpId(ApcHelp.NOTIFY_USER_ACTION1);
        ((Container)object).add(apcHelp);
        division.add((HTML)object);
        Division division2 = new Division();
        division.add(division2);
        division2.add(FormHelper.createLabelCheckboxValueDiv("notifyEnableDiv", this.theNotifyEnableText, bl, "notifyenablecheckbox", "notifyEnabled", null));
        Division division3 = new Division();
        division2.add(division3);
        division3.setId("notifysettings");
        division3.add(FormHelper.createLabelRadioButtonValueDiv(null, this.theNotifyAllUsersText, "notifyAllUsers", bl2, null, "notifyUser"));
        Division division4 = FormHelper.createLabelRadioButtonValueDiv(null, this.theNotifySingleUserText, "notifySingleUser", !bl2, null, "notifyUser");
        division3.add(division4);
        Span span = new Span();
        division4.add(span);
        span.setCssClass("value");
        TextInput textInput = new TextInput("singleUserName");
        span.add(textInput);
        textInput.setValue(string);
        textInput.setSize("24");
        textInput.setMaxLength("128");
        division3.add(FormHelper.createLabelTextInputValueDiv("repeatIntervalDiv", this.theNotifyIntervalLabelText, n.toString(), null, "notifyInterval", null, (Integer)4, null, this.theSecondsUnitLabelText, null));
    }

    private HTML createButtonDiv(String string) {
        Division division = new Division();
        division.setId("buttondiv");
        Input input = new Input();
        input.setName("apply");
        input.setValue(this.theApplyButtonText);
        input.setId("apply" + string);
        input.setType("submit");
        input.setClassName("newbutton");
        division.add(input);
        Input input2 = new Input();
        input2.setName("reset" + string);
        input2.setValue(this.theResetButtonText);
        input2.setId("reset" + string);
        input2.setType("reset");
        input2.setClassName("newbutton");
        division.add(input2);
        return division;
    }

    private void setupLanguage(Locale locale) {
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        this.theShutdownHeaderText = Utils.getResourceString(resourceBundleWrapper, kShutdownHeader);
        this.theShutdownSubHeaderText = Utils.getResourceString(resourceBundleWrapper, kShutdownSubHeader);
        this.theShutdownSettingsErrorText = Utils.getResourceString(resourceBundleWrapper, kShutdownSettingsError);
        this.theNotifyHeaderText = Utils.getResourceString(resourceBundleWrapper, kNotifyHeader);
        this.theNotifyEnableText = Utils.getResourceString(resourceBundleWrapper, kNotifyEnable);
        this.theNotifyAllUsersText = Utils.getResourceString(resourceBundleWrapper, kNotifyAllUsers);
        this.theNotifySingleUserText = Utils.getResourceString(resourceBundleWrapper, kNotifySingleUser);
        this.theNotifyIntervalLabelText = Utils.getResourceString(resourceBundleWrapper, kNotifyInterval);
        this.theSecondsUnitLabelText = Utils.getResourceString(resourceBundleWrapper, kSecondsUnitLabel);
        this.theRequiredFieldValidationText = Utils.getResourceString(resourceBundleWrapper, kRequiredField);
        this.theRangeValidationText = Utils.getResourceString(resourceBundleWrapper, kRangeValidation);
        this.theApplyButtonText = Utils.getResourceString(resourceBundleWrapper, kApplyButton);
        this.theResetButtonText = Utils.getResourceString(resourceBundleWrapper, kResetButton);
        this.theWaitTitle = Utils.getResourceString(resourceBundleWrapper, kWaitTitle);
        this.theWaitText = Utils.getResourceString(resourceBundleWrapper, kWaitText);
    }
}

