/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.pages;

import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.HTMLDebug;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.Text;
import com.apcc.m11.components.webserver.html.apc.ApcForm;
import com.apcc.m11.components.webserver.html.apc.ApcHelp;
import com.apcc.m11.components.webserver.html.apc.ApcPage;
import com.apcc.m11.components.webserver.html.apc.ApcSectionHeader;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.html.form.Checkbox;
import com.apcc.m11.components.webserver.html.form.Input;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.util.Locale;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OmahaCEIPPage
implements HTML {
    private static final String SUBMIT = "submit";
    private static final String APPLY = "apply";
    private static final String RESET = "reset";
    private static final Logger logger = LogManager.getLogger(OmahaCEIPPage.class);
    private static final String kIdPrefix = "CEIP.";
    private static final String kCEIPHeaderId = "CEIP.CEIPHeader";
    private static final String kCEIPMsg = "CEIP.CEIPMessage";
    private static final String kEnableCEIPLabel = "CEIP.EnableCEIPLabel";
    private static final String kApplyButton = "PCNS.ApplyButton";
    private static final String kResetButton = "PCNS.UndoButton";
    private String theEnableUpdatesHeaderText;
    private String theEnableUpdatesSubHeaderText;
    private String theCEIPMsg;
    private String theEnableCEIPLabel;
    private String theApplyButtonText;
    private String theResetButtonText;
    public static final String kCEIPForm = "CEIP";
    public static final String kUpdatesEnabled = "UpdatesEnabled";
    public static final String kUpdateTrapEnabled = "UpdateTrapEnabled";
    public static final String kUpdatesProxy = "UpdatesProxy";
    public static final String kUpdatesPort = "UpdatesPort";
    private ServiceManager services;

    public OmahaCEIPPage(@NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
    }

    @Override
    public StringBuilder toHTML(PageContext pageContext) {
        logger.debug("toHTML() - start");
        ApcPage apcPage = new ApcPage(this.services);
        apcPage.addScript("scripts/navigation.js");
        apcPage.addStyleSheet("styles/form.css");
        apcPage.addStyleSheet("styles/ceip.css");
        this.setupLanguage(pageContext.getLocale());
        this.setupEnableUpdates(apcPage, pageContext);
        StringBuilder stringBuilder = new StringBuilder();
        HTMLDebug.htmlComment(stringBuilder, "Begin OmahaCEIPPage");
        stringBuilder.append((CharSequence)apcPage.toHTML(pageContext));
        HTMLDebug.htmlComment(stringBuilder, "End OmahaCEIPPage");
        stringBuilder.trimToSize();
        return stringBuilder;
    }

    private void setupEnableUpdates(ApcPage apcPage, PageContext pageContext) {
        ApcSectionHeader apcSectionHeader = new ApcSectionHeader(this.theEnableUpdatesHeaderText, this.theEnableUpdatesSubHeaderText);
        apcSectionHeader.setHelpId(ApcHelp.CEIP);
        apcPage.add(apcSectionHeader);
        ApcForm apcForm = new ApcForm(kCEIPForm, "/ceip");
        apcForm.setId("ceipForm");
        Division division = new Division();
        division.setId(kCEIPForm);
        Division division2 = new Division();
        division2.add(new Text(this.theCEIPMsg));
        division.add(division2);
        Division division3 = new Division();
        division3.add(new Text(this.theEnableCEIPLabel));
        division.add(division3);
        Checkbox checkbox = new Checkbox();
        checkbox.setId("CEIPEnabled");
        checkbox.setCheck(!Boolean.FALSE.equals(this.services.getAnalyticsService().isCEIPEnabled()));
        checkbox.setName("CEIPEnabled");
        division.add(checkbox);
        apcForm.add(division);
        apcForm.add(this.createButtonDiv("CEIPSettings"));
        pageContext.addFormToken(apcForm);
        apcPage.add(apcForm);
    }

    private HTML createButtonDiv(String string) {
        Division division = new Division();
        division.setId("buttondiv");
        Input input = new Input();
        input.setName(APPLY);
        input.setValue(this.theApplyButtonText);
        input.setId(APPLY + string);
        input.setType(SUBMIT);
        input.setClassName("newbutton");
        division.add(input);
        Input input2 = new Input();
        input2.setName(RESET + string);
        input2.setValue(this.theResetButtonText);
        input2.setId(RESET + string);
        input2.setType(RESET);
        input2.setClassName("newbutton");
        division.add(input2);
        return division;
    }

    private void setupLanguage(Locale locale) {
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        this.theEnableUpdatesHeaderText = Utils.getResourceString(resourceBundleWrapper, kCEIPHeaderId);
        this.theCEIPMsg = Utils.getResourceString(resourceBundleWrapper, kCEIPMsg);
        this.theEnableCEIPLabel = Utils.getResourceString(resourceBundleWrapper, kEnableCEIPLabel);
        this.theApplyButtonText = Utils.getResourceString(resourceBundleWrapper, kApplyButton);
        this.theResetButtonText = Utils.getResourceString(resourceBundleWrapper, kResetButton);
    }
}

