/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.pages;

import com.apcc.m11.arch.VariableBinding;
import com.apcc.m11.components.webserver.html.Container;
import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.HTMLTagWithClassStyle;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.Text;
import com.apcc.m11.components.webserver.html.apc.ApcForm;
import com.apcc.m11.components.webserver.html.apc.ApcHelp;
import com.apcc.m11.components.webserver.html.apc.ApcPage;
import com.apcc.m11.components.webserver.html.apc.ApcSectionHeader;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.html.document.Heading;
import com.apcc.m11.components.webserver.html.document.Span;
import com.apcc.m11.components.webserver.html.form.Input;
import com.apcc.m11.components.webserver.html.form.TextInput;
import com.apcc.m11.components.webserver.html.util.Image;
import com.apcc.m11.components.webserver.servlets.ConfigureShutdownSettings;
import com.apcc.m11.components.webserver.util.FormHelper;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.m11.ds.powersource.Control;
import com.apcc.m11.ds.services.commandExecution.CommandFile;
import com.apcc.m11.ds.services.messageBroadcastGroup.AllRecipients;
import com.apcc.m11.ds.services.messageBroadcastGroup.Recipient;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.util.Locale;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OmahaConfigureShutdownSettingsPage
implements HTML {
    private static final Logger logger = LogManager.getLogger(OmahaConfigureShutdownSettingsPage.class);
    public static final String PARAM_NAME_ACTIVE_ACCORDION = "activeAcc";
    private static final String kShutdownSettingsError = "Shutdown.ErrorText";
    private static final String kShutdownHeader = "Shutdown.Heading";
    private static final String kShutdownSubHeader = "Shutdown.SubHeading";
    private static final String kUPSShutdownHeader = "Shutdown.UPSShutdownHeader";
    private static final String kUPSShutdownTurnOffSOG = "Shutdown.TurnOffTheSOG";
    private static final String kUPSShutdownTurnOffUPS = "Shutdown.TurnOffTheUPS";
    private static final String kUPSShutdownTurnOffNone = "Shutdown.TurnOffNone";
    private static final String kSingleTurnOffHeader = "AdvancedConfig.SubHeader";
    private static final String kSingleTurnOffEnable = "AdvancedConfig.TurnOffTheUPS";
    private static final String kSingleTurnOffDelay = "AdvancedConfig.TimeRequiredToFinish";
    private static final String kRunCommandHeader = "Shutdown.RunCommandHeader";
    private static final String kCmdFileToRun = "Shutdown.CommandFileToRun";
    private static final String CMD_PATH_TOOLTIP = "Shutdown.CmdPathTooltip";
    private static final String kInvalidCmdFile = "Shutdown.InvalidCommandFile";
    private static final String kExecuteCommandFileAfterHostShutdown = "Shutdown.ExecuteCommandFileAfterHostShutdown";
    private static final String kCommandDelayLabel = "Shutdown.CommandDelayLabel";
    private static final String kDurationWarning = "Shutdown.DurationWarning";
    private static final String kNotifyHeader = "Shutdown.NotifyHeader";
    private static final String kNotifyEnable = "Notifier.Enable";
    private static final String kNotifyAllUsers = "Notifier.All";
    private static final String kNotifySingleUser = "Notifier.Specific";
    private static final String kNotifyInterval = "Shutdown.NotifyInterval";
    private static final String kApplyButton = "PCNS.ApplyButton";
    private static final String kResetButton = "PCNS.UndoButton";
    private static final String kRangeValidation = "PCNS.RangeValidation";
    private static final String kRequiredField = "PCNS.RequiredField";
    private static final String kWaitTitle = "PCNS.WaitTitle";
    private static final String kWaitText = "PCNS.WaitText";
    private static final String kSecondsUnitLabel = "VMSettings.SecondsUnitLabel";
    private static final String kDurationLabel = "VMSettings.DurationLabel";
    private static final String INVALID_CMD_PATH = "RunCommandFile.InvalidCommandFile";
    private String theShutdownSettingsErrorText;
    private String theShutdownHeaderText;
    private String theShutdownSubHeaderText;
    private String theApplyButtonText;
    private String theResetButtonText;
    private String theUPSShutdownHeaderText;
    private String theUPSShutdownTurnOffSOGText;
    private String theUPSShutdownTurnOffUPSText;
    private String theUPSShutdownTurnOffNoneText;
    private String theSinglePowerFailedEnableText;
    private String theSinglePowerFailedDelayText;
    private String theSingleTurnOffHeaderText;
    private String theRunCommandHeaderText;
    private String theCmdFileToRunText;
    private String theInvalidCmdFileText;
    private String theExecuteCommandFileAfterHostShutdownText;
    private String theCommandDelayLabelText;
    private String theDurationWarningText;
    private String theNotifyHeaderText;
    private String theNotifyEnableText;
    private String theNotifyAllUsersText;
    private String theNotifySingleUserText;
    private String theNotifyIntervalLabelText;
    private String theInvalidTargetFileText;
    private String theDurationLabelText;
    private String theSecondsUnitLabelText;
    private String theRequiredFieldValidationText;
    private String theRangeValidationText;
    private String theWaitTitle;
    private String theWaitText;
    private String theCmdFilePathTooltip;
    private ServiceManager services;

    public OmahaConfigureShutdownSettingsPage(@NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
    }

    @Override
    public StringBuilder toHTML(PageContext pageContext) {
        this.setupLanguage(pageContext.getLocale());
        ApcPage apcPage = new ApcPage(this.services);
        apcPage.addStyleSheet("styles/form.css");
        apcPage.addStyleSheet("styles/shutdownsettings.css");
        apcPage.addScript("scripts/jquery.validate.min.js");
        apcPage.addScript("scripts/navigation.js");
        apcPage.addScript("scripts/shutdownsettings.js");
        ApcSectionHeader apcSectionHeader = new ApcSectionHeader(this.theShutdownHeaderText, this.theShutdownSubHeaderText);
        apcSectionHeader.setHelpId(ApcHelp.SHUTDOWN_SETTINGS);
        apcPage.add(apcSectionHeader);
        ApcForm apcForm = new ApcForm("shuttownsettings", "/configureshutdownsettings");
        apcForm.setId("shutdownsettingsform");
        apcPage.add(apcForm);
        Division division = new Division();
        division.setId("waitDialog");
        division.setCssClass("waitDialog");
        division.setTitle(this.theWaitTitle);
        division.add(new Text(this.theWaitText));
        apcPage.add(division);
        Division division2 = new Division();
        division2.setId("errorcontainer");
        division2.add(new Text(this.theShutdownSettingsErrorText));
        division2.setCssClass("ui-state-error ui-corner-all");
        apcForm.add(division2);
        Division division3 = new Division();
        division3.setId("maindiv");
        division3.setCssClass("formdiv");
        apcForm.add(division3);
        this.displayUPSTurnOffSection(pageContext, division3);
        this.displayRunCommandSection(pageContext, division3);
        if (((Boolean)pageContext.getValue("is_broadcast_supported")).booleanValue()) {
            this.displayNotifySection(pageContext, division3);
        }
        apcForm.add(this.createButtonDiv("ShutdownSettings"));
        Input input = new Input();
        input.setName(PARAM_NAME_ACTIVE_ACCORDION);
        input.setId(PARAM_NAME_ACTIVE_ACCORDION);
        input.setType("hidden");
        String string = (String)pageContext.getValue(PARAM_NAME_ACTIVE_ACCORDION);
        input.setValue(string != null ? string : "0");
        apcForm.add(input);
        pageContext.addFormToken(apcForm);
        apcPage.add(this.createShutdownSettingsResourceStrings());
        return apcPage.toHTML(pageContext);
    }

    private void displayUPSTurnOffSection(PageContext pageContext, Division division) {
        Heading heading = new Heading(3);
        heading.add(new Text(this.theUPSShutdownHeaderText));
        ApcHelp apcHelp = new ApcHelp();
        apcHelp.setHelpId(ApcHelp.UPS_SHUTDOWN);
        heading.add(apcHelp);
        division.add(heading);
        Division division2 = new Division();
        division.add(division2);
        Division division3 = new Division();
        division3.setId("upsturnoffradiobuttons");
        division2.add(division3);
        Boolean bl = (Boolean)pageContext.get(Control.TurnOffPowerSourceOnShutdown.getObjectId());
        if (bl == null) {
            bl = false;
        }
        Boolean bl2 = (Boolean)pageContext.getValue("has_outletgroups");
        Boolean bl3 = false;
        if (bl2.booleanValue() && (bl3 = (Boolean)pageContext.get(Control.TurnOffSOGOnShutdown.getObjectId())) == null) {
            bl3 = false;
        }
        division3.add(FormHelper.createLabelRadioButtonValueDiv(null, this.theUPSShutdownTurnOffNoneText, "TurnOffNone", bl == false && bl3 == false, null, "TurnOff"));
        division3.add(FormHelper.createLabelRadioButtonValueDiv(null, this.theUPSShutdownTurnOffUPSText, "TurnOffUPS", bl != false && bl3 == false, null, "TurnOff"));
        if (bl2.booleanValue()) {
            division3.add(FormHelper.createLabelRadioButtonValueDiv(null, this.theUPSShutdownTurnOffSOGText, "TurnOffSOG", bl3, null, "TurnOff"));
        }
        if (((Boolean)pageContext.getValue("is_redundant")).booleanValue()) {
            Division division4 = new Division();
            division4.setId("singleturnoffdiv");
            division2.add(division4);
            VariableBinding variableBinding = (VariableBinding)pageContext.getValue("single_power_failed_trigger");
            Division division5 = FormHelper.createLabelCheckboxValueDiv(null, this.theSinglePowerFailedEnableText, variableBinding != null, null, "SingleTurnOff", null);
            division5.setId("singleTurnOffEnableDiv");
            division4.add(division5);
            Image image = new Image("/images/Info32.png", "16px", "16px");
            image.setId("singleTurnOffInfoImg");
            image.setCssClass("infoImg");
            image.setTitle(this.theSingleTurnOffHeaderText);
            division5.add(image);
            Division division6 = new Division();
            division6.setId("singleturnOffdelaydiv");
            division4.add(division6);
            Integer n = ConfigureShutdownSettings.DEFAULT_SINTLE_TURNOFF_DELAY;
            if (variableBinding != null && variableBinding.getValue() != null) {
                n = (Integer)variableBinding.getValue();
            }
            division6.add(FormHelper.createLabelTextInputValueDiv(null, this.theSinglePowerFailedDelayText, n.toString(), null, "SingleTurnOffDelay", null, (Integer)4, null, this.theSecondsUnitLabelText, null));
        }
    }

    private void displayRunCommandSection(PageContext pageContext, Division division) {
        Object object;
        Heading heading = new Heading(3);
        heading.add(new Text(this.theRunCommandHeaderText));
        ApcHelp apcHelp = new ApcHelp();
        apcHelp.setHelpId(ApcHelp.RUN_COMMAND);
        heading.add(apcHelp);
        division.add(heading);
        Division division2 = new Division();
        division.add(division2);
        Integer n = 0;
        String string = "";
        CommandFile commandFile = (CommandFile)pageContext.getValue("cmdfile");
        if (commandFile != null) {
            if (commandFile.getPath() != null) {
                string = commandFile.getPath();
            }
            n = commandFile.getPeriodicInterval();
        }
        division2.add(FormHelper.createLabelTextInputValueDiv("cmdFilePathDiv", this.theCmdFileToRunText, string, null, "cmdFilePath", "cmdfilepath", (Integer)255, (Integer)40, null, this.theCmdFilePathTooltip));
        Division division3 = FormHelper.createLabelTextInputValueDiv("cmdFileDurationDiv", this.theDurationLabelText, n.toString(), null, "CmdFileDuration", null, (Integer)6, null, this.theSecondsUnitLabelText, null);
        division2.add(division3);
        Image image = new Image("/images/Info32.png", "16px", "16px");
        image.setId("durationWarningImg");
        image.setCssClass("infoImg");
        image.setTitle(this.theDurationWarningText);
        division3.add(image);
        Boolean bl = (Boolean)pageContext.getValue("cmdfile_invalid");
        if (bl != null && bl.booleanValue()) {
            object = new Division();
            ((HTMLTagWithClassStyle)object).setId("cmdfile_invalid");
            division2.add((HTML)object);
        }
        if ((object = (Boolean)pageContext.getValue("executeCommandFileAfterHostShutdown")) != null) {
            Division division4 = new Division();
            division2.add(division4);
            division4.setId("cmfFileDelayDiv");
            division4.add(FormHelper.createLabelCheckboxValueDiv(null, this.theExecuteCommandFileAfterHostShutdownText, (Boolean)object, "cmdFileDelayCheckbox", "executeCommandFileAfterHostShutdown"));
            Integer n2 = (Integer)pageContext.getValue("cmdFileDelay");
            if (n2 == null) {
                n2 = 0;
            }
            division4.add(FormHelper.createLabelTextInputValueDiv("cmdfiledelayDiv", this.theCommandDelayLabelText, n2.toString(), null, "cmdFileDelay", null, 6, null, this.theSecondsUnitLabelText));
        }
    }

    private void displayNotifySection(PageContext pageContext, Division division) {
        Object object;
        Boolean bl = (Boolean)pageContext.getValue("notifyEnabled");
        if (bl == null) {
            bl = false;
        }
        Integer n = 0;
        String string = "";
        boolean bl2 = true;
        if (bl.booleanValue() && (object = (Recipient)pageContext.getValue("recipient")) != null) {
            n = ((Recipient)object).getPeriodicInterval();
            bl2 = ((Recipient)object).getAddress().equals(AllRecipients.kOid.toString());
            if (!bl2) {
                string = ((Recipient)object).getAddress();
            }
        }
        object = new Heading(3);
        ((Container)object).add(new Text(this.theNotifyHeaderText));
        ApcHelp apcHelp = new ApcHelp();
        apcHelp.setHelpId(ApcHelp.NOTIFY_USER_ACTION1);
        ((Container)object).add(apcHelp);
        division.add((HTML)object);
        Division division2 = new Division();
        division.add(division2);
        division2.add(FormHelper.createLabelCheckboxValueDiv("notifyEnableDiv", this.theNotifyEnableText, bl, "notifyenablecheckbox", "notifyEnabled", null));
        Division division3 = new Division();
        division2.add(division3);
        division3.setId("notifysettings");
        division3.add(FormHelper.createLabelRadioButtonValueDiv(null, this.theNotifyAllUsersText, "notifyAllUsers", bl2, null, "notifyUser"));
        Division division4 = FormHelper.createLabelRadioButtonValueDiv(null, this.theNotifySingleUserText, "notifySingleUser", !bl2, null, "notifyUser");
        division3.add(division4);
        Span span = new Span();
        division4.add(span);
        span.setCssClass("value");
        TextInput textInput = new TextInput("singleUserName");
        span.add(textInput);
        textInput.setValue(string);
        textInput.setSize("24");
        textInput.setMaxLength("128");
        division3.add(FormHelper.createLabelTextInputValueDiv("repeatIntervalDiv", this.theNotifyIntervalLabelText, n.toString(), null, "notifyInterval", null, (Integer)4, null, this.theSecondsUnitLabelText, null));
    }

    private HTML createButtonDiv(String string) {
        Division division = new Division();
        division.setId("buttondiv");
        Input input = new Input();
        input.setName("apply");
        input.setValue(this.theApplyButtonText);
        input.setId("apply" + string);
        input.setType("submit");
        input.setClassName("newbutton");
        division.add(input);
        Input input2 = new Input();
        input2.setName("reset" + string);
        input2.setValue(this.theResetButtonText);
        input2.setId("reset" + string);
        input2.setType("reset");
        input2.setClassName("newbutton");
        division.add(input2);
        return division;
    }

    private Division createShutdownSettingsResourceStrings() {
        Division division = new Division();
        division.setId("jsres");
        Span span = new Span(this.theRequiredFieldValidationText);
        span.setId("resRequiredFieldValidation");
        division.add(span);
        span = new Span(this.theRangeValidationText);
        span.setId("resRangeValidation");
        division.add(span);
        span = new Span(this.theInvalidCmdFileText);
        span.setId("resInvalidCmdFile");
        division.add(span);
        span = new Span(this.theInvalidTargetFileText);
        span.setId("resInvalidTargetFile");
        division.add(span);
        return division;
    }

    private void setupLanguage(Locale locale) {
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        this.theShutdownHeaderText = Utils.getResourceString(resourceBundleWrapper, kShutdownHeader);
        this.theShutdownSubHeaderText = Utils.getResourceString(resourceBundleWrapper, kShutdownSubHeader);
        this.theUPSShutdownHeaderText = Utils.getResourceString(resourceBundleWrapper, kUPSShutdownHeader);
        this.theUPSShutdownTurnOffSOGText = Utils.getResourceString(resourceBundleWrapper, kUPSShutdownTurnOffSOG);
        this.theUPSShutdownTurnOffUPSText = Utils.getResourceString(resourceBundleWrapper, kUPSShutdownTurnOffUPS);
        this.theUPSShutdownTurnOffNoneText = Utils.getResourceString(resourceBundleWrapper, kUPSShutdownTurnOffNone);
        this.theSinglePowerFailedEnableText = Utils.getResourceString(resourceBundleWrapper, kSingleTurnOffEnable);
        this.theSinglePowerFailedDelayText = Utils.getResourceString(resourceBundleWrapper, kSingleTurnOffDelay);
        this.theSingleTurnOffHeaderText = Utils.getResourceString(resourceBundleWrapper, kSingleTurnOffHeader);
        this.theRunCommandHeaderText = Utils.getResourceString(resourceBundleWrapper, kRunCommandHeader);
        this.theCmdFileToRunText = Utils.getResourceString(resourceBundleWrapper, kCmdFileToRun);
        this.theCmdFilePathTooltip = Utils.getResourceString(resourceBundleWrapper, CMD_PATH_TOOLTIP);
        this.theInvalidCmdFileText = Utils.getResourceString(resourceBundleWrapper, kInvalidCmdFile);
        this.theExecuteCommandFileAfterHostShutdownText = Utils.getResourceString(resourceBundleWrapper, kExecuteCommandFileAfterHostShutdown);
        this.theCommandDelayLabelText = Utils.getResourceString(resourceBundleWrapper, kCommandDelayLabel);
        this.theDurationWarningText = Utils.getResourceString(resourceBundleWrapper, kDurationWarning);
        this.theNotifyHeaderText = Utils.getResourceString(resourceBundleWrapper, kNotifyHeader);
        this.theNotifyEnableText = Utils.getResourceString(resourceBundleWrapper, kNotifyEnable);
        this.theNotifyAllUsersText = Utils.getResourceString(resourceBundleWrapper, kNotifyAllUsers);
        this.theNotifySingleUserText = Utils.getResourceString(resourceBundleWrapper, kNotifySingleUser);
        this.theNotifyIntervalLabelText = Utils.getResourceString(resourceBundleWrapper, kNotifyInterval);
        this.theSecondsUnitLabelText = Utils.getResourceString(resourceBundleWrapper, kSecondsUnitLabel);
        this.theDurationLabelText = Utils.getResourceString(resourceBundleWrapper, kDurationLabel);
        this.theShutdownSettingsErrorText = Utils.getResourceString(resourceBundleWrapper, kShutdownSettingsError);
        this.theApplyButtonText = Utils.getResourceString(resourceBundleWrapper, kApplyButton);
        this.theResetButtonText = Utils.getResourceString(resourceBundleWrapper, kResetButton);
        this.theRequiredFieldValidationText = Utils.getResourceString(resourceBundleWrapper, kRequiredField);
        this.theRangeValidationText = Utils.getResourceString(resourceBundleWrapper, kRangeValidation);
        this.theWaitTitle = Utils.getResourceString(resourceBundleWrapper, kWaitTitle);
        this.theWaitText = Utils.getResourceString(resourceBundleWrapper, kWaitText);
        this.theInvalidTargetFileText = Utils.getResourceString(resourceBundleWrapper, INVALID_CMD_PATH);
    }
}

