/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.pages;

import com.apcc.m11.components.webserver.html.Container;
import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.Text;
import com.apcc.m11.components.webserver.html.apc.ApcForm;
import com.apcc.m11.components.webserver.html.apc.ApcHelp;
import com.apcc.m11.components.webserver.html.apc.ApcPage;
import com.apcc.m11.components.webserver.html.apc.ApcSectionHeader;
import com.apcc.m11.components.webserver.html.apc.ApcSectionLabel;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.html.document.Span;
import com.apcc.m11.components.webserver.html.table.Table;
import com.apcc.m11.components.webserver.html.table.TableHeader;
import com.apcc.m11.components.webserver.html.table.TableRow;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.util.Locale;
import lombok.NonNull;

public class OmahaConnectedServers
implements HTML {
    private Integer setupId;
    private static final String kHeaderId = "ConnectedServer.Header";
    private static final String kSubHeaderId = "ConnectedServer.SubHeader";
    private static final String kNoServersId = "ConnectedServer.NoServers";
    private static final String kNameHeadingId = "ConnectedServer.NameHeading";
    private static final String kIPHeadingId = "ConnectedServer.IPHeading";
    private static final String kErrorId = "ConnectedServer.Error";
    private static final String kNameHeaderId = "ConnectedServer.NameHeader";
    private static final String kIpHeaderId = "ConnectedServer.IpHeader";
    private static final String kAgentCount = "EventLog.AgentCount";
    private static final String kFirst = "EventLog.PaginationFirst";
    private static final String kNext = "EventLog.PaginationNext";
    private static final String kLast = "EventLog.PaginationLast";
    private static final String kPrevious = "EventLog.PaginationPrevious";
    private static final String kDisplay = "EventLog.Display";
    private static final String kAgents = "ConnectedServer.Agents";
    private static final String kProcessing = "ConnectedServer.Processing";
    private String theNameHeaderText;
    private String theHeaderText;
    private String theSubHeaderText;
    private String theIpHeaderText;
    private String theNoServersText;
    private String theNameHeadingText;
    private String theIPHeadingText;
    private String theErrorText;
    private String theAgentsCountText;
    private String theFirstText;
    private String theNextText;
    private String theLastText;
    private String thePreviousText;
    private String theDisplayText;
    private String theAgentsText;
    private String theProcessingText;
    private ServiceManager services;

    public OmahaConnectedServers(Integer n, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.setupId = n;
        this.services = serviceManager;
    }

    @Override
    public StringBuilder toHTML(PageContext pageContext) {
        this.setupLanguage(pageContext.getLocale());
        ApcPage apcPage = new ApcPage(this.services);
        apcPage.addScript("scripts/datatables.min.js");
        apcPage.addScript("scripts/connectedServers.js");
        apcPage.addStyleSheet("styles/datatables.min.css");
        ApcSectionHeader apcSectionHeader = new ApcSectionHeader(this.theHeaderText, this.theSubHeaderText);
        apcSectionHeader.setHelpId(ApcHelp.POWECHUTE_AGENTS);
        apcPage.add(apcSectionHeader);
        ApcForm apcForm = new ApcForm("ConnectedServers", "/ConnectedServers");
        Table table = new Table(true);
        table.setId("servers");
        table.setCssClass("Table_Table");
        apcForm.add(table);
        TableRow tableRow = new TableRow();
        tableRow.setCssClass("Table_Header");
        TableHeader tableHeader = new TableHeader(new ApcSectionLabel(this.theNameHeaderText));
        tableHeader.setCssClass("Table_Table");
        TableHeader tableHeader2 = new TableHeader(new ApcSectionLabel(this.theIpHeaderText));
        tableHeader2.setCssClass("Table_Table");
        tableRow.add(tableHeader);
        tableRow.add(tableHeader2);
        table.addHeaderRow(tableRow);
        pageContext.addFormToken(apcForm);
        apcPage.add(apcForm);
        Division division = new Division();
        division.setId("jsres");
        division.setCssClass("hidden");
        this.createResources(division);
        apcPage.add(division);
        return apcPage.toHTML(pageContext);
    }

    private void createResources(Container container) {
        Span span = new Span();
        span.setId("resAgentCount");
        span.add(new Text(this.theAgentsCountText));
        container.add(span);
        Span span2 = new Span();
        span2.setId("resNoAgents");
        span2.add(new Text(this.theNoServersText));
        container.add(span2);
        Span span3 = new Span();
        span3.setId("resAgents");
        span3.add(new Text(this.theAgentsText));
        container.add(span3);
        Span span4 = new Span();
        span4.setId("resProcessing");
        span4.add(new Text(this.theProcessingText));
        container.add(span4);
    }

    private void setupLanguage(Locale locale) {
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        this.theHeaderText = Utils.getResourceString(resourceBundleWrapper, kHeaderId);
        this.theSubHeaderText = Utils.getResourceString(resourceBundleWrapper, kSubHeaderId);
        this.theNoServersText = Utils.getResourceString(resourceBundleWrapper, kNoServersId);
        this.theNameHeadingText = Utils.getResourceString(resourceBundleWrapper, kNameHeadingId);
        this.theIPHeadingText = Utils.getResourceString(resourceBundleWrapper, kIPHeadingId);
        this.theErrorText = Utils.getResourceString(resourceBundleWrapper, kErrorId);
        this.theNameHeaderText = Utils.getResourceString(resourceBundleWrapper, kNameHeaderId);
        this.theIpHeaderText = Utils.getResourceString(resourceBundleWrapper, kIpHeaderId);
        this.theAgentsCountText = Utils.formatDatatablesCount(Utils.getResourceString(resourceBundleWrapper, kAgentCount));
        this.theFirstText = Utils.formatDatatablesCount(Utils.getResourceString(resourceBundleWrapper, kFirst));
        this.theNextText = Utils.formatDatatablesCount(Utils.getResourceString(resourceBundleWrapper, kNext));
        this.theLastText = Utils.formatDatatablesCount(Utils.getResourceString(resourceBundleWrapper, kLast));
        this.thePreviousText = Utils.formatDatatablesCount(Utils.getResourceString(resourceBundleWrapper, kPrevious));
        this.theDisplayText = Utils.formatDatatablesCount(Utils.getResourceString(resourceBundleWrapper, kDisplay));
        this.theAgentsText = Utils.formatDatatablesCount(Utils.getResourceString(resourceBundleWrapper, kAgents));
        this.theProcessingText = Utils.formatDatatablesCount(Utils.getResourceString(resourceBundleWrapper, kProcessing));
    }
}

