/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.pages;

import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.HTMLDebug;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.Text;
import com.apcc.m11.components.webserver.html.apc.ApcForm;
import com.apcc.m11.components.webserver.html.apc.ApcHelp;
import com.apcc.m11.components.webserver.html.apc.ApcPage;
import com.apcc.m11.components.webserver.html.apc.ApcSectionHeader;
import com.apcc.m11.components.webserver.html.apc.ApcSectionLabel;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.html.form.Button;
import com.apcc.m11.components.webserver.html.table.Table;
import com.apcc.m11.components.webserver.html.table.TableHeader;
import com.apcc.m11.components.webserver.html.table.TableRow;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.util.Locale;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OmahaEventLogPage
implements HTML {
    private static final Logger logger = LogManager.getLogger(OmahaEventLogPage.class);
    private static final String kHeaderId = "EventLog.Header";
    private static final String kSubHeaderId = "EventLog.SubHeader";
    private static final String kDeleteLogId = "EventLog.DeleteLog";
    private static final String kDeleteLogConfMsgId = "EventLog.DeleteLogConfirmMsg";
    private static final String kDeleteLogConfId = "EventLog.DeleteLogConfirm";
    private static final String kDeleteLogCancelId = "EventLog.DeleteLogCancel";
    private static final String kExportLog = "EventLog.ExportLog";
    private static final String kDeleteLogTitle = "EventLog.DeleteLogConfirmTitle";
    private static final String kEventCount = "EventLog.EventCount";
    private static final String kDisplay = "EventLog.Display";
    private static final String kEventsTitle = "EventLog.EventsTitle";
    private static final String kPaginationFirst = "EventLog.PaginationFirst";
    private static final String kPaginationNext = "EventLog.PaginationNext";
    private static final String kPaginationLast = "EventLog.PaginationLast";
    private static final String kPaginationPrevious = "EventLog.PaginationPrevious";
    private static final String kNoLoggedEventsId = "EventLog.NoLoggedEvents";
    private static final String kDateHeaderId = "EventLog.DateHeader";
    private static final String kTimeHeaderId = "EventLog.TimeHeader";
    private static final String kEventHeaderId = "EventLog.EventHeader";
    private String theHeaderText;
    private String theSubHeaderText;
    private String theDeleteLogText;
    private String theDeleteLogConfMsgText;
    private String theDeleteLogConfText;
    private String theDeleteLogCancelText;
    private String theExportLogText;
    private String theDeleteLogTitle;
    private String theNoLoggedEventsText;
    private String theDateHeaderText;
    private String theTimeHeaderText;
    private String theEventHeaderText;
    private String theTimeFormatText;
    private String theDateFormatText;
    private String theEventCountText;
    private String theDisplayText;
    private String theEventsTitleText;
    private String thePaginationFirstText;
    private String thePaginationNextText;
    private String thePaginationLastText;
    private String thePaginationPreviousText;
    private ApcPage thePage;

    public OmahaEventLogPage(@NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.thePage = new ApcPage(serviceManager);
    }

    @Override
    public StringBuilder toHTML(PageContext pageContext) {
        this.setupLanguage(pageContext.getLocale());
        this.thePage.addScript("scripts/datatables.min.js");
        this.thePage.addStyleSheet("styles/datatables.min.css");
        this.thePage.addScript("scripts/AJAXLog.js");
        this.thePage.addStyleSheet("styles/eventlog.css");
        Division division = new Division();
        division.setId("eventContainer");
        this.thePage.add(division);
        ApcForm apcForm = new ApcForm("eventlogform", "/eventlog");
        this.thePage.add(apcForm);
        pageContext.addFormToken(apcForm);
        Division division2 = new Division();
        division2.setId("headerDiv");
        Division division3 = new Division();
        division3.setId("EventPageHeader");
        ApcSectionHeader apcSectionHeader = new ApcSectionHeader(this.theHeaderText, this.theSubHeaderText);
        apcSectionHeader.setHelpId(ApcHelp.VIEWING_THE_EVENT_LOG1);
        division3.add(apcSectionHeader);
        Button button = new Button();
        button.setValue(this.theDeleteLogText);
        button.setId("DeleteLogButton");
        button.setClassName("newbutton headerButtons");
        button.setOnClick("ConfirmDelete()");
        division2.add(button);
        ApcForm apcForm2 = new ApcForm("exportlogform", "/ExportLog");
        pageContext.addFormToken(apcForm2);
        Button button2 = new Button();
        button2.setValue(this.theExportLogText);
        button2.setId("ExportLogButton");
        button2.setClassName("newbutton headerButtons");
        apcForm2.add(button2);
        button2.setType("submit");
        division2.add(apcForm2);
        division3.add(division2);
        division.add(division3);
        Division division4 = new Division();
        division4.setId("deleteLogDialog");
        division4.setTitle(this.theDeleteLogTitle);
        division4.add(new Text(this.theDeleteLogConfMsgText));
        Division division5 = new Division();
        division5.setId("deleteYes");
        division5.add(new Text(this.theDeleteLogConfText));
        division5.setStyle("display: none");
        Division division6 = new Division();
        division6.setId("deleteNo");
        division6.add(new Text(this.theDeleteLogCancelText));
        division6.setStyle("display: none");
        division4.add(division5);
        division4.add(division6);
        this.thePage.add(division4);
        Division division7 = new Division();
        division7.setId("LogTable");
        Table table = new Table(true);
        table.setId("EventLog");
        table.setCssClass("EventLog_Table");
        table.setCssClass("cell-border");
        TableRow tableRow = new TableRow();
        tableRow.setCssClass("Event_Header");
        TableHeader tableHeader = new TableHeader(new ApcSectionLabel(this.theDateHeaderText));
        tableHeader.setCssClass("Table_Table");
        TableHeader tableHeader2 = new TableHeader(new ApcSectionLabel(this.theTimeHeaderText));
        tableHeader2.setCssClass("Table_Table");
        TableHeader tableHeader3 = new TableHeader(new ApcSectionLabel(this.theEventHeaderText));
        tableHeader3.setCssClass("Table_Table");
        tableRow.add(tableHeader);
        tableRow.add(tableHeader2);
        tableRow.add(tableHeader3);
        table.addHeaderRow(tableRow);
        division7.add(table);
        division.add(division7);
        Division division8 = new Division();
        Division division9 = new Division();
        division9.setId("resNoEventsLogged");
        division9.add(new Text(this.theNoLoggedEventsText));
        division8.add(division9);
        Division division10 = new Division();
        division10.setId("resEventCount");
        division10.add(new Text(this.theEventCountText));
        division8.add(division10);
        Division division11 = new Division();
        division11.setId("resDisplay");
        division11.add(new Text(this.theDisplayText));
        division8.add(division11);
        Division division12 = new Division();
        division12.setId("resEventsTitle");
        division12.add(new Text(this.theEventsTitleText));
        division8.add(division12);
        Division division13 = new Division();
        division13.setId("resPaginationFirst");
        division13.add(new Text(this.thePaginationFirstText));
        division8.add(division13);
        Division division14 = new Division();
        division14.setId("resPaginationNext");
        division14.add(new Text(this.thePaginationNextText));
        division8.add(division14);
        Division division15 = new Division();
        division15.setId("resPaginationLast");
        division15.add(new Text(this.thePaginationLastText));
        division8.add(division15);
        Division division16 = new Division();
        division16.setId("resPaginationPrevious");
        division16.add(new Text(this.thePaginationPreviousText));
        division8.add(division16);
        division8.setCssClass("hidden");
        this.thePage.add(division8);
        StringBuilder stringBuilder = new StringBuilder();
        HTMLDebug.htmlComment(stringBuilder, "Begin OmahaEventLogPage");
        stringBuilder.append((CharSequence)this.thePage.toHTML(pageContext));
        HTMLDebug.htmlComment(stringBuilder, "End OmahaEventLogPage");
        stringBuilder.trimToSize();
        return stringBuilder;
    }

    public void setupLanguage(Locale locale) {
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        this.theHeaderText = Utils.getResourceString(resourceBundleWrapper, kHeaderId);
        this.theSubHeaderText = Utils.getResourceString(resourceBundleWrapper, kSubHeaderId);
        this.theDeleteLogText = Utils.getResourceString(resourceBundleWrapper, kDeleteLogId);
        this.theDeleteLogConfMsgText = Utils.getResourceString(resourceBundleWrapper, kDeleteLogConfMsgId);
        this.theDeleteLogConfText = Utils.getResourceString(resourceBundleWrapper, kDeleteLogConfId);
        this.theDeleteLogCancelText = Utils.getResourceString(resourceBundleWrapper, kDeleteLogCancelId);
        this.theExportLogText = Utils.getResourceString(resourceBundleWrapper, kExportLog);
        this.theDeleteLogTitle = Utils.getResourceString(resourceBundleWrapper, kDeleteLogTitle);
        this.theNoLoggedEventsText = Utils.getResourceString(resourceBundleWrapper, kNoLoggedEventsId);
        this.theDateHeaderText = Utils.getResourceString(resourceBundleWrapper, kDateHeaderId);
        this.theTimeHeaderText = Utils.getResourceString(resourceBundleWrapper, kTimeHeaderId);
        this.theEventHeaderText = Utils.getResourceString(resourceBundleWrapper, kEventHeaderId);
        this.theEventCountText = Utils.formatDatatablesCount(Utils.getResourceString(resourceBundleWrapper, kEventCount));
        this.theDisplayText = Utils.getResourceString(resourceBundleWrapper, kDisplay);
        this.theEventsTitleText = Utils.getResourceString(resourceBundleWrapper, kEventsTitle);
        this.thePaginationFirstText = Utils.getResourceString(resourceBundleWrapper, kPaginationFirst);
        this.thePaginationNextText = Utils.getResourceString(resourceBundleWrapper, kPaginationNext);
        this.thePaginationLastText = Utils.getResourceString(resourceBundleWrapper, kPaginationLast);
        this.thePaginationPreviousText = Utils.getResourceString(resourceBundleWrapper, kPaginationPrevious);
    }
}

