/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.pages;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.VariableBinding;
import com.apcc.m11.components.omaha.flexeventdescriptors.RunTimeRemainingDescriptor;
import com.apcc.m11.components.webserver.html.Container;
import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.HTMLTagWithClassStyle;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.Text;
import com.apcc.m11.components.webserver.html.apc.ApcHelp;
import com.apcc.m11.components.webserver.html.apc.ApcPage;
import com.apcc.m11.components.webserver.html.apc.ApcSectionHeader;
import com.apcc.m11.components.webserver.html.apc.ApcSectionLabel;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.html.document.Span;
import com.apcc.m11.components.webserver.html.table.Table;
import com.apcc.m11.components.webserver.html.table.TableData;
import com.apcc.m11.components.webserver.html.table.TableHeader;
import com.apcc.m11.components.webserver.html.table.TableRow;
import com.apcc.m11.components.webserver.html.util.Anchor;
import com.apcc.m11.components.webserver.html.util.Image;
import com.apcc.m11.components.webserver.pages.OmahaStdPages;
import com.apcc.m11.components.webserver.servlets.M11Servlet;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.m11.ds.actions.FlexActions;
import com.apcc.m11.ds.events.flexevents.RuntimeVerifierEvents;
import com.apcc.m11.ds.events.flexevents.powersource.MultipleEvent;
import com.apcc.m11.ds.services.ShutdownGroup;
import com.apcc.m11.ds.services.commandExecution.CommandExecution;
import com.apcc.m11.ds.services.eventlogginggroup.EventLoggingGroup;
import com.apcc.m11.ds.services.messageBroadcastGroup.ListOfNotificationRecipients;
import com.apcc.m11.ds.services.omaha.IFlexEventDescriptor;
import com.apcc.m11.ds.services.omaha.Omaha;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OmahaEventWizardPage
implements HTML {
    private static final Logger logger = LogManager.getLogger(OmahaEventWizardPage.class);
    private static final String kHeaderId = "Event.Header";
    private static final String kSubHeaderId = "Event.SubHeader";
    private static final String kEventHeaderId = "Event.EventHeader";
    private static final String kLogHeaderId = "Event.LogHeader";
    private static final String kNotifyHeaderId = "Event.NotifyHeader";
    private static final String kShutdownHeaderId = "Event.ShutdownHeader";
    private static final String kTurnOffUpsHeaderId = "Event.TurnOffUpsHeader";
    private static final String kCommandFileHeaderId = "Event.CommandFileHeader";
    private static final String kNoCanDoId = "Event.NoCanDo";
    private static final String kEventErrorId = "Event.EventError";
    private static final String kEventCount = "EventLog.EventCount";
    private static final String kApplyId = "PCNS.ApplyButton";
    private static final String kCancelId = "PCNS.CancelButton";
    private static final String kHelpId = "PCNS.HelpButton";
    private static final ObjectId kSinglePowerFailedOid = MultipleEvent.SinglePowerFailed.getObjectId();
    private static final ObjectId kSinglePowerRestoredOid = MultipleEvent.SinglePowerRestored.getObjectId();
    private static final ObjectId kSingleOutletOffOid = MultipleEvent.SingleOutletOff.getObjectId();
    private static final ObjectId kSingleOutletRestoredOid = MultipleEvent.SingleOutletRestored.getObjectId();
    private static final String OID_ATTRIBUTE = "data-oid";
    private static final String ACTION_ATTRIBUTE = "data-action";
    private String theHeaderText;
    private String theSubHeaderText;
    private String theEventHeaderText;
    private String theLogHeaderText;
    private String theNotifyHeaderText;
    private String theShutdownHeaderText;
    private String theTurnOffUpsHeaderText;
    private String theCommandFileHeaderText;
    private String theNoCanDoText;
    private String theEventErrorText;
    private String theEventCountText;
    private String theApplyText;
    private String theCancelText;
    private String theHelpText;
    private boolean theNotificationEnabled = true;
    private ServiceManager services;

    public OmahaEventWizardPage(@NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
        this.theNotificationEnabled = Utils.isBroadcastSupported();
        logger.debug("Notification Enabled: " + this.theNotificationEnabled);
    }

    public void setupLanguage(Locale locale) {
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        this.theHeaderText = Utils.getResourceString(resourceBundleWrapper, kHeaderId);
        this.theEventHeaderText = Utils.getResourceString(resourceBundleWrapper, kEventHeaderId);
        this.theSubHeaderText = Utils.getResourceString(resourceBundleWrapper, kSubHeaderId);
        this.theLogHeaderText = Utils.getResourceString(resourceBundleWrapper, kLogHeaderId);
        this.theNotifyHeaderText = Utils.getResourceString(resourceBundleWrapper, kNotifyHeaderId);
        this.theShutdownHeaderText = Utils.getResourceString(resourceBundleWrapper, kShutdownHeaderId);
        this.theTurnOffUpsHeaderText = Utils.getResourceString(resourceBundleWrapper, kTurnOffUpsHeaderId);
        this.theCommandFileHeaderText = Utils.getResourceString(resourceBundleWrapper, kCommandFileHeaderId);
        this.theNoCanDoText = Utils.getResourceString(resourceBundleWrapper, kNoCanDoId);
        this.theEventErrorText = Utils.getResourceString(resourceBundleWrapper, kEventErrorId);
        this.theEventCountText = Utils.formatDatatablesCount(Utils.getResourceString(resourceBundleWrapper, kEventCount));
        this.theApplyText = Utils.getResourceString(resourceBundleWrapper, kApplyId);
        this.theCancelText = Utils.getResourceString(resourceBundleWrapper, kCancelId);
        this.theHelpText = Utils.getResourceString(resourceBundleWrapper, kHelpId);
    }

    private Division createResources() {
        Division division = new Division();
        division.setId("resources");
        division.setCssClass("hidden");
        Span span = new Span(this.theApplyText);
        span.setId("resApply");
        division.add(span);
        Span span2 = new Span(this.theCancelText);
        span2.setId("resCancel");
        division.add(span2);
        Span span3 = new Span(this.theHelpText);
        span3.setId("resHelp");
        division.add(span3);
        return division;
    }

    @Override
    public StringBuilder toHTML(PageContext pageContext) {
        HTMLTagWithClassStyle hTMLTagWithClassStyle;
        HTML hTML;
        Division division;
        ApcPage apcPage;
        block14: {
            logger.debug("toHTML");
            apcPage = new ApcPage(this.services);
            apcPage.addStyleSheet("styles/datatables.min.css");
            apcPage.addStyleSheet("styles/form.css");
            apcPage.addStyleSheet("styles/eventcfg.css");
            apcPage.addScript("scripts/jquery.validate.min.js");
            apcPage.addScript("scripts/datatables.min.js");
            apcPage.addScript("scripts/eventcfg.js");
            apcPage.addScript("scripts/logevent.js");
            apcPage.addScript("scripts/runcmdfile.js");
            apcPage.addScript("scripts/notifyuser.js");
            apcPage.addScript("scripts/cfgshutdown.js");
            try {
                this.setupLanguage(pageContext.getLocale());
                division = new Division();
                logger.debug("set up table");
                hTML = new ApcSectionHeader(this.theHeaderText, this.theSubHeaderText);
                ((ApcSectionHeader)hTML).setHelpId(ApcHelp.CONFIGURING_EVENTS_TO_TAKE_ACTIONS);
                division.add(hTML);
                apcPage.add(division);
                hTMLTagWithClassStyle = new Table(true);
                hTMLTagWithClassStyle.setId("ConfigureEvents");
                Division division2 = new Division();
                division2.setId("ConfigEventTable");
                TableRow tableRow = new TableRow();
                TableHeader tableHeader = new TableHeader(new ApcSectionLabel(this.theEventHeaderText));
                tableHeader.setCssClass("ConfigureEvents_Table");
                TableHeader tableHeader2 = new TableHeader(new ApcSectionLabel(this.theLogHeaderText));
                tableHeader2.setCssClass("ConfigureEvents_Table");
                TableHeader tableHeader3 = new TableHeader(new ApcSectionLabel(this.theNotifyHeaderText));
                tableHeader3.setCssClass("ConfigureEvents_Table");
                TableHeader tableHeader4 = new TableHeader(new ApcSectionLabel(this.theCommandFileHeaderText));
                tableHeader4.setCssClass("ConfigureEvents_Table");
                TableHeader tableHeader5 = M11Servlet.isSecondaryGroup() ? new TableHeader(new ApcSectionLabel(this.theShutdownHeaderText)) : new TableHeader(new ApcSectionLabel(this.theTurnOffUpsHeaderText));
                tableHeader5.setCssClass("ConfigureEvents_Table");
                tableRow.add(tableHeader);
                tableRow.add(tableHeader2);
                if (this.theNotificationEnabled) {
                    tableRow.add(tableHeader3);
                }
                tableRow.add(tableHeader4);
                tableRow.add(tableHeader5);
                ((Table)hTMLTagWithClassStyle).addHeaderRow(tableRow);
                logger.debug("Add the table to the page");
                division2.add(hTMLTagWithClassStyle);
                apcPage.add(division2);
                logger.debug("Get Lists");
                Hashtable hashtable = null;
                Hashtable<String, Object> hashtable2 = null;
                Hashtable<String, Object> hashtable3 = null;
                Hashtable hashtable4 = null;
                try {
                    hashtable = (Hashtable)pageContext.get(CommandExecution.ListOfCommandObjects.getObjectId());
                    hashtable2 = this.toHashtable((Vector)pageContext.get(EventLoggingGroup.ListOfEventsToLog.getObjectId()));
                    hashtable3 = this.toHashtable((Vector)pageContext.get(ShutdownGroup.ShutdownTriggers.getObjectId()));
                    if (this.theNotificationEnabled) {
                        hashtable4 = (Hashtable)pageContext.get(ListOfNotificationRecipients.kOid);
                    }
                }
                catch (Exception exception) {
                    logger.error("unable to get required value", (Throwable)exception);
                }
                if (hashtable4 == null) {
                    hashtable4 = new Hashtable();
                }
                Vector vector = (Vector)pageContext.get(Omaha.FlexEventList.getObjectId());
                int n = 1;
                if (vector == null) {
                    logger.error("no events found in flex event list");
                    HTML hTML2 = OmahaStdPages.getProblemReport(pageContext, this.theEventErrorText, this.services);
                    return hTML2.toHTML(pageContext);
                }
                logger.debug("None of these should be null.  notify=" + String.valueOf(hashtable4) + " cmdfile=" + String.valueOf(hashtable) + " log=" + String.valueOf(hashtable2) + " shutdown=" + String.valueOf(hashtable3));
                if (hashtable4 == null || hashtable == null || hashtable2 == null || hashtable3 == null) break block14;
                for (IFlexEventDescriptor iFlexEventDescriptor : vector) {
                    TableRow tableRow2 = new TableRow();
                    tableRow2.setCssClass("ConfigureEvents_Table");
                    iFlexEventDescriptor.getHMTLId();
                    Object object = null;
                    String string = null;
                    try {
                        object = iFlexEventDescriptor.getNameFormatter().format((Object)iFlexEventDescriptor, pageContext.getLocale());
                        string = iFlexEventDescriptor.getDescriptionFormatter().format((Object)iFlexEventDescriptor, pageContext.getLocale());
                    }
                    catch (Exception exception) {
                        object = "Invalid-name #" + n++;
                    }
                    if (object == null) continue;
                    TableData tableData = new TableData();
                    tableData.setCssClass("ConfigureEvents_NameCell");
                    TableData tableData2 = new TableData();
                    tableData2.setCssClass("ConfigureEvents_ActionCell");
                    TableData tableData3 = new TableData();
                    tableData3.setCssClass("ConfigureEvents_ActionCell");
                    TableData tableData4 = new TableData();
                    tableData4.setCssClass("ConfigureEvents_ActionCell");
                    TableData tableData5 = new TableData();
                    tableData5.setCssClass("ConfigureEvents_ActionCell");
                    Image image = new Image();
                    image.setSource("/images/Info32.png");
                    image.setCssClass("cfgEventIcon");
                    if (string != null) {
                        image.setTitle(string);
                    }
                    Span span = new Span((String)object);
                    tableData.add(image);
                    tableData.add(span);
                    tableData2.add(this.getConfiguredSymbol(iFlexEventDescriptor, hashtable2, "Log", FlexActions.Log.getObjectId()));
                    if (this.theNotificationEnabled) {
                        tableData4.add(this.getConfiguredSymbol(iFlexEventDescriptor, hashtable4, "NotifyUsers", FlexActions.SendNotification.getObjectId()));
                    }
                    tableData5.add(this.getConfiguredSymbol(iFlexEventDescriptor, hashtable3, "Shutdown", FlexActions.Shutdown.getObjectId()));
                    tableData3.add(this.getConfiguredSymbol(iFlexEventDescriptor, hashtable, "RunCommandFile", FlexActions.ExecuteCommandFile.getObjectId()));
                    tableRow2.add(tableData);
                    tableRow2.add(tableData2);
                    if (this.theNotificationEnabled) {
                        tableRow2.add(tableData4);
                    }
                    tableRow2.add(tableData3);
                    tableRow2.add(tableData5);
                    tableRow2.setId(iFlexEventDescriptor.getHMTLId());
                    if (iFlexEventDescriptor.getObjectId().equals((Object)kSinglePowerFailedOid) || iFlexEventDescriptor.getObjectId().equals((Object)kSinglePowerRestoredOid) || iFlexEventDescriptor.getObjectId().equals((Object)kSingleOutletOffOid) || iFlexEventDescriptor.getObjectId().equals((Object)kSingleOutletRestoredOid)) continue;
                    ((Table)hTMLTagWithClassStyle).addRow(tableRow2);
                }
            }
            catch (Exception exception) {
                logger.error("We have barfed on something", (Throwable)exception);
            }
        }
        division = new Division();
        division.setId("resEventCount");
        division.add(new Text(this.theEventCountText));
        division.setCssClass("hidden");
        apcPage.add(division);
        hTML = new Division();
        ((HTMLTagWithClassStyle)hTML).setId("eventDialog");
        hTMLTagWithClassStyle = new Division();
        hTMLTagWithClassStyle.setId("evtCfgData");
        ((Container)hTML).add(hTMLTagWithClassStyle);
        apcPage.add(hTML);
        apcPage.add(this.createResources());
        return apcPage.toHTML(pageContext);
    }

    protected Hashtable<String, Object> toHashtable(Vector<VariableBinding> vector) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (vector != null) {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                VariableBinding variableBinding = vector.elementAt(i);
                hashtable.put(variableBinding.getObjectId().toString(), variableBinding.getValue());
            }
        }
        return hashtable;
    }

    protected HTML getConfiguredSymbol(IFlexEventDescriptor iFlexEventDescriptor, Hashtable<String, Object> hashtable, String string, ObjectId objectId) {
        HTMLTagWithClassStyle hTMLTagWithClassStyle = null;
        Anchor anchor = new Anchor();
        Image image = new Image();
        image.setBorder("0");
        anchor.add(image);
        if (iFlexEventDescriptor.isFlexEventActionAllowed(objectId)) {
            ObjectId objectId2 = iFlexEventDescriptor.getObjectId();
            Object object = hashtable.get(objectId2.toString());
            if (iFlexEventDescriptor instanceof RunTimeRemainingDescriptor && objectId.equals((Object)FlexActions.ExecuteCommandFile.getObjectId())) {
                object = hashtable.get(RuntimeVerifierEvents.RunTimeRemainingCmdFile.getObjectId().toString());
            }
            if (object != null) {
                image.setSource("images/checkmark.gif");
            } else {
                image.setSource("images/emptymark.gif");
            }
            anchor.setAttribute(OID_ATTRIBUTE, objectId2.toString());
            anchor.setAttribute(ACTION_ATTRIBUTE, string);
            anchor.setHypertextReference("#");
            anchor.setCssClass("evtbutton");
            anchor.setId(iFlexEventDescriptor.getHMTLId() + "." + string);
            hTMLTagWithClassStyle = anchor;
        } else {
            image.setSource("images/nocando.gif");
            image.setId(iFlexEventDescriptor.getHMTLId() + "." + string + ".Disabled");
            hTMLTagWithClassStyle = image;
        }
        if (!this.theNotificationEnabled && objectId.equals((Object)FlexActions.SendNotification.getObjectId())) {
            image.setSource("images/nocando.gif");
            hTMLTagWithClassStyle = image;
        }
        return hTMLTagWithClassStyle;
    }
}

