/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.pages;

import com.apcc.m11.components.webserver.html.Container;
import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.HTMLDebug;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.Text;
import com.apcc.m11.components.webserver.html.apc.ApcBoundEntry;
import com.apcc.m11.components.webserver.html.apc.ApcPage;
import com.apcc.m11.components.webserver.html.apc.ApcSection;
import com.apcc.m11.components.webserver.html.apc.ApcSectionHeader;
import com.apcc.m11.components.webserver.html.apc.ApcSectionLabel;
import com.apcc.m11.components.webserver.html.form.Form;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.util.Locale;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OmahaGetSetPage
implements HTML {
    private static final Logger logger = LogManager.getLogger(OmahaGetSetPage.class);
    private static final String kGetOIDError = "GetOIDError";
    private static final String kSetOIDError = "SetOIDError";
    private static final String kSetValueError = "SetValueError";
    private static final String kResponseHeaderId = "RawGetSet.ResponseHeader";
    private static final String kResponseId = "RawGetSet.Response";
    private static final String kGetHeaderId = "RawGetSet.GetHeader";
    private static final String OBJECT_ID = "Object ID";
    private static final String kSetHeaderId = "RawGetSet.SetHeader";
    private static final String kValueId = "RawGetSet.SetValue";
    public static final String kGetOIDName = "GetOID";
    public static final String kSetOIDName = "SetOID";
    public static final String kSetValueName = "SetValue";
    public static final String kGetApplyName = "Get";
    public static final String kSetApplyName = "Set";
    private Text theResponse = new Text();
    private ApcBoundEntry theGetOID = new ApcBoundEntry("GetOID", "GetOIDError");
    private ApcBoundEntry theSetOID = new ApcBoundEntry("SetOID", "SetOIDError");
    private ApcBoundEntry theSetValue = new ApcBoundEntry("SetValue", "SetValueError");
    private String theResponseHeaderText;
    private String theResponseText;
    private String theGetHeaderText;
    private String theSetHeaderText;
    private String theSetValueText;
    private ApcPage thePage;

    public OmahaGetSetPage(@NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.thePage = new ApcPage(serviceManager);
        this.setupLanguage();
        this.thePage.add(this.createResponseSection());
        this.thePage.add(this.createGetSection());
        this.thePage.add(this.createSetSection());
    }

    public void setResponse(String string) {
        this.theResponse.setText(string);
    }

    public void setGetOID(String string) {
        this.theGetOID.getEntry().setValue(string);
    }

    public void setSetOID(String string) {
        this.theSetOID.getEntry().setValue(string);
    }

    public void setSetValue(String string) {
        this.theSetValue.getEntry().setValue(string);
    }

    public void setGetError(String string) {
    }

    @Override
    public StringBuilder toHTML(PageContext pageContext) {
        StringBuilder stringBuilder = new StringBuilder();
        HTMLDebug.htmlComment(stringBuilder, "Begin OmahaGetSetPage");
        stringBuilder.append((CharSequence)this.thePage.toHTML(pageContext));
        HTMLDebug.htmlComment(stringBuilder, "Begin OmahaGetSetPage");
        stringBuilder.trimToSize();
        return stringBuilder;
    }

    public void setupLanguage() {
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(Locale.getDefault());
        this.theResponseHeaderText = "Last Operation Response";
        this.theResponseText = "No operation has been attempted yet.";
        this.theGetHeaderText = "GET Parameters";
        this.theSetHeaderText = "SET Parameters";
        this.theSetValueText = "Value";
    }

    private HTML createResponseSection() {
        ApcSectionHeader apcSectionHeader = new ApcSectionHeader(this.theResponseHeaderText);
        Container container = new Container();
        this.theResponse.setText(this.theResponseText);
        container.add(apcSectionHeader);
        container.add(this.theResponse);
        container.add(new Text("<P><P>"));
        return container;
    }

    private HTML createGetSection() {
        ApcSectionLabel apcSectionLabel = new ApcSectionLabel(OBJECT_ID);
        ApcSectionHeader apcSectionHeader = new ApcSectionHeader(this.theGetHeaderText);
        ApcSection apcSection = new ApcSection();
        apcSection.add(apcSectionLabel, this.theGetOID);
        apcSection.addButtons(kGetApplyName);
        Form form = new Form();
        form.setMethod("POST");
        form.setAction("/debug_getset");
        form.add(apcSectionHeader);
        form.add(apcSection);
        return form;
    }

    private HTML createSetSection() {
        ApcSectionLabel apcSectionLabel = new ApcSectionLabel(OBJECT_ID);
        ApcSectionLabel apcSectionLabel2 = new ApcSectionLabel(this.theSetValueText);
        ApcSectionHeader apcSectionHeader = new ApcSectionHeader(this.theSetHeaderText);
        ApcSection apcSection = new ApcSection();
        apcSection.add(apcSectionLabel, this.theSetOID);
        apcSection.add(apcSectionLabel2, this.theSetValue);
        apcSection.addButtons(kSetApplyName);
        Form form = new Form();
        form.setMethod("POST");
        form.setAction("/debug_getset");
        form.add(apcSectionHeader);
        form.add(apcSection);
        return form;
    }
}

