/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.pages;

import com.apcc.m11.components.webserver.html.Container;
import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.Text;
import com.apcc.m11.components.webserver.html.apc.ApcBoundEntry;
import com.apcc.m11.components.webserver.html.apc.ApcForm;
import com.apcc.m11.components.webserver.html.apc.ApcHelp;
import com.apcc.m11.components.webserver.html.apc.ApcPage;
import com.apcc.m11.components.webserver.html.apc.ApcSectionHeader;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.html.document.NoScript;
import com.apcc.m11.components.webserver.html.form.Input;
import com.apcc.m11.components.webserver.html.form.Password;
import com.apcc.m11.components.webserver.html.form.TextInput;
import com.apcc.m11.components.webserver.util.FormHelper;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.util.Locale;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OmahaLoginPage
implements HTML {
    private static final Logger logger = LogManager.getLogger(OmahaLoginPage.class);
    private static final String kProductId = "Login.Product";
    private static final String kUsernameId = "Login.Username";
    private static final String kPasswordId = "Login.Password";
    private static final String kLoginId = "Login.Login";
    private static final String kResetButtonId = "PCNS.ResetButton";
    private static final String kBackButtonId = "PCNS.BackButton";
    private static final String kLoginMsgId = "Login.LoginMsg";
    private static final String kNote1Id = "Login.Note1";
    private static final String kNote2Id = "Login.Note2";
    private static final String kLockoutId = "Login.Lockout";
    private static final String kInUseId = "Login.InUse";
    private static final String kNoJsId = "Login.NoJavaScript";
    private static final String kNoCookiesId = "Login.NoCookies";
    private String theProductText;
    private String theUsernameText;
    private String thePasswordText;
    private String theLoginText;
    private String theResetButtonText;
    private String theBackButtonText;
    private String theLoginMsgText;
    private String theNote1Text;
    private String theNote2Text;
    private String theLockoutText;
    private String theInUseText;
    private String theNoJsText;
    private String theNoCookiesText;
    private ApcBoundEntry theUsernameEntry = new ApcBoundEntry("user", "UsernameError");
    private ApcBoundEntry thePasswordEntry = new ApcBoundEntry("pass", "PasswordError");
    private ApcPage thePage;
    private static final Integer FROM_LOGIN_PAGE = 0;
    private static final Integer FROM_IN_USE_PAGE = 1;
    private static final Integer FROM_LOCKOUT_PAGE = 2;
    private Integer fromPage;
    private Integer showMsg;

    public OmahaLoginPage(@NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.thePage = new ApcPage(false, false, false, serviceManager);
    }

    @Override
    public StringBuilder toHTML(PageContext pageContext) {
        HTML hTML;
        this.thePage.addStyleSheet("styles/form.css");
        this.thePage.addStyleSheet("styles/login.css");
        this.thePage.addScript("scripts/login.js");
        this.setupLanguage(pageContext.getLocale());
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string = null;
        Boolean bl4 = (Boolean)pageContext.getValue("Login");
        if (bl4 != null) {
            bl = bl4;
        }
        if ((bl4 = (Boolean)pageContext.getValue("LockOut")) != null) {
            bl2 = bl4;
        }
        string = (String)pageContext.getValue("InUse");
        this.fromPage = (Integer)pageContext.getSession().getAttribute("fromPage");
        bl3 = this.getIsInUse(pageContext);
        try {
            this.showMsg = (Integer)pageContext.getSession().getAttribute("showMsg");
            if (this.showMsg == 2) {
                bl = Boolean.TRUE;
                this.fromPage = FROM_LOGIN_PAGE;
            }
            pageContext.getSession().setAttribute("showMsg", (Object)0);
        }
        catch (Exception exception) {
            bl4 = (Boolean)pageContext.getValue("LockedOut");
            if (bl4 != null && bl4.booleanValue()) {
                bl2 = Boolean.FALSE;
                bl = Boolean.FALSE;
                this.theNote1Text = this.theLockoutText;
                this.theNote2Text = "";
                this.fromPage = FROM_LOCKOUT_PAGE;
            }
            this.fromPage = FROM_LOGIN_PAGE;
        }
        try {
            pageContext.getSession().setAttribute("showMsg", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.fromPage == null) {
            this.fromPage = FROM_LOGIN_PAGE;
        }
        this.thePage.addTitle(this.theProductText);
        Division division = new Division();
        division.setId("maindiv");
        if (string != null) {
            if (this.fromPage.equals(FROM_LOGIN_PAGE)) {
                this.createInUseBySection(pageContext, division);
                this.setFromPage(pageContext, FROM_IN_USE_PAGE);
            } else if (this.fromPage.equals(FROM_IN_USE_PAGE)) {
                this.theNote1Text = "";
                this.theNote2Text = "";
                division.add(this.createLoginSection(pageContext, Boolean.TRUE));
                this.setFromPage(pageContext, FROM_LOGIN_PAGE);
            }
        } else if (bl2) {
            if (this.fromPage.equals(FROM_LOGIN_PAGE)) {
                this.createAccountLockOutSection(pageContext, division);
                this.setFromPage(pageContext, FROM_LOCKOUT_PAGE);
                this.setAccountLockedMsgShown(pageContext, false);
            } else if (this.fromPage.equals(FROM_LOCKOUT_PAGE)) {
                division.add(this.createLoginSection(pageContext, bl));
                this.setFromPage(pageContext, FROM_LOGIN_PAGE);
                this.setAccountLockedMsgShown(pageContext, true);
            }
        } else {
            hTML = new ApcSectionHeader(this.theProductText, this.theLoginMsgText);
            ((ApcSectionHeader)hTML).setHelpId(ApcHelp.LOGIN_PASSWORD_RESET);
            division.add(hTML);
            if (bl3) {
                bl = Boolean.TRUE;
            }
            division.add(this.createLoginSection(pageContext, bl));
            this.setFromPage(pageContext, FROM_LOGIN_PAGE);
        }
        hTML = new NoScript();
        division.add(hTML);
        Division division2 = new Division(new Text(this.theNoJsText));
        ((Container)hTML).add(division2);
        division2.setCssClass("noscript-message");
        Division division3 = new Division(new Text(this.theNoCookiesText));
        division.add(division3);
        division3.setCssClass("noscript-message");
        division3.setId("noCookies");
        this.thePage.add(division);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((CharSequence)this.thePage.toHTML(pageContext));
        stringBuilder.trimToSize();
        return stringBuilder;
    }

    private void setAccountLockedMsgShown(PageContext pageContext, Boolean bl) {
        pageContext.setValue("LockedOut", bl);
        try {
            this.showMsg = bl != false ? Integer.valueOf(2) : null;
            pageContext.getSession().setAttribute("showMsg", (Object)this.showMsg);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setFromPage(PageContext pageContext, Integer n) {
        try {
            pageContext.getSession().setAttribute("fromPage", (Object)n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Boolean getIsInUse(PageContext pageContext) {
        Boolean bl = Boolean.FALSE;
        try {
            bl = (Boolean)pageContext.getSession().getAttribute("isInUse");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl == null) {
            bl = Boolean.FALSE;
        }
        return bl;
    }

    private ApcForm createLoginSection(PageContext pageContext, boolean bl) {
        ApcForm apcForm = new ApcForm("login", "/login");
        apcForm.setCssClass("formdiv");
        apcForm.setAttribute("autocomplete", "off");
        TextInput textInput = new TextInput("user");
        textInput.setId("user");
        textInput.setMaxLength("64");
        textInput.setSize("34");
        textInput.setValue("");
        textInput.setAutoComplete(false);
        apcForm.add(FormHelper.createLabelTextInputValueDiv(null, this.theUsernameText, textInput, null));
        Password password = new Password("pass");
        password.setId("pcnsmainpass");
        password.setMaxLength("128");
        password.setSize("34");
        password.setValue("");
        password.setAutoComplete(false);
        apcForm.add(FormHelper.createLabelTextInputValueDiv(null, this.thePasswordText, password, null));
        Division division = new Division();
        apcForm.add(division);
        division.setId("buttondiv");
        Input input = new Input();
        input.setName("apply");
        input.setValue(this.theLoginText);
        input.setId("apply");
        input.setType("submit");
        input.setClassName("newbutton");
        division.add(input);
        Input input2 = new Input();
        input2.setName("resetButton");
        input2.setValue(this.theResetButtonText);
        input2.setId("resetButton");
        input2.setType("reset");
        input2.setClassName("newbutton");
        division.add(input2);
        if (!bl) {
            Division division2 = new Division(new Text(this.theNote1Text + "<br/>" + this.theNote2Text));
            apcForm.add(division2);
            division2.setCssClass("notediv");
        }
        pageContext.addFormToken(apcForm);
        return apcForm;
    }

    private void createInUseBySection(PageContext pageContext, Division division) {
        division.add(this.buildErrorSection(pageContext, this.theInUseText));
    }

    private void createAccountLockOutSection(PageContext pageContext, Division division) {
        division.add(this.buildErrorSection(pageContext, this.theLockoutText));
    }

    private ApcForm buildErrorSection(PageContext pageContext, String string) {
        ApcForm apcForm = new ApcForm("loginForm", "/login");
        apcForm.setMethod("get");
        apcForm.setCssClass("formdiv");
        Division division = new Division(new Text(this.theProductText));
        division.setCssClass("notediv");
        apcForm.add(division);
        division = new Division(new Text(string));
        division.setCssClass("notediv");
        apcForm.add(division);
        Division division2 = new Division();
        apcForm.add(division2);
        Input input = new Input();
        input.setName("back");
        input.setValue(this.theBackButtonText);
        input.setType("submit");
        input.setClassName("newbutton");
        division2.add(input);
        pageContext.addFormToken(apcForm);
        return apcForm;
    }

    private void setupLanguage(Locale locale) {
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        this.theProductText = Utils.getResourceString(resourceBundleWrapper, kProductId);
        this.theUsernameText = Utils.getResourceString(resourceBundleWrapper, kUsernameId);
        this.thePasswordText = Utils.getResourceString(resourceBundleWrapper, kPasswordId);
        this.theLoginText = Utils.getResourceString(resourceBundleWrapper, kLoginId);
        this.theResetButtonText = Utils.getResourceString(resourceBundleWrapper, kResetButtonId);
        this.theBackButtonText = Utils.getResourceString(resourceBundleWrapper, kBackButtonId);
        this.theLoginMsgText = Utils.getResourceString(resourceBundleWrapper, kLoginMsgId);
        this.theNote1Text = Utils.getResourceString(resourceBundleWrapper, kNote1Id);
        this.theNote2Text = Utils.getResourceString(resourceBundleWrapper, kNote2Id);
        this.theLockoutText = Utils.getResourceString(resourceBundleWrapper, kLockoutId);
        this.theInUseText = Utils.getResourceString(resourceBundleWrapper, kInUseId);
        this.theNoJsText = Utils.getResourceString(resourceBundleWrapper, kNoJsId);
        this.theNoCookiesText = Utils.getResourceString(resourceBundleWrapper, kNoCookiesId);
    }
}

