/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.pages;

import com.apcc.m11.components.stdpowersource.OutletGroup;
import com.apcc.m11.components.webserver.html.Container;
import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.HTMLTagWithAlignClassStyle;
import com.apcc.m11.components.webserver.html.HTMLTagWithClassStyle;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.Text;
import com.apcc.m11.components.webserver.html.apc.ApcForm;
import com.apcc.m11.components.webserver.html.apc.ApcHelp;
import com.apcc.m11.components.webserver.html.apc.ApcPage;
import com.apcc.m11.components.webserver.html.apc.ApcSectionHeader;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.html.document.Span;
import com.apcc.m11.components.webserver.html.form.Form;
import com.apcc.m11.components.webserver.html.form.Input;
import com.apcc.m11.components.webserver.html.util.Anchor;
import com.apcc.m11.components.webserver.model.NMC;
import com.apcc.m11.components.webserver.pages.tables.IpOutletTable;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.m11.ds.powersource.Identification;
import com.apcc.m11.ds.powersource.communication.TCPIPCommunication;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.net.InetAddress;
import java.util.Locale;
import java.util.Vector;
import lombok.NonNull;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OmahaNMCDetailsPage
implements HTML {
    private static final Logger logger = LogManager.getLogger(OmahaNMCDetailsPage.class);
    public static final String VALUE_OUTLET_GROUP_LIST = "OutletGroupList";
    private static final char CTRL_A = '\u0001';
    private static final String kUPSUnknownModelId = "Menu.UPS.UnknownModel";
    private static final String kNMCHeader = "UPSConfiguration.NMCHeader";
    private static final String kNMCSubHeader = "UPSConfiguration.NMCSubHeader";
    private static final String kHostName = "UPSConfiguration.HostName";
    private static final String kIPAddress = "UPSConfiguration.IPAddress";
    private static final String kModelName = "UPSConfiguration.ModelName";
    private static final String kNMCInterface = "UPSConfiguration.NMCInterface";
    private static final String kLaunch = "UPSConfiguration.Launch";
    private static final String kUPSConfiguration = "UPSConfiguration.UPSConfiguration";
    private static final String kOutletHeader = "UPSConfiguration.OutletHeader";
    private static final String kOutletSubHeader = "UPSConfiguration.OutletSubHeader";
    private static final String kOutletRegError = "Configure.OutletRegistrationError";
    private static final String kOutletOffError = "Configure.OutletOffError";
    private static final String kApplyButton = "PCNS.ApplyButton";
    private static final String kResetButton = "PCNS.UndoButton";
    private static final String kWaitTitle = "PCNS.WaitTitle";
    private static final String kWaitText = "PCNS.WaitText";
    private static final String kCfgSingle = "CfgWizard.P04UpsLayoutPage.UpsConfigOption1";
    private static final String CfgRedundant = "CfgWizard.P04UpsLayoutPage.UpsConfigOption2";
    private static final String kCfgParallel = "CfgWizard.P04UpsLayoutPage.UpsConfigOption3";
    private static final String kCfgAdvanced = "CfgWizard.P04UpsLayoutPage.UpsConfigOption4";
    private static final String kUPSGroupName = "UPSConfiguration.UPSGroupName";
    private String theUPSUnknownModelText;
    private String theNMCHeaderText;
    private String theNMCSubHeaderText;
    private String theHostNameText;
    private String theIPAddressText;
    private String theModelNameText;
    private String theNMCInterfaceText;
    private String theLaunchText;
    private String theUpsConfigurationText;
    private String theUpsGroupNameText;
    private String theOutletHeaderText;
    private String theOutletSubHeaderText;
    private String theOutletRegErrorText;
    private String theOutletOffErrorText;
    private String theApplyButtonText;
    private String theResetButtonText;
    private String theWaitTitle;
    private String theWaitText;
    private String theCfgSingleText;
    private String theCfgRedundantText;
    private String theCfgParallelText;
    private String theCfgAdvancedText;
    private NMC nmc = null;
    private ServiceManager services;

    public OmahaNMCDetailsPage(@NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
    }

    @Override
    public StringBuilder toHTML(PageContext pageContext) {
        this.setupLanguage(pageContext.getLocale());
        this.nmc = (NMC)pageContext.getSession().getAttribute("nmc_data");
        pageContext.getSession().removeAttribute("nmc_data");
        ApcPage apcPage = new ApcPage(this.services);
        apcPage.addStyleSheet("styles/form.css");
        apcPage.addStyleSheet("styles/upsconfig.css");
        apcPage.addScript("scripts/navigation.js");
        apcPage.addScript("scripts/upsconfig.js");
        Division division = new Division();
        division.setCssClass("waitDialog");
        division.setId("waitDialog");
        division.setTitle(this.theWaitTitle);
        division.add(new Text(this.theWaitText));
        apcPage.add(division);
        this.displayNMCDetailsSection(pageContext, apcPage);
        this.displayOutletConfigSection(pageContext, apcPage);
        return apcPage.toHTML(pageContext);
    }

    private void displayNMCDetailsSection(PageContext pageContext, ApcPage apcPage) {
        HTMLTagWithClassStyle hTMLTagWithClassStyle;
        HTMLTagWithAlignClassStyle hTMLTagWithAlignClassStyle;
        Object object;
        Span span;
        Division division;
        String string = this.getModelName(pageContext, this.nmc);
        ApcSectionHeader apcSectionHeader = new ApcSectionHeader(this.theNMCHeaderText, this.theNMCSubHeaderText);
        apcSectionHeader.setHelpId(ApcHelp.NMC_SETTINGS);
        apcPage.add(apcSectionHeader);
        Division division2 = new Division();
        division2.setId("nmcdiv");
        division2.setCssClass("formdiv");
        apcPage.add(division2);
        if (this.nmc.getHostName() != null) {
            division = new Division();
            division.setCssClass("labelvaluediv");
            span = new Span(this.theHostNameText);
            span.setCssClass("label");
            division.add(span);
            span = new Span(this.nmc.getFqdn() != null ? this.nmc.getFqdn() : this.nmc.getHostName());
            span.setCssClass("value");
            division.add(span);
            division2.add(division);
        }
        division = new Division();
        division.setCssClass("labelvaluediv");
        span = new Span(this.theIPAddressText);
        span.setCssClass("label");
        division.add(span);
        span = new Span(this.nmc.getIPAddress());
        span.setCssClass("value");
        division.add(span);
        division2.add(division);
        Division division3 = new Division();
        division3.setCssClass("labelvaluediv");
        Span span2 = new Span(this.theModelNameText);
        span2.setCssClass("label");
        division3.add(span2);
        span2 = new Span(string);
        span2.setCssClass("value");
        division3.add(span2);
        division2.add(division3);
        String string2 = this.services.getVirtualConfigurationManager().getUPSConfigMode();
        if ("single".equals(string2)) {
            string2 = this.theCfgSingleText;
        } else if ("redundant".equals(string2)) {
            string2 = this.theCfgRedundantText;
        } else if ("parallel".equals(string2)) {
            string2 = this.theCfgParallelText;
        } else if ("advanced".equals(string2)) {
            string2 = this.theCfgAdvancedText;
        }
        Division division4 = new Division();
        division4.setCssClass("labelvaluediv");
        Span span3 = new Span(this.theUpsConfigurationText);
        span3.setCssClass("label");
        division4.add(span3);
        span3 = new Span(string2);
        span3.setCssClass("value");
        division4.add(span3);
        division2.add(division4);
        if ("advanced".equalsIgnoreCase(this.services.getVirtualConfigurationManager().getUPSConfigMode()) && (object = (String)pageContext.getValue("NMCGroupName")) != null && ((String)object).length() > 0) {
            hTMLTagWithAlignClassStyle = new Division();
            hTMLTagWithAlignClassStyle.setCssClass("labelvaluediv");
            hTMLTagWithClassStyle = new Span(this.theUpsGroupNameText);
            hTMLTagWithClassStyle.setCssClass("label");
            hTMLTagWithAlignClassStyle.add(hTMLTagWithClassStyle);
            hTMLTagWithClassStyle = new Span(StringEscapeUtils.escapeHtml4((String)object));
            hTMLTagWithClassStyle.setCssClass("value");
            hTMLTagWithAlignClassStyle.add(hTMLTagWithClassStyle);
            division2.add(hTMLTagWithAlignClassStyle);
        }
        object = new Division();
        ((HTMLTagWithClassStyle)object).setCssClass("labelvaluediv");
        hTMLTagWithAlignClassStyle = new Span(this.theNMCInterfaceText);
        hTMLTagWithAlignClassStyle.setCssClass("label");
        ((Container)object).add(hTMLTagWithAlignClassStyle);
        hTMLTagWithClassStyle = this.getNMCHref(pageContext);
        hTMLTagWithClassStyle.add(new Text(this.theLaunchText));
        hTMLTagWithClassStyle.setId("nmcbutton");
        hTMLTagWithClassStyle.setCssClass("newbutton");
        Span span4 = new Span();
        span4.add(hTMLTagWithClassStyle);
        span4.setCssClass("value");
        ((Container)object).add(span4);
        division2.add((HTML)object);
    }

    private void displayOutletConfigSection(PageContext pageContext, ApcPage apcPage) {
        if (pageContext.getValue(VALUE_OUTLET_GROUP_LIST) == null) {
            return;
        }
        ApcSectionHeader apcSectionHeader = new ApcSectionHeader(this.theOutletHeaderText, this.theOutletSubHeaderText);
        apcSectionHeader.setHelpId(ApcHelp.OUTLET_GROUP_REGISTRATION);
        apcPage.add(apcSectionHeader);
        this.displayOutletRegistrationError(pageContext, apcPage);
        ApcForm apcForm = new ApcForm("outletconfig", "/upsconfig");
        apcPage.add(apcForm);
        apcForm.add(new IpOutletTable(pageContext.getLocale()));
        apcForm.add(this.createButtonDiv("OutletConfig"));
        this.addIPHiddenInput(apcForm, this.nmc.getIPAddress());
        pageContext.addFormToken(apcForm);
    }

    private HTML createButtonDiv(String string) {
        Division division = new Division();
        division.setId("buttondiv");
        Input input = new Input();
        input.setName("apply");
        input.setValue(this.theApplyButtonText);
        input.setId("apply" + string);
        input.setType("submit");
        input.setClassName("newbutton");
        division.add(input);
        Input input2 = new Input();
        input2.setName("reset" + string);
        input2.setValue(this.theResetButtonText);
        input2.setId("reset" + string);
        input2.setType("reset");
        input2.setClassName("newbutton");
        division.add(input2);
        return division;
    }

    private void addIPHiddenInput(Form form, String string) {
        Input input = new Input();
        input.setName("nmcip");
        input.setValue(string);
        input.setType("hidden");
        form.add(input);
    }

    private void displayOutletRegistrationError(PageContext pageContext, ApcPage apcPage) {
        Division division = new Division();
        division.setId("outlet_reg_error");
        division.setCssClass("ui-state-error ui-corner-all");
        if (pageContext.hasValue("OutletRegistrationError")) {
            division.add(new Text(this.theOutletRegErrorText));
            apcPage.add(division);
        } else if (!this.isCurrentOutletOn(pageContext)) {
            division.add(new Text(this.theOutletOffErrorText));
            apcPage.add(division);
        }
    }

    private boolean isCurrentOutletOn(PageContext pageContext) {
        boolean bl = true;
        for (OutletGroup outletGroup : this.nmc.getOutletGroups()) {
            if (!outletGroup.isSelected() || outletGroup.getState() != 0) continue;
            return false;
        }
        return bl;
    }

    private Anchor getNMCHref(PageContext pageContext) {
        String string = this.nmc.getFqdn() != null ? this.nmc.getFqdn() : this.nmc.getIPAddress();
        Integer n = this.getPortNumber(pageContext);
        boolean bl = this.nmc.getFqdn() == null && this.nmc.getIPAddress().indexOf(":") >= 0;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getProtocol(pageContext));
        stringBuffer.append("://");
        if (bl) {
            stringBuffer.append("[");
        }
        stringBuffer.append(string);
        if (bl) {
            stringBuffer.append("]");
        }
        if (n != null) {
            stringBuffer.append(":");
            stringBuffer.append(n);
        }
        Anchor anchor = new Anchor();
        anchor.setHypertextReference(stringBuffer.toString());
        anchor.setTarget("_blank");
        return anchor;
    }

    private Integer getIPAddressIndex(PageContext pageContext, NMC nMC) {
        int n = 0;
        Vector<InetAddress> vector = Utils.getIPAddresses(pageContext);
        if (vector != null) {
            for (InetAddress inetAddress : vector) {
                if (nMC.getIPAddress().equals(inetAddress.getHostAddress())) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    private String getModelName(PageContext pageContext, NMC nMC) {
        String string = this.theUPSUnknownModelText;
        String string2 = this.services.getVirtualConfigurationManager().getUPSConfigMode();
        if ("single".equals(string2)) {
            string = (String)pageContext.get(Identification.ModelName.getObjectId());
            if (string == null) {
                string = this.theUPSUnknownModelText;
            }
        } else {
            int n = this.getIPAddressIndex(pageContext, nMC);
            Vector vector = (Vector)pageContext.get(Identification.ModelNameList.getObjectId());
            if (vector != null && n != -1 && vector.size() > n && ((string = vector.get(n).toString()) == null || string.equals("null"))) {
                string = this.theUPSUnknownModelText;
            }
        }
        string = string.replace('\u0001', ' ');
        return string;
    }

    private String getProtocol(PageContext pageContext) {
        String string = (String)pageContext.get(TCPIPCommunication.Protocol.getObjectId());
        if (string == null) {
            string = "http";
        }
        return string;
    }

    private Integer getPortNumber(PageContext pageContext) {
        Integer n = null;
        Object object = pageContext.get(TCPIPCommunication.DataRequestPort.getObjectId());
        if (object instanceof Vector) {
            if (((Vector)object).size() > 0) {
                n = (Integer)((Vector)object).elementAt(0);
            }
        } else {
            n = (Integer)object;
        }
        return n;
    }

    private void setupLanguage(Locale locale) {
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        this.theUPSUnknownModelText = Utils.getResourceString(resourceBundleWrapper, kUPSUnknownModelId);
        this.theNMCHeaderText = Utils.getResourceString(resourceBundleWrapper, kNMCHeader);
        this.theNMCSubHeaderText = Utils.getResourceString(resourceBundleWrapper, kNMCSubHeader);
        this.theHostNameText = Utils.getResourceString(resourceBundleWrapper, kHostName);
        this.theIPAddressText = Utils.getResourceString(resourceBundleWrapper, kIPAddress);
        this.theModelNameText = Utils.getResourceString(resourceBundleWrapper, kModelName);
        this.theNMCInterfaceText = Utils.getResourceString(resourceBundleWrapper, kNMCInterface);
        this.theLaunchText = Utils.getResourceString(resourceBundleWrapper, kLaunch);
        this.theUpsConfigurationText = Utils.getResourceString(resourceBundleWrapper, kUPSConfiguration);
        this.theOutletHeaderText = Utils.getResourceString(resourceBundleWrapper, kOutletHeader);
        this.theOutletSubHeaderText = Utils.getResourceString(resourceBundleWrapper, kOutletSubHeader);
        this.theOutletRegErrorText = Utils.getResourceString(resourceBundleWrapper, kOutletRegError);
        this.theOutletOffErrorText = Utils.getResourceString(resourceBundleWrapper, kOutletOffError);
        this.theApplyButtonText = Utils.getResourceString(resourceBundleWrapper, kApplyButton);
        this.theResetButtonText = Utils.getResourceString(resourceBundleWrapper, kResetButton);
        this.theWaitTitle = Utils.getResourceString(resourceBundleWrapper, kWaitTitle);
        this.theWaitText = Utils.getResourceString(resourceBundleWrapper, kWaitText);
        this.theUpsGroupNameText = Utils.getResourceString(resourceBundleWrapper, kUPSGroupName);
        this.theCfgSingleText = Utils.getResourceString(resourceBundleWrapper, kCfgSingle);
        this.theCfgRedundantText = Utils.getResourceString(resourceBundleWrapper, CfgRedundant);
        this.theCfgParallelText = Utils.getResourceString(resourceBundleWrapper, kCfgParallel);
        this.theCfgAdvancedText = Utils.getResourceString(resourceBundleWrapper, kCfgAdvanced);
    }
}

