/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.pages;

import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.HTMLDebug;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.Text;
import com.apcc.m11.components.webserver.html.apc.ApcForm;
import com.apcc.m11.components.webserver.html.apc.ApcPage;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.html.document.Span;
import com.apcc.m11.components.webserver.html.form.Input;
import com.apcc.m11.components.webserver.util.NutanixHTMLHelper;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.util.Locale;
import lombok.NonNull;

public class OmahaNutanixSettingsPage
implements HTML {
    private static final String kApplyButton = "PCNS.ApplyButton";
    private static final String kResetButton = "PCNS.UndoButton";
    private static final String kWaitTitle = "PCNS.WaitTitle";
    private static final String kWaitText = "PCNS.WaitText";
    private static final String kRequiredField = "PCNS.RequiredField";
    private static final String kRangeLength = "PCNS.RangeLength";
    private static final String kServerValidation = "PCNS.VcenterServerValidation";
    private static final String kInvalidCharactersId = "PCNS.InvalidCharacters";
    private static final String kSshPassphrasesDoNotMatchId = "Configure.SshPassphrasesDoNotMatch";
    private static final String kOKButton = "PCNS.OKButton";
    private static final String kCancelButton = "PCNS.CancelButton";
    private static final String kPasswordsDoNotMatchId = "Configure.PasswordsDoNotMatch";
    private static final String kSSHKeyNotFoundWarning = "SSHSettings.Action.InvalidSSHKeyFile";
    public static final String kClusterPasswordsWillBeDeletedWarning = "NutanixSettings.ClusterPasswordWillBeDeletedWarning";
    public static final String kSshKeyPathAndPassphraseWillBeDeletedWarning = "NutanixSettings.SshKeyPathAndPassphraseWillBeDeletedWarning";
    private String theApplyButtonText;
    private String theResetButtonText;
    private String theWaitTitle;
    private String theWaitText;
    private String theRequiredFieldValidationText;
    private String theRangeLengthValidationText;
    private String theServerValidationText;
    private String theInvalidCharactersText;
    private String theSshPassphrasesDoNotMatchText;
    private String theOKButtonText;
    private String theCancelButtonText;
    private String thePasswordsDoNotMatchText;
    private String theSSHKeyNotFoundText;
    private ApcPage thePage;
    private ApcForm theForm = new ApcForm("nutanixsettings", "/NutanixSettings");
    private ServiceManager services;

    public OmahaNutanixSettingsPage(@NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
        this.thePage = new ApcPage(serviceManager);
    }

    @Override
    public StringBuilder toHTML(PageContext pageContext) {
        this.setupLanguage(pageContext.getLocale());
        this.thePage.addStyleSheet("styles/form.css");
        this.thePage.addStyleSheet("styles/setupcomms.css");
        this.thePage.addScript("scripts/jquery.validate.min.js");
        this.thePage.addScript("scripts/nutanixsettings.js");
        this.thePage.addScript("scripts/setupcommsutils.js");
        this.thePage.add(this.theForm);
        this.theForm.setId("nutanixsettingsform");
        Division division = new Division();
        division.setCssClass("waitDialog");
        division.setTitle(this.theWaitTitle);
        division.setId("waitDialog");
        division.add(new Text(this.theWaitText));
        this.thePage.add(division);
        NutanixHTMLHelper nutanixHTMLHelper = new NutanixHTMLHelper(pageContext.getLocale(), this.services);
        this.theForm.add(nutanixHTMLHelper.createNutanixConnectionSectionHeader());
        this.theForm.add(nutanixHTMLHelper.createNutanixConnectionHTML(pageContext, false));
        nutanixHTMLHelper.addHiddenNutanixAuthDivsToPage(this.thePage);
        nutanixHTMLHelper.createNutanixMessages(this.theForm);
        this.theForm.add(this.createButtonDiv());
        pageContext.addFormToken(this.theForm);
        this.thePage.add(this.createResourceStrings());
        StringBuilder stringBuilder = new StringBuilder();
        HTMLDebug.htmlComment(stringBuilder, "Begin OmahaNutanixSettingsPage");
        stringBuilder.append((CharSequence)this.thePage.toHTML(pageContext));
        HTMLDebug.htmlComment(stringBuilder, "End OmahaNutanixSettingsPage");
        stringBuilder.trimToSize();
        return stringBuilder;
    }

    private void setupLanguage(Locale locale) {
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        this.theApplyButtonText = Utils.getResourceString(resourceBundleWrapper, kApplyButton);
        this.theResetButtonText = Utils.getResourceString(resourceBundleWrapper, kResetButton);
        this.theWaitTitle = Utils.getResourceString(resourceBundleWrapper, kWaitTitle);
        this.theWaitText = Utils.getResourceString(resourceBundleWrapper, kWaitText);
        this.theRequiredFieldValidationText = Utils.getResourceString(resourceBundleWrapper, kRequiredField);
        this.theRangeLengthValidationText = Utils.getResourceString(resourceBundleWrapper, kRangeLength);
        this.theServerValidationText = Utils.getResourceString(resourceBundleWrapper, kServerValidation);
        this.theInvalidCharactersText = Utils.getResourceString(resourceBundleWrapper, kInvalidCharactersId);
        this.theSshPassphrasesDoNotMatchText = Utils.getResourceString(resourceBundleWrapper, kSshPassphrasesDoNotMatchId);
        this.theOKButtonText = Utils.getResourceString(resourceBundleWrapper, kOKButton);
        this.theCancelButtonText = Utils.getResourceString(resourceBundleWrapper, kCancelButton);
        this.thePasswordsDoNotMatchText = Utils.getResourceString(resourceBundleWrapper, kPasswordsDoNotMatchId);
        this.theSSHKeyNotFoundText = Utils.getResourceString(resourceBundleWrapper, kSSHKeyNotFoundWarning);
    }

    private HTML createButtonDiv() {
        Division division = new Division();
        division.setId("buttondiv");
        Input input = new Input();
        input.setName("apply");
        input.setValue(this.theApplyButtonText);
        input.setId("apply");
        input.setType("submit");
        input.setClassName("newbutton");
        division.add(input);
        Input input2 = new Input();
        input2.setName("resetButton");
        input2.setValue(this.theResetButtonText);
        input2.setId("resetButton");
        input2.setType("reset");
        input2.setClassName("newbutton");
        division.add(input2);
        return division;
    }

    private Division createResourceStrings() {
        Division division = new Division();
        division.setId("jsres");
        Span span = new Span(this.theRequiredFieldValidationText);
        span.setId("resRequiredFieldValidation");
        division.add(span);
        span = new Span(this.theRangeLengthValidationText);
        span.setId("resRangeLengthValidation");
        division.add(span);
        span = new Span(this.theServerValidationText);
        span.setId("resValidServerValidation");
        division.add(span);
        span = new Span(this.theInvalidCharactersText);
        span.setId("resInvalidCharacters");
        division.add(span);
        span = new Span(this.theSSHKeyNotFoundText);
        span.setId("resSSHKeyNotFound");
        division.add(span);
        span = new Span("nutanix_cluster_password");
        span.setId("resVMPasswordName");
        division.add(span);
        span = new Span("nutanix_ssh_key_passphrase");
        span.setId("resVMSshPassphraseName");
        division.add(span);
        span = new Span(this.theSshPassphrasesDoNotMatchText);
        span.setId("resPassphrasesDoNotMatch");
        division.add(span);
        span = new Span("NutanixAHVAuthenticationKeySshKeyName");
        span.setId("resVMSshKeyPathName");
        division.add(span);
        span = new Span(this.theOKButtonText);
        span.setId("resOKButton");
        division.add(span);
        span = new Span(this.theCancelButtonText);
        span.setId("resCancelButton");
        division.add(span);
        span = new Span(this.thePasswordsDoNotMatchText);
        span.setId("resPasswordsDoNotMatch");
        division.add(span);
        return division;
    }
}

