/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.pages;

import com.apcc.m11.components.webserver.html.Container;
import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.HTMLTagWithAlignClassStyle;
import com.apcc.m11.components.webserver.html.HTMLTagWithClassStyle;
import com.apcc.m11.components.webserver.html.HTMLwithId;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.Text;
import com.apcc.m11.components.webserver.html.apc.ApcForm;
import com.apcc.m11.components.webserver.html.apc.ApcHelp;
import com.apcc.m11.components.webserver.html.apc.ApcPage;
import com.apcc.m11.components.webserver.html.apc.ApcSectionHeader;
import com.apcc.m11.components.webserver.html.apc.ApcSectionLabel;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.html.document.Span;
import com.apcc.m11.components.webserver.html.form.Button;
import com.apcc.m11.components.webserver.html.form.Input;
import com.apcc.m11.components.webserver.html.layout.Paragraph;
import com.apcc.m11.components.webserver.html.table.Table;
import com.apcc.m11.components.webserver.html.table.TableHeader;
import com.apcc.m11.components.webserver.html.table.TableRow;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.AuthHelper;
import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.util.Locale;
import lombok.NonNull;

public class OmahaOverviewPage
implements HTML {
    private ApcPage thePage;
    private static final String HEADER_ID = "Overview.Header";
    private static final String kDateHeaderId = "EventLog.DateHeader";
    private static final String kTimeHeaderId = "EventLog.TimeHeader";
    private static final String kEventHeaderId = "EventLog.EventHeader";
    private static final String kNoLoggedEventsId = "EventLog.NoLoggedEvents";
    private static final String OVERVIEW_EVENT_LOG_ID = "Overview.EventLogPanel.Header";
    private static final String SOFTWARE_UPDATE_PANEL_HEADER = "Overview.SoftwareUpdatePanel.Header";
    private static final String SOFTWARE_UPDATE_PANEL_TEXT = "Overview.SoftwareUpdatePanel.Text";
    private static final String SOFTWARE_UPDATE_PANEL_BUTTON_TEXT = "Overview.SoftwareUpdatePanelButton.Text";
    private static final String COMMUNICATION_PANEL_ID = "Overview.CommunicationPanel.Header";
    private static final String COMMUNICATION_PANEL_CHECK_STATUS_WAIT = "Overview.CommunicationPanel.CheckStatusWait";
    private static final String COMMUNICATION_PANEL_CHECK_STATUS_SUCCESS = "Overview.CommunicationPanel.CheckSuccess";
    private static final String COMMUNICATION_PANEL_CHECK_STATUS_FAILURE = "Overview.CommunicationPanel.CheckFailure";
    private String theHeaderText;
    private String theDateHeaderText;
    private String theTimeHeaderText;
    private String theEventHeaderText;
    private String theNoLoggedEventsText;
    private String theEventLogHeaderText;
    private String theSoftwareUpdatePanelHeaderText;
    private String theSoftwareUpdatePanelText;
    private String theSoftwareUpdatePanelButtonText;
    private String theCommunicationPanelHeaderText;
    private String theCommunicationPanelStatusWaitText;
    private String theCommunicationPanelStatusSuccessText;
    private String theCommunicationPanelStatusFailureText;
    private ServiceManager services;

    public OmahaOverviewPage(@NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.thePage = new ApcPage(serviceManager);
        this.services = serviceManager;
    }

    @Override
    public StringBuilder toHTML(PageContext pageContext) {
        HTMLwithId hTMLwithId;
        HTML hTML;
        HTMLTagWithClassStyle hTMLTagWithClassStyle;
        Object object;
        HTML hTML2;
        HTMLTagWithAlignClassStyle hTMLTagWithAlignClassStyle;
        this.thePage.addStyleSheet("styles/common.css");
        this.thePage.addScript("scripts/datatables.min.js");
        this.thePage.addStyleSheet("styles/datatables.min.css");
        this.thePage.addScript("scripts/AJAXLogOverviewPanel.js");
        this.thePage.addScript("scripts/overviewredirects.js");
        this.thePage.addStyleSheet("styles/eventlog.css");
        this.thePage.addStyleSheet("styles/overview.css");
        this.thePage.addScript("scripts/overviewcheckcomms.js");
        this.setupLanguage(pageContext.getLocale());
        ApcSectionHeader apcSectionHeader = new ApcSectionHeader(this.theHeaderText, null);
        apcSectionHeader.setHelpId(ApcHelp.OVERVIEW_PAGE);
        this.thePage.add(apcSectionHeader);
        Division division = new Division();
        division.setId("eventLogPanelHeader");
        Text text = new Text(this.theEventLogHeaderText);
        division.add(text);
        this.thePage.add(division);
        Division division2 = new Division();
        division2.setId("eventLogContainer");
        ApcForm apcForm = new ApcForm("eventlogform", "/index.html");
        this.thePage.add(apcForm);
        pageContext.addFormToken(apcForm);
        Division division3 = new Division();
        Table table = new Table(true);
        table.setId("EventLog");
        table.setCssClass("EventLog_Table");
        table.setCssClass("cell-border");
        TableRow tableRow = new TableRow();
        tableRow.setCssClass("Event_Header");
        TableHeader tableHeader = new TableHeader(new ApcSectionLabel(this.theDateHeaderText));
        tableHeader.setCssClass("Table_Table");
        TableHeader tableHeader2 = new TableHeader(new ApcSectionLabel(this.theTimeHeaderText));
        tableHeader2.setCssClass("Table_Table");
        TableHeader tableHeader3 = new TableHeader(new ApcSectionLabel(this.theEventHeaderText));
        tableHeader3.setCssClass("Table_Table");
        tableRow.add(tableHeader);
        tableRow.add(tableHeader2);
        tableRow.add(tableHeader3);
        division3.add(tableRow);
        table.addHeaderRow(division3);
        division2.add(table);
        this.thePage.add(division2);
        Division division4 = new Division();
        division4.setId("resNoEventsLogged");
        division4.add(new Text(this.theNoLoggedEventsText));
        Division division5 = new Division();
        division5.add(division4);
        division5.setCssClass("hidden");
        this.thePage.add(division5);
        ConfigurationManager configurationManager = ServiceManager.getInstance().getConfigurationManager();
        if (!this.services.getWebServerUtils().isJapanese() && configurationManager.getBoolean("SoftwareUpdate", "enableUpdateCheck", true).booleanValue()) {
            hTMLTagWithAlignClassStyle = new Division();
            hTMLTagWithAlignClassStyle.setId("softwareUpdatePanel");
            hTML2 = new ApcSectionHeader(this.theSoftwareUpdatePanelHeaderText, null);
            ((ApcSectionHeader)hTML2).setHelpId(ApcHelp.OVERVIEW_PAGE);
            ((ApcSectionHeader)hTML2).setTrafficLight(true);
            hTMLTagWithAlignClassStyle.add(hTML2);
            object = ServiceManager.getInstance().getAuthHelper();
            hTMLTagWithClassStyle = new Paragraph(new Text(((AuthHelper)object).getSoftwareUpdateResponseText()));
            hTMLTagWithAlignClassStyle.add(hTMLTagWithClassStyle);
            hTML = new Division();
            ((HTMLTagWithClassStyle)hTML).setId("goToSoftwareUpdatePageDiv");
            hTMLwithId = new Button();
            ((Input)hTMLwithId).setId("goToSoftwareUpdatePageButton");
            ((Input)hTMLwithId).setValue(this.theSoftwareUpdatePanelButtonText);
            ((Container)hTML).add(hTMLwithId);
            hTMLTagWithAlignClassStyle.add(hTMLwithId);
            this.thePage.add(hTMLTagWithAlignClassStyle);
        }
        hTMLTagWithAlignClassStyle = new Span(this.theCommunicationPanelStatusSuccessText);
        hTML2 = new Span(this.theCommunicationPanelStatusFailureText);
        ((HTMLTagWithClassStyle)hTML2).setCssClass("hidden");
        ((HTMLTagWithClassStyle)hTML2).setId("commFailureText");
        hTMLTagWithAlignClassStyle.setCssClass("hidden");
        hTMLTagWithAlignClassStyle.setId("commSuccessText");
        object = new Division();
        ((HTMLTagWithClassStyle)object).setId("communicationPanelContainer");
        ((Container)object).add(hTML2);
        ((Container)object).add(hTMLTagWithAlignClassStyle);
        hTMLTagWithClassStyle = new Division();
        hTMLTagWithClassStyle.setId("communicationPanelHeader");
        hTML = new ApcSectionHeader(this.theCommunicationPanelHeaderText, null);
        hTMLTagWithClassStyle.add(hTML);
        ((Container)object).add(hTMLTagWithClassStyle);
        hTMLwithId = new Division();
        ((HTMLTagWithClassStyle)hTMLwithId).setId("communicationPanelCheckDiv");
        Span span = new Span(this.theCommunicationPanelStatusWaitText);
        span.setId("communicationPanelStatusCheck");
        ((Container)((Object)hTMLwithId)).add(span);
        ((Container)object).add(hTMLwithId);
        Division division6 = new Division();
        division6.setId("systemTypeDivision");
        Span span2 = new Span();
        division6.add(span2);
        Span span3 = new Span();
        span3.setId("commDeviceType");
        division6.add(span3);
        division6.setCssClass("hidden");
        this.thePage.add(division6);
        if (this.services.getVirtualConfigurationManager().isHyperV()) {
            span3.setText("hyperVTag");
        } else if (this.services.getVirtualConfigurationManager().isVxRail()) {
            span3.setText("vxRailTag");
        } else if (this.services.getVirtualConfigurationManager().isESXi()) {
            span3.setText("esxiTag");
        } else if (this.services.getVirtualConfigurationManager().isHyperflex()) {
            span3.setText("hyperflexTag");
        } else if (this.services.getVirtualConfigurationManager().isVCSA()) {
            span3.setText("vCenterTag");
        } else if (this.services.getVirtualConfigurationManager().isSimplivity()) {
            span3.setText("simplivityTag");
        } else if (this.services.getVirtualConfigurationManager().isNutanixESXi()) {
            span3.setText("nutanixTag");
        }
        this.thePage.add((HTML)object);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((CharSequence)this.thePage.toHTML(pageContext));
        stringBuilder.trimToSize();
        return stringBuilder;
    }

    private void setupLanguage(Locale locale) {
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        this.theHeaderText = Utils.getResourceString(resourceBundleWrapper, HEADER_ID);
        this.theDateHeaderText = Utils.getResourceString(resourceBundleWrapper, kDateHeaderId);
        this.theTimeHeaderText = Utils.getResourceString(resourceBundleWrapper, kTimeHeaderId);
        this.theEventHeaderText = Utils.getResourceString(resourceBundleWrapper, kEventHeaderId);
        this.theNoLoggedEventsText = Utils.getResourceString(resourceBundleWrapper, kNoLoggedEventsId);
        this.theEventLogHeaderText = Utils.getResourceString(resourceBundleWrapper, OVERVIEW_EVENT_LOG_ID);
        this.theSoftwareUpdatePanelHeaderText = Utils.getResourceString(resourceBundleWrapper, SOFTWARE_UPDATE_PANEL_HEADER);
        this.theSoftwareUpdatePanelText = Utils.getResourceString(resourceBundleWrapper, SOFTWARE_UPDATE_PANEL_TEXT);
        this.theSoftwareUpdatePanelButtonText = Utils.getResourceString(resourceBundleWrapper, SOFTWARE_UPDATE_PANEL_BUTTON_TEXT);
        this.theCommunicationPanelHeaderText = Utils.getResourceString(resourceBundleWrapper, COMMUNICATION_PANEL_ID);
        this.theCommunicationPanelStatusWaitText = Utils.getResourceString(resourceBundleWrapper, COMMUNICATION_PANEL_CHECK_STATUS_WAIT);
        this.theCommunicationPanelStatusFailureText = Utils.getResourceString(resourceBundleWrapper, COMMUNICATION_PANEL_CHECK_STATUS_FAILURE);
        this.theCommunicationPanelStatusSuccessText = Utils.getResourceString(resourceBundleWrapper, COMMUNICATION_PANEL_CHECK_STATUS_SUCCESS);
    }
}

