/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.pages;

import com.apcc.m11.arch.FormatterException;
import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.UnsupportedLocaleException;
import com.apcc.m11.components.webserver.html.Container;
import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.HTMLDebug;
import com.apcc.m11.components.webserver.html.I18n;
import com.apcc.m11.components.webserver.html.NonBlankSpace;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.Text;
import com.apcc.m11.components.webserver.html.apc.ApcForm;
import com.apcc.m11.components.webserver.html.apc.ApcPage;
import com.apcc.m11.components.webserver.html.apc.ApcSectionHeader;
import com.apcc.m11.components.webserver.html.form.Button;
import com.apcc.m11.components.webserver.html.form.Input;
import com.apcc.m11.components.webserver.html.form.Option;
import com.apcc.m11.components.webserver.html.form.Select;
import com.apcc.m11.components.webserver.html.layout.Break;
import com.apcc.m11.components.webserver.html.table.Table;
import com.apcc.m11.components.webserver.html.table.TableData;
import com.apcc.m11.components.webserver.html.table.TableRow;
import com.apcc.m11.components.webserver.pages.actions.Action;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.m11.ds.services.omaha.IFlexEventActionDescriptor;
import com.apcc.m11.ds.services.omaha.IFlexEventDescriptor;
import com.apcc.m11.ds.services.omaha.Omaha;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OmahaSingleSelectEventPage
implements HTML,
I18n {
    private static final Logger logger = LogManager.getLogger(OmahaSingleSelectEventPage.class);
    public static final String kEvent = "Event";
    private ApcPage thePage;
    private Vector<Object> theActionsHTML = new Vector();
    private Hashtable<?, ?> theEvents = null;
    private String theSelectedEvent = null;
    private static final String kHeaderId = "SingleSelectEvent.Header";
    private static final String kSubHeaderId = "SingleSelectEvent.SubHeader";
    private String theHeaderText;
    private String theSubHeaderText;

    public OmahaSingleSelectEventPage(@NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.thePage = new ApcPage(serviceManager);
    }

    public void setup(PageContext pageContext) {
        this.changeLanguage(pageContext.getLocale());
        this.theSelectedEvent = pageContext.getPostQueryValue(kEvent);
        Vector vector = (Vector)pageContext.get(Omaha.FlexEventList.getObjectId());
        Vector vector2 = (Vector)pageContext.get(Omaha.FlexEventActionList.getObjectId());
        if (vector != null) {
            this.setupEvents(vector, pageContext);
            if (vector2 != null) {
                IFlexEventDescriptor iFlexEventDescriptor = null;
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    iFlexEventDescriptor = (IFlexEventDescriptor)enumeration.nextElement();
                    if (!iFlexEventDescriptor.getHMTLId().equals(this.theSelectedEvent)) continue;
                    this.setupActions(iFlexEventDescriptor, vector2, pageContext);
                }
            } else {
                logger.info("The event group enumeration is null.");
                logger.info("The event grouping list is invalid: cannot create display list");
            }
        } else {
            logger.info("The event enumeration is null");
            logger.info("The event list is invalid: cannot create display list");
        }
    }

    @Override
    public StringBuilder toHTML(PageContext pageContext) {
        this.setup(pageContext);
        StringBuilder stringBuilder = new StringBuilder();
        HTMLDebug.htmlComment(stringBuilder, "Begin OmahaSingleSelectPage");
        stringBuilder.append((CharSequence)this.thePage.toHTML(pageContext));
        HTMLDebug.htmlComment(stringBuilder, "End OmahaSingleSelectPage");
        stringBuilder.trimToSize();
        return stringBuilder;
    }

    public IFlexEventDescriptor getSelectedEvent() {
        IFlexEventDescriptor iFlexEventDescriptor = null;
        if (this.theEvents != null && this.theSelectedEvent != null) {
            iFlexEventDescriptor = (IFlexEventDescriptor)this.theEvents.get(this.theSelectedEvent);
        }
        return iFlexEventDescriptor;
    }

    public void setupActions(IFlexEventDescriptor iFlexEventDescriptor, Vector<IFlexEventActionDescriptor> vector, PageContext pageContext) {
        try {
            iFlexEventDescriptor.getNameFormatter().format((Object)iFlexEventDescriptor, pageContext.getLocale());
            String string = iFlexEventDescriptor.getDescriptionFormatter().format((Object)iFlexEventDescriptor, pageContext.getLocale());
            Table table = new Table();
            table.add(new TableRow(new TableData(new Text(string))));
            this.thePage.add(table);
            this.thePage.add(new Break());
        }
        catch (FormatterException formatterException) {
            logger.info((Object)formatterException);
        }
        catch (UnsupportedLocaleException unsupportedLocaleException) {
            logger.info((Object)unsupportedLocaleException);
        }
        int n = vector.size();
        for (int i = n - 1; i >= 0; --i) {
            IFlexEventActionDescriptor iFlexEventActionDescriptor = vector.elementAt(i);
            try {
                this.thePage.add(new ApcSectionHeader(iFlexEventActionDescriptor.getNameFormatter().format((Object)iFlexEventActionDescriptor, pageContext.getLocale())));
                if (iFlexEventDescriptor.isFlexEventActionAllowed(iFlexEventActionDescriptor.getObjectId())) {
                    String string = iFlexEventActionDescriptor.getActionClassname();
                    if (string.equals("com.apcc.m11.components.http.html.apc.omaha.event.ShutdownAction")) {
                        string = "com.apcc.m11.components.http.omaha.action.ShutdownAction";
                    } else if (string.equals("com.apcc.m11.components.http.html.apc.omaha.event.NotifyUsersAction")) {
                        string = "com.apcc.m11.components.http.omaha.action.NotifyUsersAction";
                    } else if (string.equals("com.apcc.m11.components.http.html.apc.omaha.event.LogEventAction")) {
                        string = "com.apcc.m11.components.http.omaha.action.LogEventAction";
                    } else if (string.equals("com.apcc.m11.components.http.html.apc.omaha.event.RunCommandFileAction")) {
                        string = "com.apcc.m11.components.http.omaha.action.RunCommandFileAction";
                    }
                    Class<?> clazz = Class.forName(string);
                    Object obj = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    if (!(obj instanceof Action)) continue;
                    Action action = (Action)obj;
                    action.setEvent(iFlexEventDescriptor);
                    action.refresh(pageContext);
                    this.thePage.add(action);
                    this.theActionsHTML.addElement(action);
                    continue;
                }
                this.thePage.add(new Text("This action is not supported by this event."));
                continue;
            }
            catch (Exception exception) {
                logger.error("Error creating the action class", (Throwable)exception);
            }
        }
    }

    public Vector<Object> getActions() {
        return (Vector)this.theActionsHTML.clone();
    }

    public void refreshActions(PageContext pageContext) {
        for (int i = 0; i < this.theActionsHTML.size(); ++i) {
            Action action = (Action)this.theActionsHTML.elementAt(i);
            action.refresh(pageContext);
        }
    }

    public void setupEvents(Vector<IFlexEventDescriptor> vector, PageContext pageContext) {
        Object object;
        HTML hTML;
        Select select = new Select(kEvent);
        this.thePage.addSection(this.theHeaderText, this.theSubHeaderText);
        Enumeration<IFlexEventDescriptor> enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string;
            IFlexEventDescriptor iFlexEventDescriptor = enumeration.nextElement();
            IFormatter iFormatter = iFlexEventDescriptor.getNameFormatter();
            try {
                string = iFormatter.format((Object)iFlexEventDescriptor, pageContext.getLocale());
            }
            catch (Exception exception) {
                string = "Bad_Event_Name_Formater";
            }
            hTML = new Option();
            ((Option)hTML).setValue(iFlexEventDescriptor.getHMTLId());
            ((Option)hTML).setDisplayText(string);
            object = pageContext.getPostQueryValue(kEvent);
            if (iFlexEventDescriptor.getHMTLId().equals(object)) {
                ((Option)hTML).setSelected(true);
            }
            select.add(hTML);
        }
        hTML = new ApcForm(kEvent, "/sse");
        object = new Button();
        ((Input)object).setType("Submit");
        ((Input)object).setValue("Configure");
        ((Container)hTML).add(select);
        ((Container)hTML).add(new NonBlankSpace());
        ((Container)hTML).add((HTML)object);
        this.thePage.add(hTML);
    }

    @Override
    public void changeLanguage(Locale locale) {
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        this.theHeaderText = "Event Configuration";
        this.theSubHeaderText = "Select an event then click Configure";
    }
}

