/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.pages;

import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.apc.ApcHelp;
import com.apcc.m11.components.webserver.html.apc.ApcPage;
import com.apcc.m11.components.webserver.html.apc.ApcSectionHeader;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.html.form.Form;
import com.apcc.m11.components.webserver.util.HostSelectionHTMLHelper;
import com.apcc.m11.components.webserver.util.SimplivityHTMLHelper;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.util.Locale;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OmahaTargetHostSelectionPage
implements HTML {
    private static final Logger logger = LogManager.getLogger(OmahaTargetHostSelectionPage.class);
    private static final String kHeader = "TargetHostSelection.Header";
    private static final String kSubHeader = "TargetHostSelection.SubHeader";
    private String theHeaderText;
    private String theSubHeaderText;
    private ServiceManager services;

    public OmahaTargetHostSelectionPage(@NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
    }

    @Override
    public StringBuilder toHTML(PageContext pageContext) {
        this.setupLanguage(pageContext.getLocale());
        ApcPage apcPage = new ApcPage(this.services);
        ApcSectionHeader apcSectionHeader = new ApcSectionHeader(this.theHeaderText, this.theSubHeaderText);
        if (this.services.getVirtualConfigurationManager().isESXi()) {
            apcSectionHeader.setHelpId(ApcHelp.VMWARE_HOST_PROTECTION);
        } else if (this.services.getVirtualConfigurationManager().isHyperV()) {
            apcSectionHeader.setHelpId(ApcHelp.SCVMM_HOST_PROTECTION);
        } else if (this.services.getVirtualConfigurationManager().isNutanixAHV()) {
            apcSectionHeader.setHelpId(ApcHelp.HOST_PROTECTION_AHV);
        } else {
            apcSectionHeader.setHelpId(ApcHelp.INTRODUCTION1);
        }
        apcPage.add(apcSectionHeader);
        Form form = new Form();
        form.setMethod("post");
        form.setId("targetHostMappingForm");
        form.setAction("/targethostselection");
        apcPage.add(form);
        apcPage.addStyleSheet("jstree/themes/default/style.min.css");
        apcPage.addStyleSheet("styles/hostmap.css");
        apcPage.addScript("jstree/jstree.min.js");
        apcPage.addScript("scripts/content.js");
        apcPage.addScript("scripts/navigation.js");
        apcPage.addScript("scripts/inventory.js");
        apcPage.addScript("scripts/targethost.js");
        Division division = new Division();
        division.setId("hostListsContainer");
        HostSelectionHTMLHelper hostSelectionHTMLHelper = new HostSelectionHTMLHelper(pageContext.getLocale(), true, false, this.services);
        hostSelectionHTMLHelper.createConnectionWaitHTML(division);
        pageContext.addFormToken(form);
        form.add(division);
        Division division2 = new Division();
        division2.setId("res");
        division2.setAttribute("data-ismainui", String.valueOf(true));
        division.add(division2);
        if (this.services.getVirtualConfigurationManager().isSimplivity()) {
            SimplivityHTMLHelper simplivityHTMLHelper = new SimplivityHTMLHelper(pageContext.getLocale(), this.services);
            HTML hTML = simplivityHTMLHelper.createSimplivityConnectionHTML(pageContext, false, true);
            form.add(hTML);
            division2 = new Division();
            division2.setId("isSimplivity");
            division2.setCssClass("hidden");
            apcPage.add(division2);
        }
        return apcPage.toHTML(pageContext);
    }

    private void setupLanguage(Locale locale) {
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        this.theHeaderText = Utils.getResourceString(resourceBundleWrapper, kHeader);
        this.theSubHeaderText = Utils.getResourceString(resourceBundleWrapper, kSubHeader);
    }
}

