/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.pages;

import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.HTMLDebug;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.Text;
import com.apcc.m11.components.webserver.html.apc.ApcForm;
import com.apcc.m11.components.webserver.html.apc.ApcHelp;
import com.apcc.m11.components.webserver.html.apc.ApcPage;
import com.apcc.m11.components.webserver.html.apc.ApcSection;
import com.apcc.m11.components.webserver.html.apc.ApcSectionHeader;
import com.apcc.m11.components.webserver.html.apc.ApcSectionLabel;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.html.form.Checkbox;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.m11.ds.services.softwareupdate.SoftwareUpdateGroup;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.util.Locale;
import java.util.NoSuchElementException;
import lombok.NonNull;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OmahaUpdatesPage
implements HTML {
    private static final Logger logger = LogManager.getLogger(OmahaUpdatesPage.class);
    private static final String kIdPrefix = "Updates.";
    private static final String kEnableUpdatesHeaderId = "Updates.EnableUpdatesHeader";
    private static final String kEnableUpdatesSubHeaderId = "Updates.EnableUpdatesSubHeader";
    private static final String kEnableUpdatesLabelId = "Updates.EnableUpdatesLabel";
    private static final String kEnableUpdateTrapLabelId = "Updates.EnableUpdateTrapLabel";
    private static final String kCheckUpdatesWaitTitle = "Updates.WaitTitle";
    private static final String kCheckUpdatesWaitText = "Updates.WaitText";
    private static final String kWaitTitle = "PCNS.WaitTitle";
    private static final String kWaitText = "PCNS.WaitText";
    private String theEnableUpdatesHeaderText;
    private String theEnableUpdatesSubHeaderText;
    private String theEnableUpdatesLabelText;
    private String theEnableUpdateTrapLabelText;
    private String theCheckUpdatesWaitTitle;
    private String theCheckUpdatesWaitText;
    private String theWaitTitle;
    private String theWaitText;
    public static final String kEnableUpdatesForm = "ENABLEUPDATES";
    public static final String kUpdatesEnabled = "UpdatesEnabled";
    public static final String kUpdateTrapEnabled = "UpdateTrapEnabled";
    public static final String kUpdatesProxy = "UpdatesProxy";
    public static final String kUpdatesPort = "UpdatesPort";
    private ServiceManager services;

    public OmahaUpdatesPage(@NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
    }

    @Override
    public StringBuilder toHTML(PageContext pageContext) {
        ApcPage apcPage = new ApcPage(this.services);
        apcPage.addScript("scripts/navigation.js");
        apcPage.addScript("scripts/checkupdates.js");
        this.setupLanguage(pageContext.getLocale());
        Division division = new Division();
        division.setTitle(this.theWaitTitle);
        division.setCssClass("waitDialog");
        division.setId("waitDialog");
        division.add(new Text(this.theWaitText));
        apcPage.add(division);
        Division division2 = new Division();
        division2.setTitle(this.theCheckUpdatesWaitTitle);
        division2.setCssClass("waitDialog");
        division2.setId("checkUpdatesWaitDialog");
        division2.add(new Text(this.theCheckUpdatesWaitText));
        apcPage.add(division2);
        this.setupAvailableUpdates(apcPage, pageContext);
        this.setupEnableUpdates(apcPage, pageContext);
        StringBuilder stringBuilder = new StringBuilder();
        HTMLDebug.htmlComment(stringBuilder, "Begin OmahaUpdatePage");
        stringBuilder.append((CharSequence)apcPage.toHTML(pageContext));
        HTMLDebug.htmlComment(stringBuilder, "End OmahaUpdatePage");
        stringBuilder.trimToSize();
        return stringBuilder;
    }

    private void setupAvailableUpdates(ApcPage apcPage, PageContext pageContext) {
        Division division = new Division();
        division.setId("checkUpdates");
        apcPage.add(division);
    }

    private void setupEnableUpdates(ApcPage apcPage, PageContext pageContext) {
        ApcSectionHeader apcSectionHeader = new ApcSectionHeader(this.theEnableUpdatesHeaderText, this.theEnableUpdatesSubHeaderText);
        apcSectionHeader.setHelpId(ApcHelp.CHECK_UPDATES);
        apcPage.add(apcSectionHeader);
        ApcForm apcForm = new ApcForm(kEnableUpdatesForm, "/updates");
        apcForm.setId("checkUpdatesForm");
        ApcSection apcSection = new ApcSection();
        Checkbox checkbox = new Checkbox(kUpdatesEnabled);
        Object object = pageContext.get(SoftwareUpdateGroup.AutoUpdateEnabled.getObjectId());
        if (object instanceof Boolean) {
            checkbox.setCheck((Boolean)object);
        }
        ApcSectionLabel apcSectionLabel = new ApcSectionLabel(this.theEnableUpdatesLabelText);
        apcSection.add(apcSectionLabel, checkbox);
        ConfigurationManager configurationManager = ServiceManager.getInstance().getConfigurationManager();
        try {
            if (configurationManager.containsKey("SNMP", "SNMP_DiscoveryPort")) {
                Checkbox checkbox2 = new Checkbox(kUpdateTrapEnabled);
                Boolean bl = configurationManager.containsKey("SNMP", "UpdateAvailable_Enabled") && configurationManager.getBoolean("SNMP", "UpdateAvailable_Enabled") != false;
                checkbox2.setCheck(bl);
                ApcSectionLabel apcSectionLabel2 = new ApcSectionLabel(this.theEnableUpdateTrapLabelText);
                apcSection.add(apcSectionLabel2, checkbox2);
            }
        }
        catch (NoSuchElementException | ConversionException throwable) {
            logger.debug("Issue getting SNMP Update Enabled Settings from ini:" + throwable.getLocalizedMessage());
        }
        apcSection.addButtons();
        apcForm.add(apcSection);
        pageContext.addFormToken(apcForm);
        apcPage.add(apcForm);
    }

    private void setupLanguage(Locale locale) {
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        this.theEnableUpdatesHeaderText = Utils.getResourceString(resourceBundleWrapper, kEnableUpdatesHeaderId);
        this.theEnableUpdatesSubHeaderText = Utils.getResourceString(resourceBundleWrapper, kEnableUpdatesSubHeaderId);
        this.theEnableUpdatesLabelText = Utils.getResourceString(resourceBundleWrapper, kEnableUpdatesLabelId);
        this.theEnableUpdateTrapLabelText = Utils.getResourceString(resourceBundleWrapper, kEnableUpdateTrapLabelId);
        this.theCheckUpdatesWaitTitle = Utils.getResourceString(resourceBundleWrapper, kCheckUpdatesWaitTitle);
        this.theCheckUpdatesWaitText = Utils.getResourceString(resourceBundleWrapper, kCheckUpdatesWaitText);
        this.theWaitTitle = Utils.getResourceString(resourceBundleWrapper, kWaitTitle);
        this.theWaitText = Utils.getResourceString(resourceBundleWrapper, kWaitText);
    }
}

