/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.pages;

import com.apcc.m11.components.webserver.html.Container;
import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.HTMLButton;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.Text;
import com.apcc.m11.components.webserver.html.apc.ApcForm;
import com.apcc.m11.components.webserver.html.apc.ApcHelp;
import com.apcc.m11.components.webserver.html.apc.ApcPage;
import com.apcc.m11.components.webserver.html.apc.ApcSectionHeader;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.html.document.Heading;
import com.apcc.m11.components.webserver.html.document.Span;
import com.apcc.m11.components.webserver.html.form.Input;
import com.apcc.m11.components.webserver.html.list.UnOrderedList;
import com.apcc.m11.components.webserver.html.util.Image;
import com.apcc.m11.components.webserver.model.VMOperations;
import com.apcc.m11.components.webserver.model.VMPrioritizationDurations;
import com.apcc.m11.components.webserver.model.VMPrioritizationOperations;
import com.apcc.m11.components.webserver.model.VMPriority;
import com.apcc.m11.components.webserver.util.FormHelper;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.util.Locale;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OmahaVMPrioritization
implements HTML {
    private static final Logger logger = LogManager.getLogger(OmahaVMPrioritization.class);
    public static final String ATTR_VM_PRIORITIZATION_ENABLED = "VMPrioritizationEnabled";
    public static final String ATTR_VM_PRIORITIZATION_DATA = "VMPrioritizationData";
    public static final String PARAM_NAME_ACTIVE_ACCORDION = "activeAcc";
    private static final String kVMPrioritizationHeader = "VMPrioritization.Heading";
    private static final String kVMPrioritizationSubHeader = "VMPrioritization.SubHeading";
    private static final String kVMPrioritizationEnabledLabel = "VMPrioritization.VMPrioritizationEnableLabel";
    private static final String kVMPrioritizationError = "VMPrioritization.Error";
    private static final String kVMPrioritizationWarning = "VMPrioritization.Warning";
    private static final String kVCenterConnectionFailure = "VMPrioritization.vCenterConnectionFailure";
    private static final String kClusterConnectionFailure = "VMPrioritization.ClusterConnectionFailure";
    private static final String kNoVMsFound = "VMPrioritization.NoVMsFoundWarning";
    private static final String kPrioritizedVMsTooltip = "VMPrioritization.PrioritizedVMsTooltip";
    public static final String kPriorityTreeNodeLabelHigh = "VMPrioritization.PriorityTreeNodeLabelHigh";
    public static final String kPriorityTreeNodeLabelMedium = "VMPrioritization.PriorityTreeNodeLabelMedium";
    public static final String kPriorityTreeNodeLabelLow = "VMPrioritization.PriorityTreeNodeLabelLow";
    public static final String kPriorityTreeNodeLabelGroup1 = "VMPrioritization.PriorityTreeNodeLabelGroup1";
    public static final String kPriorityTreeNodeLabelGroup2 = "VMPrioritization.PriorityTreeNodeLabelGroup2";
    public static final String kPriorityTreeNodeTooltipHigh = "VMPrioritization.PriorityTreeNodeTooltipHigh";
    public static final String kPriorityTreeNodeTooltipMedium = "VMPrioritization.PriorityTreeNodeTooltipMedium";
    public static final String kPriorityTreeNodeTooltipLow = "VMPrioritization.PriorityTreeNodeTooltipLow";
    public static final String kPriorityTreeNodeTooltipGroup1 = "VMPrioritization.PriorityTreeNodeTooltipGroup1";
    public static final String kPriorityTreeNodeTooltipGroup2 = "VMPrioritization.PriorityTreeNodeTooltipGroup2";
    private static final String kRemoveButton = "VMPrioritization.RemoveButton";
    private static final String kMultipleSelection = "VMPrioritization.MultipleSelection";
    private static final String kInventoryLoading = "VMPrioritization.InventoryLoading";
    private static final String kPriorityLoading = "VMPrioritization.PriorityLoading";
    private static final String kVirtualAppPriorityErrorText = "VMPrioritization.VirtualAppPriorityError";
    private static final String kPrioritizedVMsHeader = "VMPrioritization.PrioritizedVMsHeading";
    private static final String kVMMigrationHeader = "VMPrioritization.VMMigrationHeading";
    private static final String kVMShutdownHeader = "VMPrioritization.VMShutdownHeading";
    private static final String kVMStartupHeader = "VMPrioritization.VMStartupHeading";
    private static final String kDurationHigh = "VMPrioritization.DurationHighLabel";
    private static final String kDurationMedium = "VMPrioritization.DurationMediumLabel";
    private static final String kDurationLow = "VMPrioritization.DurationLowLabel";
    private static final String kDurationGroup1 = "VMPrioritization.DurationGroup1Label";
    private static final String kDurationGroup2 = "VMPrioritization.DurationGroup2Label";
    private static final String kDurationUnPrioritized = "VMPrioritization.DurationUnPrioritizedLabel";
    private static final String kVMMigrationDurationHighTooltip = "VMPrioritization.VMMigrationDurationHighTooltip";
    private static final String kVMMigrationDurationMediumTooltip = "VMPrioritization.VMMigrationDurationMediumTooltip";
    private static final String kVMMigrationDurationLowTooltip = "VMPrioritization.VMMigrationDurationLowTooltip";
    private static final String kVMMigrationDurationGroup1Tooltip = "VMPrioritization.VMMigrationDurationGroup1Tooltip";
    private static final String kVMMigrationDurationGroup2Tooltip = "VMPrioritization.VMMigrationDurationGroup2Tooltip";
    private static final String kVMMigrationDurationUnPrioritizedTooltip = "VMPrioritization.VMMigrationDurationUnPrioritizedTooltip";
    private static final String kVMShutdownDurationHighTooltip = "VMPrioritization.VMShutdownDurationHighTooltip";
    private static final String kVMShutdownDurationMediumTooltip = "VMPrioritization.VMShutdownDurationMediumTooltip";
    private static final String kVMShutdownDurationLowTooltip = "VMPrioritization.VMShutdownDurationLowTooltip";
    private static final String kVMShutdownDurationGroup1Tooltip = "VMPrioritization.VMShutdownDurationGroup1Tooltip";
    private static final String kVMShutdownDurationGroup2Tooltip = "VMPrioritization.VMShutdownDurationGroup2Tooltip";
    private static final String kVMShutdownDurationUnPrioritizedTooltip = "VMPrioritization.VMShutdownDurationUnPrioritizedTooltip";
    private static final String kVMStartupDurationHighTooltip = "VMPrioritization.VMStartupDurationHighTooltip";
    private static final String kVMStartupDurationMediumTooltip = "VMPrioritization.VMStartupDurationMediumTooltip";
    private static final String kVMStartupDurationLowTooltip = "VMPrioritization.VMStartupDurationLowTooltip";
    private static final String kVMStartupDurationGroup1Tooltip = "VMPrioritization.VMStartupDurationGroup1Tooltip";
    private static final String kVMStartupDurationGroup2Tooltip = "VMPrioritization.VMStartupDurationGroup2Tooltip";
    private static final String kVMStartupDurationUnPrioritizedTooltip = "VMPrioritization.VMStartupDurationUnPrioritizedTooltip";
    private static final String kSecondsUnitLabel = "VMSettings.SecondsUnitLabel";
    private static final String kApplyButton = "PCNS.ApplyButton";
    private static final String kResetButton = "PCNS.UndoButton";
    private static final String kRangeValidation = "PCNS.RangeValidation";
    private static final String kDigitsValidation = "PCNS.DigitsValidation";
    private static final String kRequiredField = "PCNS.RequiredField";
    private static final String kWaitTitle = "PCNS.WaitTitle";
    private static final String kWaitText = "PCNS.WaitText";
    private static final String kWarningText = "VMPrioritization.DurationOverridingWarning";
    private static final String HYPER_V_MODULE_NOT_INSTALLED = "VMPrioritization.HyperVModuleNotInstalled";
    private String theVMPrioritizationHeaderText;
    private String theVMPrioritizationSubHeaderText;
    private String theVMPrioritizationEnabledLabelText;
    private String theVMPrioritizationErrorText;
    private String theVMPrioritizationWarningText;
    private String theVCenterServerConnectionFailureText;
    private String thePriorityListErrorText;
    private String theNoVMsFoundText;
    private String thePrioritizedVMsTooltipText;
    private String theDeleteButtonText;
    private String theMultipleSelectionText;
    private String theInventoryLoadingText;
    private String thePriorityLoadingText;
    private String thePrioritizedVMsHeaderText;
    private String theVMMigrationHeaderText;
    private String theVMShutdownHeaderText;
    private String theVMStartupHeaderText;
    private String theDurationHighText;
    private String theDurationMediumText;
    private String theDurationLowText;
    private String theDurationGroup1Text;
    private String theDurationGroup2Text;
    private String theDurationUnPrioritizedText;
    private String theVMMigrationDurationHighTooltipText;
    private String theVMMigrationDurationMediumTooltipText;
    private String theVMMigrationDurationLowTooltipText;
    private String theVMMigrationDurationGroup1TooltipText;
    private String theVMMigrationDurationGroup2TooltipText;
    private String theVMMigrationDurationUnPrioritizedTooltipText;
    private String theVMShutdownDurationHighTooltipText;
    private String theVMShutdownDurationMediumTooltipText;
    private String theVMShutdownDurationLowTooltipText;
    private String theVMShutdownDurationGroup1TooltipText;
    private String theVMShutdownDurationGroup2TooltipText;
    private String theVMShutdownDurationUnPrioritizedTooltipText;
    private String theVMStartupDurationHighTooltipText;
    private String theVMStartupDurationMediumTooltipText;
    private String theVMStartupDurationLowTooltipText;
    private String theVMStartupDurationGroup1TooltipText;
    private String theVMStartupDurationGroup2TooltipText;
    private String theVMStartupDurationUnPrioritizedTooltipText;
    private String theSecondsUnitLabelText;
    private String theRequiredFieldValidationText;
    private String theRangeValidationText;
    private String theDigitsValidationText;
    private String theApplyButtonText;
    private String theResetButtonText;
    private String theWaitTitle;
    private String theWaitText;
    private String theWarningText;
    private String theHyperVModuleUnavailableText;
    private ServiceManager services;

    public OmahaVMPrioritization(@NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
    }

    @Override
    public StringBuilder toHTML(PageContext pageContext) {
        this.setupLanguage(pageContext.getLocale());
        ApcPage apcPage = new ApcPage(this.services);
        apcPage.addStyleSheet("jstree/themes/default/style.min.css");
        apcPage.addStyleSheet("styles/form.css");
        apcPage.addStyleSheet("styles/vmprioritization.css");
        apcPage.addScript("scripts/jquery.validate.min.js");
        apcPage.addScript("jstree/jstree.min.js");
        apcPage.addScript("scripts/navigation.js");
        apcPage.addScript("scripts/vmprioritization.js");
        ApcSectionHeader apcSectionHeader = new ApcSectionHeader(this.theVMPrioritizationHeaderText, this.theVMPrioritizationSubHeaderText);
        apcSectionHeader.setHelpId(this.services.getVirtualConfigurationManager().isNutanixAHV() ? ApcHelp.NUTANIX_VM_PRIORITIZATION : ApcHelp.VM_PRIORITIZATION_CONFIGURATION);
        apcPage.add(apcSectionHeader);
        ApcForm apcForm = new ApcForm("vmprioritization", "/vmprioritization");
        apcForm.setId("vmprioritizationform");
        apcPage.add(apcForm);
        Division division = new Division();
        division.setId("waitDialog");
        division.setCssClass("waitDialog");
        division.setTitle(this.theWaitTitle);
        division.add(new Text(this.theWaitText));
        apcPage.add(division);
        Division division2 = new Division();
        division2.setId("errorcontainer");
        division2.add(new Text(this.theVMPrioritizationErrorText));
        division2.setCssClass("ui-state-error ui-corner-all");
        apcForm.add(FormHelper.createErrorDivision("errorcontainer", this.theVMPrioritizationErrorText, null));
        Division division3 = new Division();
        division3.setId("warningcontainer");
        division3.add(new Text(this.theVMPrioritizationWarningText));
        division3.setCssClass("ui-state-highlight ui-corner-all");
        apcForm.add(FormHelper.createWarningDivision("warningcontainer", this.theVMPrioritizationWarningText, null));
        Division division4 = new Division();
        division4.setId("maindiv");
        division4.setCssClass("formdiv");
        apcForm.add(division4);
        Boolean bl = (Boolean)pageContext.getValue(ATTR_VM_PRIORITIZATION_ENABLED);
        if (bl == null) {
            bl = false;
        }
        division4.add(FormHelper.createLabelCheckboxValueDiv("VMPrioritizationEnabledDiv", this.theVMPrioritizationEnabledLabelText, bl, null, ATTR_VM_PRIORITIZATION_ENABLED));
        VMPrioritizationOperations vMPrioritizationOperations = (VMPrioritizationOperations)pageContext.getValue(ATTR_VM_PRIORITIZATION_DATA);
        if (vMPrioritizationOperations == null) {
            vMPrioritizationOperations = new VMPrioritizationOperations();
            logger.error("doGet - failed to retrieve VM Prioritization data from page context while generating page; displaying empty data");
        }
        Division division5 = new Division();
        division5.setId("accordionDiv");
        division4.add(division5);
        this.addPriorityTree(division5, vMPrioritizationOperations);
        this.addPriorityDurations(division5, vMPrioritizationOperations);
        division4.add(this.createButtonDiv("VMPrioritization"));
        Input input = new Input();
        input.setName(PARAM_NAME_ACTIVE_ACCORDION);
        input.setId(PARAM_NAME_ACTIVE_ACCORDION);
        input.setType("hidden");
        String string = (String)pageContext.getValue(PARAM_NAME_ACTIVE_ACCORDION);
        input.setValue(string != null ? string : "0");
        apcForm.add(input);
        apcPage.add(this.getResourceStrings());
        pageContext.addFormToken(apcForm);
        return apcPage.toHTML(pageContext);
    }

    private void addPriorityTree(Container container, VMPrioritizationOperations vMPrioritizationOperations) {
        Heading heading = Heading.h3();
        heading.setCssClass("priorityheader");
        heading.add(new Text(this.thePrioritizedVMsHeaderText));
        container.add(heading);
        Division division = new Division();
        division.setCssClass("prioritycontent");
        container.add(division);
        Division division2 = new Division();
        division2.setId("priorityVMHeaderDiv");
        division2.add(new Text(this.thePrioritizedVMsTooltipText));
        division.add(division2);
        Division division3 = new Division();
        division3.setId("clusterConnectionError");
        division3.setCssClass("treemsg ui-state-error ui-corner-all");
        if (this.services.getVirtualConfigurationManager().isESXi()) {
            division3.add(new Text(this.theVCenterServerConnectionFailureText));
        }
        if (this.services.getVirtualConfigurationManager().isHyperV()) {
            division3.add(new Text(this.theHyperVModuleUnavailableText));
        }
        division.add(division3);
        Division division4 = new Division();
        division4.setId("priorityListError");
        division4.setCssClass("treemsg ui-state-error ui-corner-all");
        division4.add(new Text(this.thePriorityListErrorText));
        division.add(division4);
        Division division5 = new Division();
        division5.setId("noVMsFound");
        Image image = new Image("/images/exclamation.gif");
        image.setCssClass("warningImg");
        division5.add(image);
        division5.setCssClass("treemsg ui-state-highlight ui-corner-all");
        division5.add(new Text(this.theNoVMsFoundText));
        division.add(division5);
        Division division6 = new Division();
        division6.setId("multitree");
        division.add(division6);
        Division division7 = new Division();
        division7.setId("inventory");
        division7.setCssClass("treelist ui-corner-all");
        division6.add(division7);
        UnOrderedList unOrderedList = new UnOrderedList();
        division7.add(unOrderedList);
        Division division8 = new Division();
        division8.setId("prioritylist");
        division8.setCssClass("treelist ui-corner-all");
        UnOrderedList unOrderedList2 = new UnOrderedList();
        division8.add(unOrderedList2);
        division6.add(division8);
        Division division9 = new Division();
        division9.setId("priorityListValidator");
        Input input = new Input();
        input.setId("priorityListValid");
        input.setName("priorityListValid");
        input.setValue("0");
        division9.add(input);
        Input input2 = new Input();
        input2.setId("priorityListCheck");
        input2.setName("priorityListCheck");
        input2.setValue("0");
        division9.add(input2);
        division6.add(division9);
        HTMLButton hTMLButton = new HTMLButton();
        division6.add(hTMLButton);
        hTMLButton.setId("deletebtn");
        hTMLButton.add(new Text(this.theDeleteButtonText));
    }

    private void addDurationOverridingWarning(Container container) {
        Division division = new Division();
        division.setCssClass("warningDiv");
        Image image = new Image("/images/exclamation.gif");
        image.setCssClass("warningImg");
        division.add(image);
        division.add(new Text(this.theWarningText));
        division.setCssClass("treemsg ui-state-default ui-corner-all");
        container.add(division);
    }

    private void addPriorityDurations(Container container, VMPrioritizationOperations vMPrioritizationOperations) {
        Division division;
        Heading heading;
        if (!this.services.getVirtualConfigurationManager().isNutanixAHV()) {
            heading = Heading.h3();
            heading.setId("vmmigration");
            heading.setCssClass("durationsheader");
            heading.add(new Text(this.theVMMigrationHeaderText));
            container.add(heading);
            division = new Division();
            division.setCssClass("durationscontent");
            container.add(division);
            this.addDurations(division, vMPrioritizationOperations.getMigrationDurations(), VMOperations.MIGRATION);
        }
        heading = Heading.h3();
        heading.setId("vmshutdown");
        heading.setCssClass("durationsheader");
        heading.add(new Text(this.theVMShutdownHeaderText));
        container.add(heading);
        division = new Division();
        division.setCssClass("durationscontent");
        container.add(division);
        this.addDurations(division, vMPrioritizationOperations.getShutdownDurations(), VMOperations.SHUTDOWN);
        Heading heading2 = Heading.h3();
        heading2.setId("vmstartup");
        heading2.setCssClass("durationsheader");
        heading2.add(new Text(this.theVMStartupHeaderText));
        container.add(heading2);
        Division division2 = new Division();
        division2.setCssClass("durationscontent");
        container.add(division2);
        this.addDurations(division2, vMPrioritizationOperations.getStartupDurations(), VMOperations.STARTUP);
    }

    private void addDurations(Container container, VMPrioritizationDurations vMPrioritizationDurations, VMOperations vMOperations) {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        switch (vMOperations) {
            case MIGRATION: {
                string = this.theVMMigrationDurationHighTooltipText;
                string2 = this.theVMMigrationDurationMediumTooltipText;
                string3 = this.theVMMigrationDurationLowTooltipText;
                string4 = this.theVMMigrationDurationGroup1TooltipText;
                string5 = this.theVMMigrationDurationGroup2TooltipText;
                string6 = this.theVMMigrationDurationUnPrioritizedTooltipText;
                break;
            }
            case SHUTDOWN: {
                string = this.theVMShutdownDurationHighTooltipText;
                string2 = this.theVMShutdownDurationMediumTooltipText;
                string3 = this.theVMShutdownDurationLowTooltipText;
                string4 = this.theVMShutdownDurationGroup1TooltipText;
                string5 = this.theVMShutdownDurationGroup2TooltipText;
                string6 = this.theVMShutdownDurationUnPrioritizedTooltipText;
                break;
            }
            case STARTUP: {
                string = this.theVMStartupDurationHighTooltipText;
                string2 = this.theVMStartupDurationMediumTooltipText;
                string3 = this.theVMStartupDurationLowTooltipText;
                string4 = this.theVMStartupDurationGroup1TooltipText;
                string5 = this.theVMStartupDurationGroup2TooltipText;
                string6 = this.theVMStartupDurationUnPrioritizedTooltipText;
            }
        }
        this.addDurationOverridingWarning(container);
        container.add(this.addDuration(vMOperations, VMPriority.HIGH, vMPrioritizationDurations.getHighDuration(), this.theDurationHighText, string));
        container.add(this.addDuration(vMOperations, VMPriority.MEDIUM, vMPrioritizationDurations.getMediumDuration(), this.theDurationMediumText, string2));
        container.add(this.addDuration(vMOperations, VMPriority.LOW, vMPrioritizationDurations.getLowDuration(), this.theDurationLowText, string3));
        container.add(this.addDuration(vMOperations, VMPriority.GROUP_1, vMPrioritizationDurations.getGroup1Duration(), this.theDurationGroup1Text, string4));
        container.add(this.addDuration(vMOperations, VMPriority.GROUP_2, vMPrioritizationDurations.getGroup2Duration(), this.theDurationGroup2Text, string5));
        container.add(this.addDuration(vMOperations, VMPriority.NONE, vMPrioritizationDurations.getUnPrioritizedDuration(), this.theDurationUnPrioritizedText, string6));
    }

    private Division addDuration(VMOperations vMOperations, VMPriority vMPriority, int n, String string, String string2) {
        String string3 = vMOperations.toString() + vMPriority.toString();
        Object object = "vmduration";
        if (vMOperations == VMOperations.SHUTDOWN) {
            object = (String)object + " " + vMPriority.toString() + " vmshutdown";
        }
        return FormHelper.createLabelTextInputValueDiv(string3 + "Div", string, String.valueOf(n), null, string3, (String)object, (Integer)6, null, this.theSecondsUnitLabelText, string2);
    }

    private HTML createButtonDiv(String string) {
        Division division = new Division();
        division.setId("buttondiv");
        Input input = new Input();
        input.setName("apply");
        input.setValue(this.theApplyButtonText);
        input.setId("apply" + string);
        input.setType("submit");
        input.setClassName("newbutton");
        division.add(input);
        Input input2 = new Input();
        input2.setName("reset" + string);
        input2.setValue(this.theResetButtonText);
        input2.setId("reset" + string);
        input2.setType("reset");
        input2.setClassName("newbutton");
        division.add(input2);
        return division;
    }

    private Division getResourceStrings() {
        Division division = new Division();
        division.setId("jsres");
        Span span = new Span(this.theRequiredFieldValidationText);
        span.setId("resRequiredFieldValidation");
        division.add(span);
        span = new Span(this.theRangeValidationText);
        span.setId("resRangeValidation");
        division.add(span);
        span = new Span(this.theDigitsValidationText);
        span.setId("resDigitsValidation");
        division.add(span);
        span = new Span(this.theMultipleSelectionText);
        span.setId("resMultipleSelection");
        division.add(span);
        span = new Span(this.theInventoryLoadingText);
        span.setId("resInventoryLoading");
        division.add(span);
        span = new Span(this.thePriorityLoadingText);
        span.setId("resPriorityLoading");
        division.add(span);
        return division;
    }

    private void setupLanguage(Locale locale) {
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        this.theVMPrioritizationHeaderText = Utils.getResourceString(resourceBundleWrapper, kVMPrioritizationHeader);
        this.theVMPrioritizationSubHeaderText = Utils.getResourceString(resourceBundleWrapper, kVMPrioritizationSubHeader);
        this.theVMPrioritizationErrorText = Utils.getResourceString(resourceBundleWrapper, kVMPrioritizationError);
        this.theVMPrioritizationWarningText = Utils.getResourceString(resourceBundleWrapper, kVMPrioritizationWarning);
        this.theVMPrioritizationEnabledLabelText = Utils.getResourceString(resourceBundleWrapper, kVMPrioritizationEnabledLabel);
        this.theVCenterServerConnectionFailureText = this.services.getVirtualConfigurationManager().isNutanixAHV() ? Utils.getResourceString(resourceBundleWrapper, kClusterConnectionFailure) : Utils.getResourceString(resourceBundleWrapper, kVCenterConnectionFailure);
        this.thePriorityListErrorText = Utils.getResourceString(resourceBundleWrapper, kVirtualAppPriorityErrorText);
        this.theNoVMsFoundText = Utils.getResourceString(resourceBundleWrapper, kNoVMsFound);
        this.thePrioritizedVMsTooltipText = Utils.getResourceString(resourceBundleWrapper, kPrioritizedVMsTooltip);
        this.theDeleteButtonText = Utils.getResourceString(resourceBundleWrapper, kRemoveButton);
        this.theMultipleSelectionText = Utils.getResourceString(resourceBundleWrapper, kMultipleSelection);
        this.theInventoryLoadingText = Utils.getResourceString(resourceBundleWrapper, kInventoryLoading);
        this.thePriorityLoadingText = Utils.getResourceString(resourceBundleWrapper, kPriorityLoading);
        this.thePrioritizedVMsHeaderText = Utils.getResourceString(resourceBundleWrapper, kPrioritizedVMsHeader);
        this.theVMMigrationHeaderText = Utils.getResourceString(resourceBundleWrapper, kVMMigrationHeader);
        this.theVMShutdownHeaderText = Utils.getResourceString(resourceBundleWrapper, kVMShutdownHeader);
        this.theVMStartupHeaderText = Utils.getResourceString(resourceBundleWrapper, kVMStartupHeader);
        this.theDurationHighText = Utils.getResourceString(resourceBundleWrapper, kDurationHigh);
        this.theDurationMediumText = Utils.getResourceString(resourceBundleWrapper, kDurationMedium);
        this.theDurationLowText = Utils.getResourceString(resourceBundleWrapper, kDurationLow);
        this.theDurationGroup1Text = Utils.getResourceString(resourceBundleWrapper, kDurationGroup1);
        this.theDurationGroup2Text = Utils.getResourceString(resourceBundleWrapper, kDurationGroup2);
        this.theDurationUnPrioritizedText = Utils.getResourceString(resourceBundleWrapper, kDurationUnPrioritized);
        this.theVMMigrationDurationHighTooltipText = Utils.getResourceString(resourceBundleWrapper, kVMMigrationDurationHighTooltip);
        this.theVMMigrationDurationMediumTooltipText = Utils.getResourceString(resourceBundleWrapper, kVMMigrationDurationMediumTooltip);
        this.theVMMigrationDurationLowTooltipText = Utils.getResourceString(resourceBundleWrapper, kVMMigrationDurationLowTooltip);
        this.theVMMigrationDurationGroup1TooltipText = Utils.getResourceString(resourceBundleWrapper, kVMMigrationDurationGroup1Tooltip);
        this.theVMMigrationDurationGroup2TooltipText = Utils.getResourceString(resourceBundleWrapper, kVMMigrationDurationGroup2Tooltip);
        this.theVMMigrationDurationUnPrioritizedTooltipText = Utils.getResourceString(resourceBundleWrapper, kVMMigrationDurationUnPrioritizedTooltip);
        this.theVMShutdownDurationHighTooltipText = Utils.getResourceString(resourceBundleWrapper, kVMShutdownDurationHighTooltip);
        this.theVMShutdownDurationMediumTooltipText = Utils.getResourceString(resourceBundleWrapper, kVMShutdownDurationMediumTooltip);
        this.theVMShutdownDurationLowTooltipText = Utils.getResourceString(resourceBundleWrapper, kVMShutdownDurationLowTooltip);
        this.theVMShutdownDurationGroup1TooltipText = Utils.getResourceString(resourceBundleWrapper, kVMShutdownDurationGroup1Tooltip);
        this.theVMShutdownDurationGroup2TooltipText = Utils.getResourceString(resourceBundleWrapper, kVMShutdownDurationGroup2Tooltip);
        this.theVMShutdownDurationUnPrioritizedTooltipText = Utils.getResourceString(resourceBundleWrapper, kVMShutdownDurationUnPrioritizedTooltip);
        this.theVMStartupDurationHighTooltipText = Utils.getResourceString(resourceBundleWrapper, kVMStartupDurationHighTooltip);
        this.theVMStartupDurationMediumTooltipText = Utils.getResourceString(resourceBundleWrapper, kVMStartupDurationMediumTooltip);
        this.theVMStartupDurationLowTooltipText = Utils.getResourceString(resourceBundleWrapper, kVMStartupDurationLowTooltip);
        this.theVMStartupDurationGroup1TooltipText = Utils.getResourceString(resourceBundleWrapper, kVMStartupDurationGroup1Tooltip);
        this.theVMStartupDurationGroup2TooltipText = Utils.getResourceString(resourceBundleWrapper, kVMStartupDurationGroup2Tooltip);
        this.theVMStartupDurationUnPrioritizedTooltipText = Utils.getResourceString(resourceBundleWrapper, kVMStartupDurationUnPrioritizedTooltip);
        this.theSecondsUnitLabelText = Utils.getResourceString(resourceBundleWrapper, kSecondsUnitLabel);
        this.theRequiredFieldValidationText = Utils.getResourceString(resourceBundleWrapper, kRequiredField);
        this.theRangeValidationText = Utils.getResourceString(resourceBundleWrapper, kRangeValidation);
        this.theDigitsValidationText = Utils.getResourceString(resourceBundleWrapper, kDigitsValidation);
        this.theApplyButtonText = Utils.getResourceString(resourceBundleWrapper, kApplyButton);
        this.theResetButtonText = Utils.getResourceString(resourceBundleWrapper, kResetButton);
        this.theWaitTitle = Utils.getResourceString(resourceBundleWrapper, kWaitTitle);
        this.theWaitText = Utils.getResourceString(resourceBundleWrapper, kWaitText);
        this.theWarningText = Utils.getResourceString(resourceBundleWrapper, kWarningText);
        this.theHyperVModuleUnavailableText = Utils.getResourceString(resourceBundleWrapper, HYPER_V_MODULE_NOT_INSTALLED);
    }
}

