/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.pages;

import com.apcc.m11.components.webserver.html.Container;
import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.HTMLTagWithClassStyle;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.Text;
import com.apcc.m11.components.webserver.html.apc.ApcForm;
import com.apcc.m11.components.webserver.html.apc.ApcHelp;
import com.apcc.m11.components.webserver.html.apc.ApcPage;
import com.apcc.m11.components.webserver.html.apc.ApcSectionHeader;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.html.form.Form;
import com.apcc.m11.components.webserver.html.form.Input;
import com.apcc.m11.components.webserver.model.VMSettings;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.m11.components.webserver.util.VMSettingsHTMLHelper;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.util.Locale;
import lombok.NonNull;

public class OmahaVMSettingsPage
implements HTML {
    public static final String PARAM_NAME_ACTIVE_ACCORDION = "activeAcc";
    private static final String kVMSettingsError = "Shutdown.ErrorText";
    private static final String kVMSettingsHeader = "VMSettings.VMSettingsHeader";
    private static final String kSCVMMSettingsHeader = "VMSettings.SCVMMSettingsHeader";
    private static final String kVMSettingsSubHeader = "VMSettings.VMSettingsSubHeader";
    private static final String kSCVMMSettingsSubHeader = "VMSettings.SCVMMSettingsSubHeader";
    private static final String kApplyButton = "PCNS.ApplyButton";
    private static final String kResetButton = "PCNS.UndoButton";
    private static final String kWaitTitle = "PCNS.WaitTitle";
    private static final String kWaitText = "PCNS.WaitText";
    private String theVMSettingsErrorText;
    private String theVMSettingsHeaderText;
    private String theSCVMMSettingsHeaderText;
    private String theVMSettingsSubHeaderText;
    private String theSCVMMSettingsSubHeaderText;
    private String theApplyButtonText;
    private String theResetButtonText;
    private String theWaitTitle;
    private String theWaitText;
    private boolean isGlobal = true;
    private ServiceManager services;

    public OmahaVMSettingsPage(@NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
    }

    @Override
    public StringBuilder toHTML(PageContext pageContext) {
        Object object;
        Object object2;
        this.setupLanguage(pageContext.getLocale());
        ApcPage apcPage = new ApcPage(this.services);
        boolean bl = this.services.getVirtualConfigurationManager().isHyperV();
        boolean bl2 = this.services.getVirtualConfigurationManager().isESXi();
        boolean bl3 = this.services.getVirtualConfigurationManager().isManagedHost();
        boolean bl4 = this.services.getAdvancedSetupHelper().isAdvancedShutdownMode();
        boolean bl5 = this.services.getVirtualConfigurationManager().isNutanixAHV();
        boolean bl6 = bl && !bl3 || bl2 && bl3 && (!bl4 || !this.isGlobal);
        apcPage.addStyleSheet("styles/form.css");
        if (bl6) {
            apcPage.addStyleSheet("jstree/themes/default/style.min.css");
            apcPage.addStyleSheet("styles/hostmap.css");
        }
        apcPage.addStyleSheet("styles/vmsettings.css");
        if (bl6) {
            apcPage.addScript("jstree/jstree.min.js");
        }
        apcPage.addScript("scripts/jquery.validate.min.js");
        apcPage.addScript("scripts/navigation.js");
        apcPage.addScript("scripts/vmsettings.js");
        if (bl6) {
            apcPage.addScript("scripts/customtargethost.js");
        }
        String string = this.theVMSettingsHeaderText;
        String string2 = this.theVMSettingsSubHeaderText;
        if (bl && bl3) {
            string = this.theSCVMMSettingsHeaderText;
            string2 = this.theSCVMMSettingsSubHeaderText;
        }
        ApcSectionHeader apcSectionHeader = new ApcSectionHeader(string, string2);
        if (bl2) {
            apcSectionHeader.setHelpId(ApcHelp.VIRTUALIZATION_SETTINGS);
        } else if (bl) {
            if (bl3) {
                apcSectionHeader.setHelpId(ApcHelp.SCVMM_CONFIGURATION_SCVMM_VIRTUALIZATION_SETTINGS);
            } else {
                apcSectionHeader.setHelpId(ApcHelp.HYPER_V_VIRTUALIZATION_SETTINGS);
            }
        } else if (bl5) {
            apcSectionHeader.setHelpId(ApcHelp.NUTANIX_VIRTUALIZATION_SETTINGS);
        }
        apcPage.add(apcSectionHeader);
        ApcForm apcForm = null;
        apcForm = this.isGlobal ? new ApcForm("shuttownsettings", "/vmsettings") : new ApcForm("shuttownsettings", "/individualvmsettings");
        apcForm.setId("vmsettingsform");
        apcPage.add(apcForm);
        Division division = new Division();
        division.setId("waitDialog");
        division.setCssClass("waitDialog");
        division.setTitle(this.theWaitTitle);
        division.add(new Text(this.theWaitText));
        apcPage.add(division);
        Division division2 = new Division();
        division2.setId("errorcontainer");
        division2.add(new Text(this.theVMSettingsErrorText));
        division2.setCssClass("ui-state-error ui-corner-all");
        apcForm.add(division2);
        VMSettings vMSettings = (VMSettings)pageContext.getValue("vm_settings");
        Integer n = (Integer)pageContext.getValue("setup");
        if (vMSettings != null) {
            object2 = new VMSettingsHTMLHelper(pageContext.getLocale(), this.services);
            if (bl) {
                object = new Division();
                ((HTMLTagWithClassStyle)object).setId("settingsDiv");
                ((VMSettingsHTMLHelper)object2).createVMSettingsWaitHTML((Container)object, vMSettings, false, this.isGlobal, bl3);
                apcForm.add((HTML)object);
            } else {
                ((VMSettingsHTMLHelper)object2).createVMSettingsHTML(apcForm, vMSettings, false, false, this.isGlobal, false, pageContext.getLocale(), n);
            }
        }
        if (n != null) {
            this.addIPHiddenInput(apcForm, n);
        }
        apcForm.add(this.createButtonDiv("VMSettings"));
        object2 = new Input();
        ((Input)object2).setName(PARAM_NAME_ACTIVE_ACCORDION);
        ((Input)object2).setId(PARAM_NAME_ACTIVE_ACCORDION);
        ((Input)object2).setType("hidden");
        object = (String)pageContext.getValue(PARAM_NAME_ACTIVE_ACCORDION);
        ((Input)object2).setValue((String)(object != null ? object : "0"));
        apcForm.add((HTML)object2);
        pageContext.addFormToken(apcForm);
        return apcPage.toHTML(pageContext);
    }

    private void addIPHiddenInput(Form form, Integer n) {
        Input input = new Input();
        input.setName("setup");
        input.setId("setup");
        input.setValue(n.toString());
        input.setType("hidden");
        form.add(input);
    }

    private HTML createButtonDiv(String string) {
        Division division = new Division();
        division.setId("buttondiv");
        Input input = new Input();
        input.setName("apply");
        input.setValue(this.theApplyButtonText);
        input.setId("apply" + string);
        input.setType("submit");
        input.setClassName("newbutton");
        division.add(input);
        Input input2 = new Input();
        input2.setName("reset" + string);
        input2.setValue(this.theResetButtonText);
        input2.setId("reset" + string);
        input2.setType("reset");
        input2.setClassName("newbutton");
        division.add(input2);
        return division;
    }

    private void setupLanguage(Locale locale) {
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        this.theVMSettingsHeaderText = Utils.getResourceString(resourceBundleWrapper, kVMSettingsHeader);
        this.theSCVMMSettingsHeaderText = Utils.getResourceString(resourceBundleWrapper, kSCVMMSettingsHeader);
        this.theVMSettingsSubHeaderText = Utils.getResourceString(resourceBundleWrapper, kVMSettingsSubHeader);
        this.theSCVMMSettingsSubHeaderText = Utils.getResourceString(resourceBundleWrapper, kSCVMMSettingsSubHeader);
        this.theVMSettingsErrorText = Utils.getResourceString(resourceBundleWrapper, kVMSettingsError);
        this.theApplyButtonText = Utils.getResourceString(resourceBundleWrapper, kApplyButton);
        this.theResetButtonText = Utils.getResourceString(resourceBundleWrapper, kResetButton);
        this.theWaitTitle = Utils.getResourceString(resourceBundleWrapper, kWaitTitle);
        this.theWaitText = Utils.getResourceString(resourceBundleWrapper, kWaitText);
    }

    public void setIsGlobal(boolean bl) {
        this.isGlobal = bl;
    }
}

