/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.pages;

import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.apc.ApcForm;
import com.apcc.m11.components.webserver.html.apc.ApcHelp;
import com.apcc.m11.components.webserver.html.apc.ApcPage;
import com.apcc.m11.components.webserver.html.apc.ApcSectionHeader;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.html.document.Span;
import com.apcc.m11.components.webserver.model.SSHSettings;
import com.apcc.m11.components.webserver.util.SSHSettingsHTMLHelper;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import lombok.NonNull;

public class SSHSettingsPage
implements HTML {
    private static final String HEADER_TEXT = "SSHSettings.SectionHeader";
    private static final String SUBHEADER_TEXT = "SSHSettings.SectionSubHeader";
    private static final String DIALOG_TITLE = "SSHSettings.Action.DialogTitle";
    private static final String OK_LABEL = "PCNS.OKButton";
    private static final String CLOSE_LABEL = "PCNS.CloseButton";
    private static final String CANCEL_LABEL = "PCNS.CancelButton";
    private static final String DUPLICATE_NAME_ERROR = "SSHSettings.Action.DuplicateNameError";
    private static final String REQUIRED_FIELD_ERROR = "PCNS.RequiredField";
    private static final String RANGE_VALIDATION_ERROR = "PCNS.RangeValidation";
    private static final String CREDENTIALS_VALIDATION_ERROR = "SSHSettings.Action.CredentialValidationError";
    private static final String INVALID_CMD_FILE_ERROR = "SSHSettings.Action.InvalidCommandFile";
    private static final String INVALID_SSH_FILE_ERROR = "SSHSettings.Action.InvalidSSHKeyFile";
    private static final String READ_FAIL_ERROR = "SSHSettings.Action.ReadFail";
    private static final String CREATE_FAIL_ERROR = "SSHSettings.Action.CreateFail";
    private static final String EDIT_FAIL_ERROR = "SSHSettings.Action.EditFail";
    private static final String DELETE_FAIL_ERROR = "SSHSettings.Action.DeleteFail";
    private static final String INVALID_HOSTNAME_ERROR = "SSHSettings.Action.InvalidHost";
    private static final String INVALID_CHARACTERS = "PCNS.InvalidCharacters";
    private String theHeaderText;
    private String theSubHeaderText;
    private String theActionDialogTitle;
    private String theCloseButtonLabel;
    private String theOKButtonLabel;
    private String theCancelButtonLabel;
    private String duplicateNameErrorText;
    private String requiredFieldError;
    private String rangeValidationError;
    private String credentialValidationError;
    private String invalidCommandFileError;
    private String invalidSSHKeyFileError;
    private String readFailError;
    private String createFailError;
    private String editFailError;
    private String deleteFailError;
    private String invalidHostError;
    private String invalidCharacters;
    private List<SSHSettings> settings;
    private ServiceManager services;

    public SSHSettingsPage(List<SSHSettings> list, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.settings = new ArrayList<SSHSettings>();
        this.services = serviceManager;
        if (list != null) {
            this.settings.addAll(list);
        }
    }

    @Override
    public StringBuilder toHTML(PageContext pageContext) {
        SSHSettingsHTMLHelper sSHSettingsHTMLHelper = new SSHSettingsHTMLHelper(pageContext.getLocale(), this.settings, this.services);
        this.setupLanguage(pageContext.getLocale());
        ApcPage apcPage = new ApcPage(this.services);
        apcPage.addStyleSheet("styles/form.css");
        apcPage.addStyleSheet("styles/ssh_actions.css");
        apcPage.addScript("scripts/jquery.validate.min.js");
        apcPage.addScript("scripts/additional-methods.min.js");
        apcPage.addScript("scripts/content.js");
        apcPage.addScript("scripts/ssh_settings.js");
        ApcSectionHeader apcSectionHeader = new ApcSectionHeader(this.theHeaderText, this.theSubHeaderText);
        apcSectionHeader.setHelpId(ApcHelp.SSH_SETTINGS);
        apcPage.add(apcSectionHeader);
        apcPage.add(sSHSettingsHTMLHelper.createWaitDialog());
        apcPage.add(sSHSettingsHTMLHelper.createErrorPanel());
        apcPage.add(sSHSettingsHTMLHelper.createSSHActionsListPanel(false));
        apcPage.add(sSHSettingsHTMLHelper.createActionDialogHTML());
        ApcForm apcForm = new ApcForm("sshsettings", "/sshsettings");
        apcForm.setId("sshsettings");
        apcPage.add(apcForm);
        apcPage.add(this.createResourceStrings());
        pageContext.addFormToken(apcForm);
        return apcPage.toHTML(pageContext);
    }

    public void setupLanguage(Locale locale) {
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        this.theHeaderText = Utils.getResourceString(resourceBundleWrapper, HEADER_TEXT);
        this.theSubHeaderText = Utils.getResourceString(resourceBundleWrapper, SUBHEADER_TEXT);
        this.theActionDialogTitle = Utils.getResourceString(resourceBundleWrapper, DIALOG_TITLE);
        this.theCloseButtonLabel = Utils.getResourceString(resourceBundleWrapper, CLOSE_LABEL);
        this.theOKButtonLabel = Utils.getResourceString(resourceBundleWrapper, OK_LABEL);
        this.theCancelButtonLabel = Utils.getResourceString(resourceBundleWrapper, CANCEL_LABEL);
        this.duplicateNameErrorText = Utils.getResourceString(resourceBundleWrapper, DUPLICATE_NAME_ERROR);
        this.requiredFieldError = Utils.getResourceString(resourceBundleWrapper, REQUIRED_FIELD_ERROR);
        this.rangeValidationError = Utils.getResourceString(resourceBundleWrapper, RANGE_VALIDATION_ERROR);
        this.credentialValidationError = Utils.getResourceString(resourceBundleWrapper, CREDENTIALS_VALIDATION_ERROR);
        this.invalidCommandFileError = Utils.getResourceString(resourceBundleWrapper, INVALID_CMD_FILE_ERROR);
        this.invalidSSHKeyFileError = Utils.getResourceString(resourceBundleWrapper, INVALID_SSH_FILE_ERROR);
        this.readFailError = Utils.getResourceString(resourceBundleWrapper, READ_FAIL_ERROR);
        this.createFailError = Utils.getResourceString(resourceBundleWrapper, CREATE_FAIL_ERROR);
        this.editFailError = Utils.getResourceString(resourceBundleWrapper, EDIT_FAIL_ERROR);
        this.deleteFailError = Utils.getResourceString(resourceBundleWrapper, DELETE_FAIL_ERROR);
        this.invalidHostError = Utils.getResourceString(resourceBundleWrapper, INVALID_HOSTNAME_ERROR);
        this.invalidCharacters = Utils.getResourceString(resourceBundleWrapper, INVALID_CHARACTERS);
    }

    private HTML createResourceStrings() {
        Division division = new Division();
        division.setId("jsres");
        Span span = new Span(this.theActionDialogTitle);
        span.setId("resActionDialogTitle");
        division.add(span);
        span = new Span(this.theCloseButtonLabel);
        span.setId("resCloseButton");
        division.add(span);
        span = new Span(this.theOKButtonLabel);
        span.setId("resOKButton");
        division.add(span);
        span = new Span(this.theCancelButtonLabel);
        span.setId("resCancelButton");
        division.add(span);
        span = new Span(this.duplicateNameErrorText);
        span.setId("resActionNameInUse");
        division.add(span);
        span = new Span(this.requiredFieldError);
        span.setId("resRequiredField");
        division.add(span);
        span = new Span(this.rangeValidationError);
        span.setId("resRangeValidation");
        division.add(span);
        span = new Span(this.credentialValidationError);
        span.setId("resCredentialsGiven");
        division.add(span);
        span = new Span(this.invalidCommandFileError);
        span.setId("resInvalidCommandFile");
        division.add(span);
        span = new Span(this.invalidSSHKeyFileError);
        span.setId("resInvalidSSHKeyFile");
        division.add(span);
        span = new Span(this.readFailError);
        span.setId("resReadFailError");
        division.add(span);
        span = new Span(this.createFailError);
        span.setId("resCreateFailError");
        division.add(span);
        span = new Span(this.editFailError);
        span.setId("resEditFailError");
        division.add(span);
        span = new Span(this.deleteFailError);
        span.setId("resDeleteFailError");
        division.add(span);
        span = new Span(this.invalidHostError);
        span.setId("resInvalidHostError");
        division.add(span);
        span = new Span(this.invalidCharacters);
        span.setId("resInvalidCharacters");
        division.add(span);
        return division;
    }
}

