/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.pages.actions;

import com.apcc.m11.arch.VariableBinding;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.Text;
import com.apcc.m11.components.webserver.html.apc.ApcForm;
import com.apcc.m11.components.webserver.html.apc.ApcHelp;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.html.document.Span;
import com.apcc.m11.components.webserver.pages.actions.Action;
import com.apcc.m11.components.webserver.util.FormHelper;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.m11.ds.services.eventlogginggroup.EventLoggingGroup;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.util.Locale;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LogEventAction
extends Action {
    private static final Logger logger = LogManager.getLogger(LogEventAction.class);
    private static final String kHeaderId = "LogEventAction.Header";
    private static final String kSubHeaderId = "LogEventAction.SubHeader";
    private static final String kEnableId = "LogEventAction.Enable";
    private static final String kApplyButton = "PCNS.ApplyButton";
    private static final String kCancelButton = "PCNS.CancelButton";
    private static final String kEventName = "PCNS.EventNameLabel";
    private static final String kWaitTitle = "PCNS.WaitTitle";
    private static final String kWaitText = "PCNS.WaitText";
    public static final String kEnableCheckboxName = "Enable";
    private Division thePage = new Division();
    private String theHeaderText;
    private String theSubHeaderText;
    private String theEnableText;
    private String theApplyButtonText;
    private String theCancelButtonText;
    private String theEventNameText;
    private String theWaitTitle;
    private String theWaitText;
    private String theEventName = "";
    private Boolean logEnabled = false;

    @Override
    public StringBuilder toHTML(PageContext pageContext) {
        this.setupLanguage(pageContext.getLocale());
        this.setup(pageContext);
        return this.thePage.toHTML(pageContext);
    }

    @Override
    public void refresh(PageContext pageContext) {
        this.logEnabled = false;
        this.theEventName = (String)pageContext.getValue("EventName");
        Vector vector = (Vector)pageContext.get(EventLoggingGroup.ListOfEventsToLog.getObjectId());
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                VariableBinding variableBinding = (VariableBinding)vector.elementAt(i);
                if (variableBinding == null || !this.theEvent.getObjectId().equals((Object)variableBinding.getObjectId())) continue;
                this.logEnabled = true;
                break;
            }
        }
    }

    private void setup(PageContext pageContext) {
        Span span = new Span(this.theHeaderText);
        span.setId("resActionName");
        span.setCssClass("hidden");
        this.thePage.add(span);
        this.thePage.add(this.createHelpSpan(ApcHelp.VIEWING_THE_EVENT_LOG1));
        Division division = new Division();
        division.setCssClass("waitDialog");
        division.setId("waitDialog");
        division.setTitle(this.theWaitTitle);
        division.add(new Text(this.theWaitText));
        this.thePage.add(division);
        ApcForm apcForm = new ApcForm("LogEvent", "/cfglogevent");
        apcForm.setId("Log");
        this.thePage.add(apcForm);
        Division division2 = new Division();
        division2.setId("maindiv");
        division2.setCssClass("formdiv");
        apcForm.add(division2);
        division2.add(FormHelper.createLabelValueDiv(null, this.theEventNameText, this.theEventName, null));
        division2.add(FormHelper.createLabelCheckboxValueDiv("logEnableCheckboxDiv", this.theEnableText, this.logEnabled, null, kEnableCheckboxName));
        apcForm.add(this.getHiddenEventNameField());
        pageContext.addFormToken(apcForm);
    }

    private void setupLanguage(Locale locale) {
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        this.theHeaderText = Utils.getResourceString(resourceBundleWrapper, kHeaderId);
        this.theSubHeaderText = Utils.getResourceString(resourceBundleWrapper, kSubHeaderId);
        this.theEnableText = Utils.getResourceString(resourceBundleWrapper, kEnableId);
        this.theApplyButtonText = Utils.getResourceString(resourceBundleWrapper, kApplyButton);
        this.theCancelButtonText = Utils.getResourceString(resourceBundleWrapper, kCancelButton);
        this.theEventNameText = Utils.getResourceString(resourceBundleWrapper, kEventName);
        this.theWaitTitle = Utils.getResourceString(resourceBundleWrapper, kWaitTitle);
        this.theWaitText = Utils.getResourceString(resourceBundleWrapper, kWaitText);
    }
}

