/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.pages.actions;

import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.Text;
import com.apcc.m11.components.webserver.html.apc.ApcForm;
import com.apcc.m11.components.webserver.html.apc.ApcHelp;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.html.document.Span;
import com.apcc.m11.components.webserver.html.form.TextInput;
import com.apcc.m11.components.webserver.pages.actions.Action;
import com.apcc.m11.components.webserver.util.FormHelper;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.m11.ds.services.messageBroadcastGroup.AllRecipients;
import com.apcc.m11.ds.services.messageBroadcastGroup.ListOfNotificationRecipients;
import com.apcc.m11.ds.services.messageBroadcastGroup.Recipient;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NotifyUsersAction
extends Action {
    private static final Logger logger = LogManager.getLogger(NotifyUsersAction.class);
    public static final String kNotifyAll = "NotifyAll";
    public static final String kNotifySpecificUser = "NotifySpecificUser";
    private static final String kSectionHeaderId = "Notifier.Header";
    private static final String kSubSectionHeaderId = "Notifier.SubHeader";
    private static final String kEnableId = "Notifier.Enable";
    private static final String kDelayId = "Notifier.Delay";
    private static final String kNotifyAllId = "Notifier.All";
    private static final String kNotifySpecificUserId = "Notifier.Specific";
    private static final String kIntervalId = "Notifier.Interval";
    private static final String kEventName = "PCNS.EventNameLabel";
    private static final String kSecondsUnit = "PCNS.SecondsUnitLabel";
    private static final String kApplyButton = "PCNS.ApplyButton";
    private static final String kCancelButton = "PCNS.CancelButton";
    private static final String kRangeValidation = "PCNS.RangeValidation";
    private static final String kRequiredField = "PCNS.RequiredField";
    private static final String kWaitTitle = "PCNS.WaitTitle";
    private static final String kWaitText = "PCNS.WaitText";
    public static final String kEnableCheckboxName = "Enable";
    public static final String kNotifyRadioButtonGroupName = "Notify";
    public static final String kDelayName = "Delay";
    public static final String kNotifySpecificUserName = "User";
    public static final String kNotifyIntervalName = "Interval";
    private Division thePage = new Division();
    private String theSectionHeaderText;
    private String theSubSectionHeaderText;
    private String theEnableText;
    private String theDelayText;
    private String theNotifyAllText;
    private String theNotifySpecificUserText;
    private String theIntervalText;
    private String theEventNameText;
    private String theSecondsUnitLabelText;
    private String theApplyButtonText;
    private String theCancelButtonText;
    private String theRequiredFieldValidationText;
    private String theRangeValidationText;
    private String theWaitTitle;
    private String theWaitText;
    private String theEventName = "";
    Boolean notifyEnable = false;
    Boolean notifyAll = true;
    String notifyUser;
    Integer notifyDelay = 0;
    Integer notifyInterval = 0;

    @Override
    public void refresh(PageContext pageContext) {
        String string;
        String string2 = AllRecipients.kOid.toString();
        this.theEventName = (String)pageContext.getValue("EventName");
        this.notifyEnable = false;
        this.notifyAll = true;
        this.notifyUser = "";
        this.notifyDelay = 0;
        this.notifyInterval = 0;
        Hashtable hashtable = (Hashtable)pageContext.get(ListOfNotificationRecipients.kOid);
        if (hashtable != null && hashtable.containsKey(string = this.theEvent.getObjectId().toString())) {
            this.notifyEnable = true;
            Vector vector = (Vector)hashtable.get(string);
            if (vector != null) {
                Recipient recipient = (Recipient)vector.firstElement();
                this.notifyAll = recipient.getAddress().equals(string2);
                if (!this.notifyAll.booleanValue()) {
                    this.notifyUser = recipient.getAddress();
                }
                this.notifyDelay = recipient.getInitialDelay();
                this.notifyInterval = recipient.getPeriodicInterval();
            }
        }
    }

    @Override
    public StringBuilder toHTML(PageContext pageContext) {
        this.setupLanguage(pageContext.getLocale());
        this.setup(pageContext);
        return this.thePage.toHTML(pageContext);
    }

    private void setup(PageContext pageContext) {
        Span span = new Span(this.theSectionHeaderText);
        span.setId("resActionName");
        span.setCssClass("hidden");
        this.thePage.add(span);
        this.thePage.add(this.createHelpSpan(ApcHelp.NOTIFY_USER_ACTION1));
        Division division = new Division();
        division.setCssClass("waitDialog");
        division.setId("waitDialog");
        division.setTitle(this.theWaitTitle);
        division.add(new Text(this.theWaitText));
        this.thePage.add(division);
        ApcForm apcForm = new ApcForm("NotifyUsers", "/cfgnotifyusers?OID=" + this.theEvent.getObjectId().toString() + "&Action=NotifyUsers");
        apcForm.setId("NotifyUsers");
        this.thePage.add(apcForm);
        Division division2 = new Division();
        division2.setId("maindiv");
        division2.setCssClass("formdiv");
        apcForm.add(division2);
        division2.add(FormHelper.createLabelValueDiv(null, this.theEventNameText, this.theEventName, null));
        division2.add(FormHelper.createLabelCheckboxValueDiv("notifyEnableCheckboxDiv", this.theEnableText, this.notifyEnable, null, kEnableCheckboxName));
        Division division3 = new Division();
        division3.setId("settingsdiv");
        division2.add(division3);
        division3.add(FormHelper.createLabelTextInputValueDiv("notifyDelayInputDiv", this.theDelayText, this.notifyDelay.toString(), null, kDelayName, null, 4, null, this.theSecondsUnitLabelText));
        division3.add(FormHelper.createLabelRadioButtonValueDiv(null, this.theNotifyAllText, kNotifyAll, this.notifyAll, null, kNotifyRadioButtonGroupName));
        Division division4 = FormHelper.createLabelRadioButtonValueDiv(null, this.theNotifySpecificUserText, kNotifySpecificUser, this.notifyAll == false, null, kNotifyRadioButtonGroupName);
        division3.add(division4);
        Span span2 = new Span();
        division4.add(span2);
        span2.setCssClass("value");
        TextInput textInput = new TextInput(kNotifySpecificUserName);
        span2.add(textInput);
        textInput.setValue(this.notifyUser);
        textInput.setSize("24");
        textInput.setMaxLength("128");
        division3.add(FormHelper.createLabelTextInputValueDiv("notifyIntervalInputDiv", this.theIntervalText, this.notifyInterval.toString(), null, kNotifyIntervalName, null, 4, null, this.theSecondsUnitLabelText));
        apcForm.add(this.getHiddenEventNameField());
        pageContext.addFormToken(apcForm);
        this.thePage.add(this.createResourceStrings());
    }

    private Division createResourceStrings() {
        Division division = new Division();
        division.setId("jsres");
        Span span = new Span(this.theRequiredFieldValidationText);
        span.setId("resRequiredFieldValidation");
        division.add(span);
        span = new Span(this.theRangeValidationText);
        span.setId("resRangeValidation");
        division.add(span);
        return division;
    }

    private void setupLanguage(Locale locale) {
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        this.theSectionHeaderText = Utils.getResourceString(resourceBundleWrapper, kSectionHeaderId);
        this.theSubSectionHeaderText = Utils.getResourceString(resourceBundleWrapper, kSubSectionHeaderId);
        this.theEnableText = Utils.getResourceString(resourceBundleWrapper, kEnableId);
        this.theDelayText = Utils.getResourceString(resourceBundleWrapper, kDelayId);
        this.theNotifyAllText = Utils.getResourceString(resourceBundleWrapper, kNotifyAllId);
        this.theNotifySpecificUserText = Utils.getResourceString(resourceBundleWrapper, kNotifySpecificUserId);
        this.theIntervalText = Utils.getResourceString(resourceBundleWrapper, kIntervalId);
        this.theEventNameText = Utils.getResourceString(resourceBundleWrapper, kEventName);
        this.theApplyButtonText = Utils.getResourceString(resourceBundleWrapper, kApplyButton);
        this.theCancelButtonText = Utils.getResourceString(resourceBundleWrapper, kCancelButton);
        this.theRequiredFieldValidationText = Utils.getResourceString(resourceBundleWrapper, kRequiredField);
        this.theRangeValidationText = Utils.getResourceString(resourceBundleWrapper, kRangeValidation);
        this.theSecondsUnitLabelText = Utils.getResourceString(resourceBundleWrapper, kSecondsUnit);
        this.theWaitTitle = Utils.getResourceString(resourceBundleWrapper, kWaitTitle);
        this.theWaitText = Utils.getResourceString(resourceBundleWrapper, kWaitText);
    }
}

