/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.pages.actions;

import com.apcc.m11.arch.FormatterException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.UnsupportedLocaleException;
import com.apcc.m11.components.omaha.flexeventdescriptors.RunTimeRemainingDescriptor;
import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.Text;
import com.apcc.m11.components.webserver.html.apc.ApcForm;
import com.apcc.m11.components.webserver.html.apc.ApcHelp;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.html.document.Span;
import com.apcc.m11.components.webserver.pages.actions.Action;
import com.apcc.m11.components.webserver.util.FormHelper;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.m11.ds.events.flexevents.RuntimeVerifierEvents;
import com.apcc.m11.ds.services.commandExecution.CommandExecution;
import com.apcc.m11.ds.services.commandExecution.CommandFile;
import com.apcc.m11.ds.services.omaha.IFlexParamEventDescriptor;
import com.apcc.pcns.configservice.validation.UserFilePathValidator;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RunCommandFileAction
extends Action {
    private static final Logger logger = LogManager.getLogger(RunCommandFileAction.class);
    private static final String kRunCommandFileError = "RunCommandFile.ErrorText";
    private static final String kSectionHeaderId = "RunCommandFile.Header";
    private static final String kSubSectionHeaderId = "RunCommandFile.SubHeader";
    private static final String kEnableId = "RunCommandFile.EnableCommand";
    private static final String kCommandId = "RunCommandFile.RunCommand";
    private static final String CMD_PATH_TOOLTIP = "RunCommandFile.CmdPathTooltip";
    private static final String kDelayId = "RunCommandFile.Delay";
    private static final String kIntervalId = "RunCommandFile.AllottedTime";
    private static final String kSecondsUnit = "RunCommandFile.SecondsUnitLabel";
    private static final String kInvalidCmdFile = "RunCommandFile.InvalidCommandFile";
    private static final String kEventName = "PCNS.EventNameLabel";
    private static final String kApplyButton = "PCNS.ApplyButton";
    private static final String kCancelButton = "PCNS.CancelButton";
    private static final String kRangeValidation = "PCNS.RangeValidation";
    private static final String kRequiredField = "PCNS.RequiredField";
    private static final String kWaitTitle = "PCNS.WaitTitle";
    private static final String kWaitText = "PCNS.WaitText";
    private static final String VALUE_INVALID_CMDFILE = "cmdfile_invalid";
    public static final String kEnableCheckboxName = "Enable";
    public static final String kCommandName = "cmdFilePath";
    public static final String kDelayName = "Delay";
    public static final String kIntervalName = "Interval";
    private Division thePage = new Division();
    private String theEventName = "";
    private String theSectionHeaderText;
    private String theSubSectionHeaderText;
    private String theEventNameText;
    private String theEnableText;
    private String theCommandText;
    private String theCmdFilePathTooltip;
    private String theDelayText;
    private String theIntervalText;
    private String theParamName;
    private String theParamValue;
    private Boolean cmdFileEnabled = false;
    private Integer cmdFileDelay = 0;
    private String cmdFilePath = "";
    private String theSecondsUnitLabelText;
    private String theApplyButtonText;
    private String theCancelButtonText;
    private String theRequiredFieldValidationText;
    private String theRangeValidationText;
    private String theInvalidCmdFileText;
    private String theRunCommandFileErrorText;
    private String theWaitTitle;
    private String theWaitText;

    @Override
    public void refresh(PageContext pageContext) {
        CommandFile commandFile;
        Vector vector;
        Hashtable hashtable;
        this.cmdFileEnabled = false;
        this.cmdFileDelay = 0;
        this.cmdFilePath = "";
        this.theEventName = (String)pageContext.getValue("EventName");
        ObjectId objectId = this.theEvent.getObjectId();
        if (objectId.equals((Object)RuntimeVerifierEvents.RunTimeRemaining.getObjectId())) {
            objectId = RuntimeVerifierEvents.RunTimeRemainingCmdFile.getObjectId();
        }
        if ((hashtable = (Hashtable)pageContext.get(CommandExecution.ListOfCommandObjects.getObjectId())) != null && (vector = (Vector)hashtable.get(objectId.toString())) != null && (commandFile = (CommandFile)vector.firstElement()) != null) {
            this.cmdFileEnabled = true;
            this.cmdFileDelay = commandFile.getInitialDelay();
            this.cmdFilePath = commandFile.getPath();
            UserFilePathValidator userFilePathValidator = new UserFilePathValidator();
            pageContext.setValue(VALUE_INVALID_CMDFILE, !userFilePathValidator.isValid(this.cmdFilePath, true));
        }
    }

    @Override
    public StringBuilder toHTML(PageContext pageContext) {
        this.setupLanguage(pageContext.getLocale());
        if (this.theEvent instanceof IFlexParamEventDescriptor) {
            try {
                IFlexParamEventDescriptor iFlexParamEventDescriptor = (IFlexParamEventDescriptor)this.theEvent;
                this.theParamName = iFlexParamEventDescriptor.getParamFormatter().format((Object)this, pageContext.getLocale());
                Object object = null;
                object = this.theEvent instanceof RunTimeRemainingDescriptor ? pageContext.get(((RunTimeRemainingDescriptor)iFlexParamEventDescriptor).getCmdFileThresholdParamObjectId()) : pageContext.get(iFlexParamEventDescriptor.getParamObjectId());
                if (object instanceof String) {
                    this.theParamValue = (String)object;
                } else if (object instanceof Integer) {
                    this.theParamValue = ((Integer)object).toString();
                }
            }
            catch (FormatterException formatterException) {
                logger.error((Object)formatterException);
            }
            catch (UnsupportedLocaleException unsupportedLocaleException) {
                logger.error((Object)unsupportedLocaleException);
            }
        }
        this.setup(pageContext);
        return this.thePage.toHTML(pageContext);
    }

    private void setup(PageContext pageContext) {
        Object object;
        Division division;
        Span span = new Span(this.theSectionHeaderText);
        span.setId("resActionName");
        span.setCssClass("hidden");
        this.thePage.add(span);
        this.thePage.add(this.createHelpSpan(ApcHelp.RUN_COMMAND_FILE_ACTION1));
        Division division2 = new Division();
        division2.setCssClass("waitDialog");
        division2.setId("waitDialog");
        division2.setTitle(this.theWaitTitle);
        division2.add(new Text(this.theWaitText));
        this.thePage.add(division2);
        ApcForm apcForm = new ApcForm("RunCommandFile", "/cfgruncmdfile?OID=" + this.theEvent.getObjectId().toString() + "&Action=RunCommandFile");
        apcForm.setId("RunCommandFile");
        this.thePage.add(apcForm);
        if (this.theError != null) {
            division = new Division();
            division.setId("errorcontainer");
            division.add(new Text(this.theError));
            division.setCssClass("ui-state-error ui-corner-all");
            apcForm.add(division);
        }
        division = new Division();
        division.setId("maindiv");
        division.setCssClass("formdiv");
        apcForm.add(division);
        division.add(FormHelper.createLabelValueDiv(null, this.theEventNameText, this.theEventName, null));
        division.add(FormHelper.createLabelCheckboxValueDiv("cmdFileEnableCheckboxDiv", this.theEnableText, this.cmdFileEnabled, null, kEnableCheckboxName));
        Division division3 = new Division();
        division3.setId("settingsdiv");
        division.add(division3);
        if (this.theEvent instanceof IFlexParamEventDescriptor) {
            object = FormHelper.createLabelTextInputValueDiv("paramInputDiv", this.theParamName, this.theParamValue, null, "paramValue", null, 6, null, this.theSecondsUnitLabelText);
            division3.add((HTML)object);
        }
        if (!(this.theEvent instanceof RunTimeRemainingDescriptor)) {
            division3.add(FormHelper.createLabelTextInputValueDiv("cmdFileDelayInputDiv", this.theDelayText, this.cmdFileDelay.toString(), null, kDelayName, null, 6, null, this.theSecondsUnitLabelText));
        }
        division3.add(FormHelper.createLabelTextInputValueDiv("cmdFilePathInputDiv", this.theCommandText, this.cmdFilePath, null, kCommandName, "validcmd", (Integer)255, (Integer)40, null, this.theCmdFilePathTooltip));
        object = (Boolean)pageContext.getValue(VALUE_INVALID_CMDFILE);
        if (object != null && ((Boolean)object).booleanValue()) {
            Division division4 = new Division();
            division4.setId(VALUE_INVALID_CMDFILE);
            division4.setCssClass("hidden");
            division3.add(division4);
        }
        apcForm.add(this.getHiddenEventNameField());
        pageContext.addFormToken(apcForm);
        this.thePage.add(this.createResourceStrings());
    }

    private Division createResourceStrings() {
        Division division = new Division();
        division.setId("jsres");
        Span span = new Span(this.theRequiredFieldValidationText);
        span.setId("resRequiredFieldValidation");
        division.add(span);
        span = new Span(this.theRangeValidationText);
        span.setId("resRangeValidation");
        division.add(span);
        span = new Span(this.theInvalidCmdFileText);
        span.setId("resInvalidCmdFile");
        division.add(span);
        return division;
    }

    private void setupLanguage(Locale locale) {
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        this.theSectionHeaderText = Utils.getResourceString(resourceBundleWrapper, kSectionHeaderId);
        this.theSubSectionHeaderText = Utils.getResourceString(resourceBundleWrapper, kSubSectionHeaderId);
        this.theEnableText = Utils.getResourceString(resourceBundleWrapper, kEnableId);
        this.theCommandText = Utils.getResourceString(resourceBundleWrapper, kCommandId);
        this.theCmdFilePathTooltip = Utils.getResourceString(resourceBundleWrapper, CMD_PATH_TOOLTIP);
        this.theDelayText = Utils.getResourceString(resourceBundleWrapper, kDelayId);
        this.theIntervalText = Utils.getResourceString(resourceBundleWrapper, kIntervalId);
        this.theEventNameText = Utils.getResourceString(resourceBundleWrapper, kEventName);
        this.theSecondsUnitLabelText = Utils.getResourceString(resourceBundleWrapper, kSecondsUnit);
        this.theApplyButtonText = Utils.getResourceString(resourceBundleWrapper, kApplyButton);
        this.theCancelButtonText = Utils.getResourceString(resourceBundleWrapper, kCancelButton);
        this.theInvalidCmdFileText = Utils.getResourceString(resourceBundleWrapper, kInvalidCmdFile);
        this.theRequiredFieldValidationText = Utils.getResourceString(resourceBundleWrapper, kRequiredField);
        this.theRangeValidationText = Utils.getResourceString(resourceBundleWrapper, kRangeValidation);
        this.theRunCommandFileErrorText = Utils.getResourceString(resourceBundleWrapper, kRunCommandFileError);
        this.theWaitTitle = Utils.getResourceString(resourceBundleWrapper, kWaitTitle);
        this.theWaitText = Utils.getResourceString(resourceBundleWrapper, kWaitText);
    }
}

