/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.pages.actions;

import com.apcc.m11.arch.FormatterException;
import com.apcc.m11.arch.UnsupportedLocaleException;
import com.apcc.m11.arch.VariableBinding;
import com.apcc.m11.components.omaha.flexeventdescriptors.RunTimeRemainingDescriptor;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.Text;
import com.apcc.m11.components.webserver.html.apc.ApcForm;
import com.apcc.m11.components.webserver.html.apc.ApcHelp;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.html.document.Span;
import com.apcc.m11.components.webserver.pages.actions.Action;
import com.apcc.m11.components.webserver.servlets.M11Servlet;
import com.apcc.m11.components.webserver.util.FormHelper;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.m11.ds.events.flexevents.EventLists;
import com.apcc.m11.ds.services.ShutdownGroup;
import com.apcc.m11.ds.services.omaha.IFlexParamEventDescriptor;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.util.Locale;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShutdownAction
extends Action {
    private static final Logger logger = LogManager.getLogger(ShutdownAction.class);
    private static final String kSectionHeaderId = "Shutdown.Header";
    private static final String kSectionHeader2Id = "Shutdown.Header2";
    private static final String kSubSectionHeaderId = "Shutdown.SubHeader";
    private static final String kSubSectionHeader2Id = "Shutdown.SubHeader2";
    private static final String kEnableId = "Shutdown.Enable";
    private static final String kEnable2Id = "Shutdown.Enable2";
    private static final String kDelayId = "Shutdown.Delay";
    private static final String kDelay2Id = "Shutdown.Delay2";
    private static final String kEventName = "PCNS.EventNameLabel";
    private static final String kSecondsUnit = "PCNS.SecondsUnitLabel";
    private static final String kApplyButton = "PCNS.ApplyButton";
    private static final String kCancelButton = "PCNS.CancelButton";
    private static final String kRangeValidation = "PCNS.RangeValidation";
    private static final String kRequiredField = "PCNS.RequiredField";
    private static final String kWaitTitle = "PCNS.WaitTitle";
    private static final String kWaitText = "PCNS.WaitText";
    public static final String kEnableCheckboxName = "Enable";
    public static final String kDelayName = "Delay";
    private Division thePage = new Division();
    private String theEventName = "";
    private String theSectionHeaderText;
    private String theSectionHeader2Text;
    private String theSubSectionHeaderText;
    private String theSubSectionHeader2Text;
    private String theParamName;
    private String theParamValue;
    private String theParamUnits;
    private String theEnableText;
    private String theEnable2Text;
    private String theDelayText;
    private String theDelay2Text;
    private String theEventNameText;
    private String theSecondsUnitLabelText;
    private String theApplyButtonText;
    private String theCancelButtonText;
    private String theRequiredFieldValidationText;
    private String theRangeValidationText;
    private String theWaitTitle;
    private String theWaitText;
    private Boolean shutdownEnabled = false;
    private Integer shutdownDelay = 0;

    @Override
    public StringBuilder toHTML(PageContext pageContext) {
        this.setupLanguage(pageContext.getLocale());
        if (this.theEvent instanceof IFlexParamEventDescriptor) {
            try {
                IFlexParamEventDescriptor iFlexParamEventDescriptor = (IFlexParamEventDescriptor)this.theEvent;
                this.theParamName = iFlexParamEventDescriptor.getParamFormatter().format((Object)this, pageContext.getLocale());
                Object object = pageContext.get(iFlexParamEventDescriptor.getParamObjectId());
                if (object instanceof String) {
                    this.theParamValue = (String)object;
                } else if (object instanceof Integer) {
                    this.theParamValue = ((Integer)object).toString();
                }
            }
            catch (FormatterException formatterException) {
                logger.error((Object)formatterException);
            }
            catch (UnsupportedLocaleException unsupportedLocaleException) {
                logger.error((Object)unsupportedLocaleException);
            }
        }
        this.setup(pageContext);
        return this.thePage.toHTML(pageContext);
    }

    @Override
    public void refresh(PageContext pageContext) {
        this.shutdownEnabled = false;
        this.shutdownDelay = EventLists.getDefaultShutdownDelay(EventLists.getEventNameForObjectId(this.theEvent.getObjectId()));
        this.theEventName = (String)pageContext.getValue("EventName");
        Vector vector = (Vector)pageContext.get(ShutdownGroup.ShutdownTriggers.getObjectId());
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                VariableBinding variableBinding = (VariableBinding)vector.elementAt(i);
                if (variableBinding == null || !variableBinding.getObjectId().equals((Object)this.theEvent.getObjectId())) continue;
                this.shutdownEnabled = true;
                Integer n = (Integer)variableBinding.getValue();
                if (n == null) break;
                this.shutdownDelay = n;
                break;
            }
        }
    }

    private void setup(PageContext pageContext) {
        Division division;
        String string;
        String string2;
        Span span = new Span(this.theSectionHeaderText);
        span.setId("resActionName");
        span.setCssClass("hidden");
        this.thePage.add(span);
        this.thePage.add(this.createHelpSpan(ApcHelp.SHUTDOWN_ACTIONS));
        if (M11Servlet.isSecondaryGroup()) {
            string2 = this.theEnableText;
            string = this.theDelayText;
        } else {
            string2 = this.theEnable2Text;
            string = this.theDelay2Text;
        }
        Division division2 = new Division();
        division2.setCssClass("waitDialog");
        division2.setId("waitDialog");
        division2.setTitle(this.theWaitTitle);
        division2.add(new Text(this.theWaitText));
        this.thePage.add(division2);
        ApcForm apcForm = new ApcForm("Shutdown", "/cfgshutdown?OID=" + this.theEvent.getObjectId().toString() + "&Action=Shutdown");
        apcForm.setId("Shutdown");
        this.thePage.add(apcForm);
        if (this.theError != null) {
            division = new Division();
            division.setId("errorcontainer");
            division.add(new Text(this.theError));
            division.setAttribute("style", "display:block");
            division.setCssClass("ui-state-error ui-corner-all");
            apcForm.add(division);
        }
        division = new Division();
        division.setId("maindiv");
        division.setCssClass("formdiv");
        apcForm.add(division);
        division.add(FormHelper.createLabelValueDiv(null, this.theEventNameText, this.theEventName, null));
        division.add(FormHelper.createLabelCheckboxValueDiv("shutdownEnableCheckboxDiv", string2, this.shutdownEnabled, null, kEnableCheckboxName));
        Division division3 = new Division();
        division3.setId("settingsdiv");
        division.add(division3);
        if (this.theEvent instanceof IFlexParamEventDescriptor) {
            Division division4 = FormHelper.createLabelTextInputValueDiv("paramInputDiv", this.theParamName, this.theParamValue, null, "paramValue", null, 6, null, this.theSecondsUnitLabelText);
            division3.add(division4);
        }
        if (!(this.theEvent instanceof RunTimeRemainingDescriptor)) {
            division3.add(FormHelper.createLabelTextInputValueDiv("shutdownDelayInputDiv", string, this.shutdownDelay.toString(), null, kDelayName, null, 6, null, this.theSecondsUnitLabelText));
        }
        apcForm.add(this.getHiddenEventNameField());
        pageContext.addFormToken(apcForm);
        this.thePage.add(this.createResourceStrings());
    }

    private Division createResourceStrings() {
        Division division = new Division();
        division.setId("jsres");
        Span span = new Span(this.theRequiredFieldValidationText);
        span.setId("resRequiredFieldValidation");
        division.add(span);
        span = new Span(this.theRangeValidationText);
        span.setId("resRangeValidation");
        division.add(span);
        return division;
    }

    private void setupLanguage(Locale locale) {
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        this.theSectionHeaderText = Utils.getResourceString(resourceBundleWrapper, kSectionHeaderId);
        this.theSectionHeader2Text = Utils.getResourceString(resourceBundleWrapper, kSectionHeader2Id);
        this.theSubSectionHeaderText = Utils.getResourceString(resourceBundleWrapper, kSubSectionHeaderId);
        this.theSubSectionHeader2Text = Utils.getResourceString(resourceBundleWrapper, kSubSectionHeader2Id);
        this.theEnableText = Utils.getResourceString(resourceBundleWrapper, kEnableId);
        this.theEnable2Text = Utils.getResourceString(resourceBundleWrapper, kEnable2Id);
        this.theDelayText = Utils.getResourceString(resourceBundleWrapper, kDelayId);
        this.theDelay2Text = Utils.getResourceString(resourceBundleWrapper, kDelay2Id);
        this.theEventNameText = Utils.getResourceString(resourceBundleWrapper, kEventName);
        this.theSecondsUnitLabelText = Utils.getResourceString(resourceBundleWrapper, kSecondsUnit);
        this.theApplyButtonText = Utils.getResourceString(resourceBundleWrapper, kApplyButton);
        this.theCancelButtonText = Utils.getResourceString(resourceBundleWrapper, kCancelButton);
        this.theRequiredFieldValidationText = Utils.getResourceString(resourceBundleWrapper, kRequiredField);
        this.theRangeValidationText = Utils.getResourceString(resourceBundleWrapper, kRangeValidation);
        this.theWaitTitle = Utils.getResourceString(resourceBundleWrapper, kWaitTitle);
        this.theWaitText = Utils.getResourceString(resourceBundleWrapper, kWaitText);
    }
}

