/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.pages.tables;

import com.apcc.m11.components.stdpowersource.OutletGroup;
import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.apc.ApcSection;
import com.apcc.m11.components.webserver.html.apc.ApcSectionLabel;
import com.apcc.m11.components.webserver.html.form.Option;
import com.apcc.m11.components.webserver.html.form.Select;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IpOutletTable
implements HTML {
    public static final String SELECT_NAME_PREFIX = "GroupFor";
    private static final Logger logger = LogManager.getLogger(IpOutletTable.class);
    public static final String OUTLET_FORMAT_KEY = "{0} - {1} : {2}";
    public static final String OUTLET_STATE_ON_KEY = "OutletState.On";
    public static final String OUTLET_STATE_OFF_KEY = "OutletState.Off";
    public static final String OUTLET_STATE_FIXED_KEY = "OutletState.Fixed";
    public static final String OUTLET_STATE_UNKNOWN_KEY = "OutletState.Unknown";
    public static final String OUTLET_STATE_PENDING_OFF_KEY = "OutletState.PendingOff";
    public static final String IP_SECTION_LABEL_KEY = "Configure.IPAddress";
    public static final String OUTLET_SECTION_LABEL_KEY = "Configure.OutletGroupLabel";
    public static final String NO_OUTLET_KEY = "Configure.NoOutlet";
    private ResourceBundleWrapper bundle;

    public IpOutletTable(Locale locale) {
        this.bundle = Utils.getWebServerResourceBundle(locale);
    }

    private Select createSelect(ArrayList<OutletGroup> arrayList, String string) {
        Select select = new Select(string);
        for (OutletGroup outletGroup : arrayList) {
            String string2 = String.valueOf(outletGroup.getGroupNumber());
            String string3 = this.formatOutletGroup(outletGroup);
            Option option = new Option(string2, string3);
            option.setSelected(outletGroup.isSelected());
            select.add(option);
        }
        return select;
    }

    @Override
    public StringBuilder toHTML(PageContext pageContext) {
        Map map = (Map)pageContext.getValue("OutletGroupList");
        ApcSection apcSection = new ApcSection();
        if (map != null) {
            if (map.size() > 1) {
                ApcSectionLabel apcSectionLabel = new ApcSectionLabel(Utils.getResourceString(this.bundle, IP_SECTION_LABEL_KEY));
                ApcSectionLabel object = new ApcSectionLabel(Utils.getResourceString(this.bundle, OUTLET_SECTION_LABEL_KEY));
                apcSection.add(apcSectionLabel, object);
            }
            for (Map.Entry entry : map.entrySet()) {
                HTML hTML;
                String string = (String)entry.getKey();
                ArrayList arrayList = (ArrayList)entry.getValue();
                ApcSectionLabel apcSectionLabel = new ApcSectionLabel(string);
                if (arrayList != null && !arrayList.isEmpty()) {
                    hTML = this.createSelect(arrayList, SELECT_NAME_PREFIX + string);
                    apcSection.add(apcSectionLabel, hTML);
                    continue;
                }
                hTML = new ApcSectionLabel(Utils.getResourceString(this.bundle, NO_OUTLET_KEY));
                apcSection.add(apcSectionLabel, hTML);
            }
        }
        return apcSection.toHTML(pageContext);
    }

    public String formatOutletState(int n) {
        String string = Utils.getResourceString(this.bundle, OUTLET_STATE_UNKNOWN_KEY);
        switch (n) {
            case 1: {
                string = Utils.getResourceString(this.bundle, OUTLET_STATE_ON_KEY);
                break;
            }
            case 0: {
                string = Utils.getResourceString(this.bundle, OUTLET_STATE_OFF_KEY);
                break;
            }
            case 2: {
                string = Utils.getResourceString(this.bundle, OUTLET_STATE_FIXED_KEY);
                break;
            }
            case 3: {
                string = Utils.getResourceString(this.bundle, OUTLET_STATE_PENDING_OFF_KEY);
                break;
            }
            case 4: {
                string = Utils.getResourceString(this.bundle, OUTLET_STATE_UNKNOWN_KEY);
                break;
            }
            default: {
                string = Utils.getResourceString(this.bundle, OUTLET_STATE_UNKNOWN_KEY);
            }
        }
        return string;
    }

    private String formatOutletGroup(OutletGroup outletGroup) {
        Object[] objectArray = new Object[]{outletGroup.getGroupNumber(), outletGroup.getName(), this.formatOutletState(outletGroup.getState())};
        return MessageFormat.format(OUTLET_FORMAT_KEY, objectArray);
    }
}

