/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.servlets;

import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.Text;
import com.apcc.m11.components.webserver.html.apc.ApcHelp;
import com.apcc.m11.components.webserver.html.apc.ApcSectionHeader;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.html.document.Span;
import com.apcc.m11.components.webserver.html.form.Button;
import com.apcc.m11.components.webserver.html.form.Option;
import com.apcc.m11.components.webserver.servlets.AJAXServlet;
import com.apcc.m11.components.webserver.util.FormHelper;
import com.apcc.m11.components.webserver.util.JREUtils;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.util.OSVersionInfo;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletException;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AJAXAbout
extends AJAXServlet {
    private static final Logger logger = LogManager.getLogger(AJAXAbout.class);
    private static final long serialVersionUID = -8268519436105280407L;

    public AJAXAbout(ServiceManager serviceManager) {
        super(serviceManager);
    }

    @Override
    protected void doGet(PageContext pageContext) throws ServletException, IOException {
        pageContext.getResponse().setContentType("application/json");
        Locale locale = pageContext.getLocale();
        Division division = new Division();
        ApcSectionHeader apcSectionHeader = new ApcSectionHeader(this.getText(locale, "About.ProductVersionHeader"), null);
        apcSectionHeader.setHelpId(ApcHelp.JAVA_UPDATE);
        division.add(apcSectionHeader);
        division.add(FormHelper.createLabelValueDiv("pcnsVersion", this.getText(locale, "About.PCNSVersion"), this.services.getProductVersion().getVersion(), null));
        division.add(FormHelper.createLabelValueDiv("pcnsBuild", this.getText(locale, "About.BuildNumber"), this.services.getProductVersion().getBuildTag(), null));
        this.addOperatingSystemDetails(locale, division);
        this.addJavaDetails(locale, division);
        this.addJREUpgradePanel(locale, division);
        String string = this.getText(locale, "About.Copyright");
        string = MessageFormat.format(string, this.services.getProductVersion().getCopyrightYear());
        Division division2 = new Division();
        division2.setId("copyright");
        division2.add(new Text(string));
        division2.setCssClass("HelpDetails");
        division.add(division2);
        pageContext.getOutputWriter().print(division.toHTML(pageContext));
    }

    private void addJREUpgradePanel(@NonNull Locale locale, @NonNull Division division) {
        if (locale == null) {
            throw new IllegalArgumentException("l is marked non-null but is null");
        }
        if (division == null) {
            throw new IllegalArgumentException("details is marked non-null but is null");
        }
        if (SystemUtils.IS_OS_LINUX || SystemUtils.IS_OS_WINDOWS) {
            List<File> list = JREUtils.getAvailableJREUpdates();
            if (!list.isEmpty()) {
                Vector<Option> vector = new Vector<Option>();
                for (File object2 : list) {
                    vector.add(new Option(object2.getName()));
                }
                Division division2 = FormHelper.createLabelSelectValueDiv(null, this.getText(locale, "About.JavaUpdate"), "", "", "selectJRE", vector, null);
                Span span = (Span)division2.getContents().get(1);
                Button button = new Button();
                button.setId("jreUpdateid");
                button.setValue(this.getText(locale, "About.JavaUpgradeButton"));
                button.setOnClick("sendJREUpdatePost(event)");
                span.add(button);
                division.add(division2);
                Division division3 = new Division();
                division3.add(new Text(this.getText(locale, "About.JavaNote")));
                division3.setCssClass("ui-state-error ui-corner-all");
                division.add(division3);
                Division division4 = new Division();
                division4.setOption("hidden", "true");
                division4.setId("res");
                division4.add(new Span("resUpgradeConfirmA", this.getText(locale, "About.UpgradeConfirmA")));
                division4.add(new Span("resUpgradeConfirmB", this.getText(locale, "About.UpgradeConfirmB")));
                division4.add(new Span("resUpgradeRestarting", this.getText(locale, "About.UpgradeRestarting")));
                division4.add(new Span("resUpgradeCanceled", this.getText(locale, "About.UpgradeCanceled")));
                division.add(division4);
            }
        } else {
            logger.info("addJREUpgradePanel() - JRE Upgrade function disabled for OS: {}", (Object)SystemUtils.OS_NAME);
        }
    }

    private void addJavaDetails(@NonNull Locale locale, @NonNull Division division) {
        if (locale == null) {
            throw new IllegalArgumentException("l is marked non-null but is null");
        }
        if (division == null) {
            throw new IllegalArgumentException("details is marked non-null but is null");
        }
        String string = (String)StringUtils.defaultIfBlank((CharSequence)SystemUtils.JAVA_RUNTIME_NAME, (CharSequence)"");
        String string2 = (String)StringUtils.defaultIfBlank((CharSequence)SystemUtils.JAVA_RUNTIME_VERSION, (CharSequence)"");
        String string3 = (String)StringUtils.defaultIfBlank((CharSequence)SystemUtils.JAVA_VM_NAME, (CharSequence)"");
        String string4 = (String)StringUtils.defaultIfBlank((CharSequence)SystemUtils.JAVA_VM_VERSION, (CharSequence)"");
        String string5 = "{0} ({1})";
        String string6 = null;
        string6 = StringUtils.isNotBlank((CharSequence)string) ? MessageFormat.format(string5, string, string2) : MessageFormat.format(string5, string3, string4);
        division.add(FormHelper.createLabelValueDiv("java", this.getText(locale, "About.JavaVersion"), string6, null));
    }

    private void addOperatingSystemDetails(@NonNull Locale locale, @NonNull Division division) {
        if (locale == null) {
            throw new IllegalArgumentException("l is marked non-null but is null");
        }
        if (division == null) {
            throw new IllegalArgumentException("details is marked non-null but is null");
        }
        OSVersionInfo oSVersionInfo = OSVersionInfo.getOSVersionInfo();
        String string = MessageFormat.format("{0} {1} ({2})", StringUtils.defaultIfBlank((CharSequence)oSVersionInfo.getName(), (CharSequence)""), StringUtils.defaultIfBlank((CharSequence)oSVersionInfo.getEdition(), (CharSequence)""), StringUtils.defaultIfBlank((CharSequence)oSVersionInfo.getVersion(), (CharSequence)""));
        division.add(FormHelper.createLabelValueDiv("pcnsOS", this.getText(locale, "About.OS"), string, null));
    }

    private String getText(Locale locale, String string) {
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        return Utils.getResourceString(resourceBundleWrapper, string);
    }
}

