/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.servlets;

import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.servlets.AJAXServlet;
import com.apcc.m11.components.webserver.servlets.ConnectionStatus;
import com.apcc.m11.components.webserver.util.virtualization.nutanix.NutanixDetails;
import com.apcc.m11.components.webserver.util.virtualization.vmware.VMWareDetails;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.validation.UserFilePathValidator;
import com.apcc.pcns.hyperflex.HyperflexDetails;
import com.apcc.pcns.nutanixservice.NutanixConnection;
import com.apcc.pcns.nutanixservice.NutanixService;
import com.apcc.pcns.restservice.RestConnectionStatus;
import com.apcc.pcns.simplivity.SimplivityDetails;
import com.apcc.pcns.util.CountdownTimer;
import com.apcc.pcns.vxrail.VxRailDetails;
import com.github.cliftonlabs.json_simple.JsonObject;
import com.vmware.vim25.InvalidLogin;
import com.vmware.vim25.mo.ServiceInstance;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.naming.AuthenticationException;
import javax.servlet.ServletException;
import lombok.NonNull;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AJAXCheckHostConnection
extends AJAXServlet {
    private static final int RETRY_PERIOD = 5;
    private static final int RETRY_ATTEMPTS = 3;
    private static final String CHECK_THE_CLUSTER_LOG = "Check the connection to the cluster: {}";
    private static final long serialVersionUID = -8615899437465775158L;
    private static final Logger logger = LogManager.getLogger(AJAXCheckHostConnection.class);
    private static final String IS_MAIN_UI = "main_ui";
    private static boolean webPluginSupported = false;
    private static boolean legacyPluginSupported = false;
    private static boolean isVCenterManaged = false;

    public AJAXCheckHostConnection(ServiceManager serviceManager) {
        super(serviceManager);
    }

    private static synchronized boolean isLegacyPluginSupported() {
        return legacyPluginSupported;
    }

    private static synchronized void setLegacyPluginSupported(boolean bl) {
        legacyPluginSupported = bl;
    }

    private static synchronized boolean isWebPluginSupported() {
        return webPluginSupported;
    }

    private static synchronized void setWebPluginSupported(boolean bl) {
        webPluginSupported = bl;
    }

    private static synchronized boolean isVCenterManaged() {
        return isVCenterManaged;
    }

    private static synchronized void setVCenterManaged(boolean bl) {
        isVCenterManaged = bl;
    }

    @Override
    protected void doPost(PageContext pageContext) throws ServletException, IOException {
        logger.debug("doPost() - start");
        boolean bl = false;
        if (this.verifyFormToken(pageContext, false)) {
            Object object;
            pageContext.getResponse().setContentType("application/json");
            PrintWriter printWriter = new PrintWriter(pageContext.getOutputWriter());
            bl = true;
            Object object2 = false;
            JsonObject jsonObject = new JsonObject();
            if (!BooleanUtils.toBoolean((String)pageContext.getPostQueryValue(IS_MAIN_UI))) {
                this.services.getUnverifiedCertificateManager().removeAllCertificateChains();
            }
            if (this.services.getVirtualConfigurationManager().isHyperV()) {
                object2 = this.checkHyperVConnection(pageContext, object2);
            } else if (this.services.getVirtualConfigurationManager().isNutanixAHV()) {
                object2 = this.checkNutanixAHVConnection(pageContext);
            } else if (this.services.getVirtualConfigurationManager().isESXi() && (object2 = this.checkVMwareESXiConnection(pageContext)) instanceof Integer) {
                object = (Integer)object2;
                jsonObject.put((Object)"certTrustNeeded", (Object)(((Integer)object).intValue() == ConnectionStatus.CERT_TRUST_NEEDED.getStatus() ? 1 : 0));
            }
            if (object2 instanceof RestConnectionStatus) {
                object = (RestConnectionStatus)((Object)object2);
                jsonObject.put((Object)"certTrustNeeded", (Object)(object == RestConnectionStatus.CERTIFICATE_UNTRUSTED ? 1 : 0));
                object2 = object.toString();
            }
            if (object2 instanceof Integer) {
                object = (Integer)object2;
                jsonObject.put((Object)"certTrustNeeded", (Object)(((Integer)object).intValue() == ConnectionStatus.CERT_TRUST_NEEDED.getStatus() ? 1 : 0));
            }
            if (AJAXCheckHostConnection.isVCenterManaged()) {
                jsonObject.put((Object)"webPluginSupported", (Object)AJAXCheckHostConnection.isWebPluginSupported());
                jsonObject.put((Object)"legacyPluginSupported", (Object)AJAXCheckHostConnection.isLegacyPluginSupported());
            }
            jsonObject.put((Object)"isValid", object2);
            printWriter.print(jsonObject.toJson());
            printWriter.close();
        }
        if (!bl) {
            pageContext.getResponse().sendError(401);
        }
        logger.debug("doPost() - end");
    }

    private SimplivityDetails getSimplivityDetailsFromPage(PageContext pageContext) {
        String string = StringUtils.trim((String)pageContext.getPostQueryValue("simplivity_ovc_user"));
        String string2 = pageContext.getPostQueryValue("simplivity_ovc_password");
        SimplivityDetails simplivityDetails = new SimplivityDetails();
        simplivityDetails.setOvcUser(string);
        simplivityDetails.setOvcPassword(string2);
        return simplivityDetails;
    }

    private void addHyperflexDetailsFromPage(PageContext pageContext, HyperflexDetails hyperflexDetails) {
        String string = StringUtils.trim((String)pageContext.getPostQueryValue("hyperflex_user"));
        String string2 = pageContext.getPostQueryValue("hyperflex_password");
        String string3 = pageContext.getPostQueryValue("hyperflex_cvm");
        logger.debug("getHyperflexDetailsFromPage() - Hyperflex Details from Page: User: {}, IP: {}", (Object)string, (Object)string3);
        hyperflexDetails.setUsername(string);
        hyperflexDetails.setPassword(string2);
        hyperflexDetails.setHost(string3);
    }

    private void addVxRailDetailsFromPage(PageContext pageContext, VxRailDetails vxRailDetails) {
        String string = StringUtils.trim((String)pageContext.getPostQueryValue("vxrail_cluster_ip"));
        VMWareDetails vMWareDetails = (VMWareDetails)pageContext.getSession().getAttribute("vcenter_server_details");
        logger.debug("getVxRailDetailsFromPage() - VxRail Details from Page: host: {}", (Object)string);
        vxRailDetails.setVxRailUsername(vMWareDetails.getUsername());
        vxRailDetails.setVxRailPassword(vMWareDetails.getPassword());
        vxRailDetails.setVxRailManagerIp(string);
    }

    private Object checkVMwareESXiConnection(PageContext pageContext) {
        logger.debug("checkVMwareESXiConnection() - start");
        Object object = false;
        Integer n = (Integer)pageContext.getSession().getAttribute("ESXIConfiguration");
        boolean bl = false;
        if (pageContext.getPostQueryValue(IS_MAIN_UI) != null && Boolean.valueOf(pageContext.getPostQueryValue(IS_MAIN_UI)).booleanValue()) {
            n = this.services.getVirtualConfigurationManager().isManagedHost() ? 2 : 1;
            bl = true;
        }
        if (bl) {
            logger.debug("checkVMwareESXiConnection() - Checking from Main UI.");
            object = this.connectionCheckMainUI(pageContext, n, bl);
        } else {
            logger.debug("checkVMwareESXiConnection() - Checking from Config Wizard.");
            object = this.connectionCheckWizardUI(pageContext, n, bl);
        }
        logger.debug("checkVMwareESXiConnection() - end: {}", object);
        return object;
    }

    private Object connectionCheckWizardUI(PageContext pageContext, Integer n, boolean bl) {
        Object object = false;
        VMWareDetails vMWareDetails = this.getVCenterDetailsFromPage(pageContext);
        if (2 == n) {
            AJAXCheckHostConnection.setVCenterManaged(true);
            if (pageContext.getPostQueryValue("nutanix_cluster_ip") != null) {
                NutanixDetails nutanixDetails = this.getNutanixDetailsFromPage(pageContext);
                logger.debug(CHECK_THE_CLUSTER_LOG, (Object)nutanixDetails.getClusterIp());
                object = this.checkNutanixClusterConnection(nutanixDetails);
            } else if (pageContext.getPostQueryValue("simplivity_ovc_user") != null) {
                SimplivityDetails simplivityDetails = this.getSimplivityDetailsFromPage(pageContext);
                logger.debug("connectionCheckWizardUI() - Connection check for Simplivty OVCs...");
                object = this.services.getSimplivityUtils().checkOvcConnections(simplivityDetails.getOvcUser(), simplivityDetails.getOvcPassword(), true, this.services.getVirtualConfigurationManager().getConfiguredHosts());
            } else if (pageContext.getPostQueryValue("hyperflex_user") != null) {
                HyperflexDetails hyperflexDetails = this.services.getHyperflexUtils().loadHyperflexDetails();
                this.addHyperflexDetailsFromPage(pageContext, hyperflexDetails);
                logger.debug("connectionCheckWizardUI() - Connection check for Hyperflex cluster...");
                object = this.services.getHyperflexUtils().checkConnection(hyperflexDetails);
            } else if (pageContext.getPostQueryValue("vxrail_cluster_ip") != null) {
                VxRailDetails vxRailDetails = this.services.getVxRailUtils().loadVxRailDetails();
                this.addVxRailDetailsFromPage(pageContext, vxRailDetails);
                logger.debug("connectionCheckWizardUI() - Connection check for VxRail Manager...");
                object = this.services.getVxRailUtils().checkConnection(vxRailDetails);
            } else {
                object = this.checkVCenterConnectionWithRetries(vMWareDetails, bl, 3, 5L, TimeUnit.SECONDS);
            }
        } else if (1 == n) {
            vMWareDetails = this.getESXiDetailsFromPage(pageContext);
            object = this.checkESXiHostConnection(vMWareDetails, bl);
        } else {
            logger.warn("Config type not recognised: {}", (Object)n);
        }
        return object;
    }

    private Object connectionCheckMainUI(PageContext pageContext, Integer n, boolean bl) {
        logger.debug("connectionCheckMainUI() - start");
        Object object = false;
        if (2 == n) {
            if (pageContext.getPostQueryValue("is_nutanix") != null && Boolean.valueOf(pageContext.getPostQueryValue("is_nutanix")).booleanValue()) {
                NutanixDetails nutanixDetails = this.services.getNutanixUtils().loadNutanixDetails();
                logger.debug("connectionCheckMainUI() - Check the connection to the cluster: {}", (Object)nutanixDetails.getClusterIp());
                object = this.checkNutanixClusterConnection(nutanixDetails);
            } else if (pageContext.getPostQueryValue("is_simplivity") != null && Boolean.valueOf(pageContext.getPostQueryValue("is_simplivity")).booleanValue()) {
                List<SimplivityDetails> list = this.services.getSimplivityUtils().loadSimplivityDetails();
                logger.debug("connectionCheckMainUI() - Connection check for Simplivty OVCs...");
                SimplivityDetails simplivityDetails = list.isEmpty() ? new SimplivityDetails() : list.get(0);
                object = this.services.getSimplivityUtils().checkOvcConnections(simplivityDetails.getOvcUser(), simplivityDetails.getOvcPassword(), false, this.services.getVirtualConfigurationManager().getConfiguredHosts());
            } else if (pageContext.getPostQueryValue("is_hyperflex") != null) {
                HyperflexDetails hyperflexDetails = this.services.getHyperflexUtils().loadHyperflexDetails();
                logger.debug("connectionCheckMainUI() - Connection check for Hyperflex cluster...");
                object = this.services.getHyperflexUtils().checkConnection(hyperflexDetails);
            } else if (pageContext.getPostQueryValue("is_vxrail") != null) {
                VxRailDetails vxRailDetails = this.services.getVxRailUtils().loadVxRailDetails();
                logger.debug("connectionCheckMainUI() - Connection check for VxRail Manager...");
                object = this.services.getVxRailUtils().checkConnection(vxRailDetails);
            } else {
                AJAXCheckHostConnection.setVCenterManaged(true);
                logger.debug("connectionCheckMainUI() - Connection check for VCenter...");
                VMWareDetails vMWareDetails = this.services.getVirtualConfigurationManager().loadVCenterServerDetails();
                object = this.checkVCenterConnectionWithRetries(vMWareDetails, bl, 3, 5L, TimeUnit.SECONDS);
            }
        } else if (1 == n) {
            VMWareDetails vMWareDetails = this.services.getVirtualConfigurationManager().loadESXiHostServerDetails();
            logger.debug("connectionCheckMainUI() - Connection check for standalone ESX host...");
            object = this.checkESXiHostConnection(vMWareDetails, bl);
        } else {
            logger.warn("connectionCheckMainUI() - Config type not recognised: {}", (Object)n);
        }
        logger.debug("connectionCheckMainUI() - end: {}", object);
        return object;
    }

    private Object checkNutanixAHVConnection(PageContext pageContext) {
        Comparable<Boolean> comparable = false;
        if (!this.isMainUI(pageContext)) {
            NutanixDetails nutanixDetails = this.getNutanixDetailsFromPage(pageContext);
            logger.debug(CHECK_THE_CLUSTER_LOG, (Object)nutanixDetails.getClusterIp());
            comparable = this.checkNutanixClusterConnection(nutanixDetails);
        } else {
            NutanixDetails nutanixDetails = this.services.getNutanixUtils().loadNutanixDetails();
            comparable = this.checkNutanixClusterConnection(nutanixDetails);
        }
        return comparable;
    }

    private boolean isMainUI(PageContext pageContext) {
        boolean bl = false;
        if (pageContext.getPostQueryValue(IS_MAIN_UI) != null && Boolean.valueOf(pageContext.getPostQueryValue(IS_MAIN_UI)).booleanValue()) {
            bl = true;
        }
        return bl;
    }

    private Object checkHyperVConnection(PageContext pageContext, Object object) {
        Object object2 = pageContext.getPostQueryValue("SCVMMIpName");
        logger.debug("check the SCVMM connection:" + (String)object2);
        if (object2 != null) {
            if (((String)object2).indexOf(":") >= 0 && !((String)object2).startsWith("[") && !((String)object2).endsWith("]")) {
                object2 = "[" + (String)object2 + "]";
            }
            logger.debug("Connecting to SCVMM ip: " + (String)object2);
            object = this.services.getHyperVUtils().isServerAvailable((String)object2);
        }
        return object;
    }

    private Integer checkVCenterConnectionWithRetries(VMWareDetails vMWareDetails, boolean bl, int n, long l, TimeUnit timeUnit) {
        n = Math.max(1, n);
        l = Math.max(0L, l);
        logger.debug("checkVCenterConnectionWithRetries() - Retries: {}, Period: {}, Time Unit: {}", (Object)n, (Object)l, (Object)timeUnit);
        Integer n2 = null;
        do {
            if ((n2 = this.checkVCenterConnection(vMWareDetails, bl)).intValue() == ConnectionStatus.INVALID_CREDENTIALS.getStatus()) {
                logger.debug("checkVCenterConnectionWithRetries() - Invalid VCenter details, skipping retries");
                break;
            }
            if (n2.intValue() == ConnectionStatus.CERT_TRUST_NEEDED.getStatus()) {
                logger.debug("checkVCenterConnectionWithRetries() - Untrusted certificate detected, skipping retries");
                break;
            }
            if (n2.intValue() == ConnectionStatus.CONNECTION_SUCCESS.getStatus()) continue;
            logger.debug("checkVCenterConnectionWithRetries() - Failed to get VCenter Connection.  Result: {}, retries left: {}", (Object)n2, (Object)n);
            new CountdownTimer(l, timeUnit).sleep();
        } while (n2.intValue() != ConnectionStatus.CONNECTION_SUCCESS.getStatus() && --n > 0);
        logger.debug("checkVCenterConnectionWithRetries() - Got connection: {}", (Object)n2);
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer checkVCenterConnection(@NonNull VMWareDetails vMWareDetails, boolean bl) {
        if (vMWareDetails == null) {
            throw new IllegalArgumentException("details is marked non-null but is null");
        }
        logger.debug("checkVCenterConnection() - start");
        Integer n = ConnectionStatus.CONNECTION_SUCCESS.getStatus();
        ServiceInstance serviceInstance = null;
        try {
            serviceInstance = this.services.getVmWareConnection().getVCenterConnection(vMWareDetails, bl);
            if (serviceInstance != null) {
                String string = serviceInstance.getAboutInfo().getApiType();
                AJAXCheckHostConnection.setLegacyPluginSupported(this.services.getVirtualConfigurationManager().isLegacyPluginSupported(serviceInstance));
                AJAXCheckHostConnection.setWebPluginSupported(this.services.getVirtualConfigurationManager().isWebClientPluginSupported(serviceInstance));
                if (!"HostAgent".equalsIgnoreCase(string)) {
                    logger.debug("checkVCenterConnection() - Connection to vCenter Server successful");
                    n = ConnectionStatus.CONNECTION_SUCCESS.getStatus();
                    this.services.getVmWareConnection().setVCenterOffline(false);
                } else {
                    logger.debug("checkVCenterConnection() - Connection to vCenter Server could not be made");
                    this.services.getVmWareConnection().logoutESXiHost(vMWareDetails.getServerIp());
                    n = ConnectionStatus.INVALID_CREDENTIALS.getStatus();
                }
            } else {
                logger.debug("checkVCenterConnection() - Connection to vCenter Server could not be made");
                n = ConnectionStatus.INVALID_CREDENTIALS.getStatus();
                AJAXCheckHostConnection.setLegacyPluginSupported(false);
                AJAXCheckHostConnection.setWebPluginSupported(false);
            }
        }
        catch (InvalidLogin invalidLogin) {
            logger.debug("checkVCenterConnection() - Malformed URL entered for vCenter Server. ", (Throwable)invalidLogin);
            n = ConnectionStatus.INVALID_CREDENTIALS.getStatus();
            AJAXCheckHostConnection.setLegacyPluginSupported(false);
            AJAXCheckHostConnection.setWebPluginSupported(false);
            if (bl) {
                this.services.getVmWareConnection().logVCenterAuthFailure();
            }
        }
        catch (RemoteException remoteException) {
            boolean bl2 = this.services.getUnverifiedCertificateManager().addCertificateChainByException(vMWareDetails.getServerIp(), remoteException);
            if (bl2) {
                n = ConnectionStatus.CERT_TRUST_NEEDED.getStatus();
            } else {
                logger.debug("checkVCenterConnection() - Connection to vCenter Server could not be made. ", (Throwable)remoteException);
                n = ConnectionStatus.NETWORK_ERROR.getStatus();
                AJAXCheckHostConnection.setLegacyPluginSupported(false);
                AJAXCheckHostConnection.setWebPluginSupported(false);
                if (bl) {
                    this.services.getVmWareConnection().logVCenterOffline();
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            logger.debug("checkVCenterConnection() - Connection to vCenter Server could not be made. ", (Throwable)malformedURLException);
            n = ConnectionStatus.INVALID_CREDENTIALS.getStatus();
            AJAXCheckHostConnection.setLegacyPluginSupported(false);
            AJAXCheckHostConnection.setWebPluginSupported(false);
            if (bl) {
                this.services.getVmWareConnection().logVCenterOffline();
            }
        }
        catch (Exception exception) {
            logger.debug("checkVCenterConnection() - Connection to vCenter Server could not be made. ", (Throwable)exception);
            if (bl) {
                this.services.getVmWareConnection().logVCenterOffline();
            }
            n = ConnectionStatus.NETWORK_ERROR.getStatus();
            AJAXCheckHostConnection.setLegacyPluginSupported(false);
            AJAXCheckHostConnection.setWebPluginSupported(false);
        }
        finally {
            if (!bl) {
                this.services.getVmWareConnection().logoutVCenterServer();
            }
        }
        logger.debug("checkVCenterConnection() - end: {}", (Object)n);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer checkESXiHostConnection(VMWareDetails vMWareDetails, boolean bl) {
        Integer n = ConnectionStatus.CONNECTION_SUCCESS.getStatus();
        if (vMWareDetails == null) {
            return ConnectionStatus.NETWORK_ERROR.getStatus();
        }
        ServiceInstance serviceInstance = null;
        try {
            this.services.getVmWareConnection().logoutESXiHost(vMWareDetails.getServerIp());
            serviceInstance = this.services.getVmWareConnection().getESXiHostInstance(vMWareDetails);
            if (serviceInstance != null) {
                String string = serviceInstance.getAboutInfo().getApiType();
                if (!"VirtualCenter".equalsIgnoreCase(string)) {
                    logger.debug("Connection to ESXi Host successful");
                    n = ConnectionStatus.CONNECTION_SUCCESS.getStatus();
                } else {
                    logger.debug("Connection to ESXiHost could not be made");
                    this.services.getVmWareConnection().logoutVCenterServer();
                    n = ConnectionStatus.INVALID_CREDENTIALS.getStatus();
                }
            } else {
                logger.debug("Connection to ESXi Host could not be made");
                n = ConnectionStatus.INVALID_CREDENTIALS.getStatus();
                if (bl) {
                    this.services.getVmWareConnection().logESXiHostAuthFailure(vMWareDetails.getServerIp());
                }
            }
        }
        catch (InvalidLogin invalidLogin) {
            logger.debug("Connection to ESXi Host could not be made. ", (Throwable)invalidLogin);
            n = ConnectionStatus.INVALID_CREDENTIALS.getStatus();
            if (bl) {
                this.services.getVmWareConnection().logESXiHostAuthFailure(vMWareDetails.getServerIp());
            }
        }
        catch (RemoteException remoteException) {
            logger.debug("Connection to ESXi Host could not be made. ", (Throwable)remoteException);
            n = ConnectionStatus.NETWORK_ERROR.getStatus();
            if (this.services.getUnverifiedCertificateManager().addCertificateChainByException(vMWareDetails.getServerIp(), remoteException)) {
                n = ConnectionStatus.CERT_TRUST_NEEDED.getStatus();
            }
            if (bl) {
                this.services.getVmWareConnection().logESXiOffline(vMWareDetails.getServerIp());
            }
        }
        catch (MalformedURLException malformedURLException) {
            logger.debug("Malformed URL entered for ESXi Host. ", (Throwable)malformedURLException);
            n = ConnectionStatus.NETWORK_ERROR.getStatus();
            if (bl) {
                this.services.getVmWareConnection().logESXiHostAuthFailure(vMWareDetails.getServerIp());
            }
        }
        catch (Exception exception) {
            logger.debug("Connection to ESXi Host could not be made. ", (Throwable)exception);
            n = ConnectionStatus.NETWORK_ERROR.getStatus();
            if (bl) {
                this.services.getVmWareConnection().logESXiOffline(vMWareDetails.getServerIp());
            }
        }
        finally {
            if (!bl) {
                this.services.getVmWareConnection().logoutESXiHost(vMWareDetails.getServerIp());
            }
        }
        return n;
    }

    private Integer checkNutanixClusterConnection(NutanixDetails nutanixDetails) {
        UserFilePathValidator userFilePathValidator;
        Integer n = ConnectionStatus.NETWORK_ERROR.getStatus();
        NutanixService nutanixService = NutanixService.getInstance();
        NutanixConnection nutanixConnection = null;
        if (StringUtils.isNotBlank((CharSequence)nutanixDetails.getSshKeyPath()) && !(userFilePathValidator = new UserFilePathValidator()).isValid(nutanixDetails.getSshKeyPath())) {
            return ConnectionStatus.COULD_NOT_LOAD_SSH_KEY.getStatus();
        }
        try {
            nutanixConnection = nutanixService.getClusterConnection(nutanixDetails);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.debug("Illegal argument for the Nutanix cluster credentials: {}", (Object)illegalArgumentException.getMessage());
            n = ConnectionStatus.INVALID_CREDENTIALS.getStatus();
        }
        catch (IOException iOException) {
            logger.error("Unable to load SSH key: {}", (Object)iOException.getMessage());
            n = ConnectionStatus.COULD_NOT_LOAD_SSH_KEY.getStatus();
        }
        if (nutanixConnection != null) {
            try {
                nutanixConnection.connect();
                boolean bl = nutanixConnection.isClusterUp();
                if (bl) {
                    n = ConnectionStatus.CONNECTION_SUCCESS.getStatus();
                    logger.debug("Successfully connected to the Nutanix Cluster: Cluster is up");
                } else {
                    n = ConnectionStatus.NETWORK_ERROR.getStatus();
                    logger.error("Failed to connected to the Nutanix Cluster: Cluster is down");
                }
                nutanixConnection.disconnect();
            }
            catch (RemoteException remoteException) {
                Throwable throwable = remoteException.getCause();
                if (throwable instanceof AuthenticationException) {
                    n = ConnectionStatus.INVALID_CREDENTIALS.getStatus();
                    logger.error("Failed to connect to Nutanix Cluster: {}", (Object)throwable.getMessage());
                }
                n = ConnectionStatus.NETWORK_ERROR.getStatus();
                logger.error("Failed to Connect to the Nutanix Cluster: {}", (Object)remoteException.getMessage());
            }
        }
        return n;
    }

    private NutanixDetails getNutanixDetailsFromPage(PageContext pageContext) {
        String string = StringUtils.trim((String)pageContext.getPostQueryValue("nutanix_cluster_ip"));
        String string2 = StringUtils.trim((String)pageContext.getPostQueryValue("nutanix_cluster_password"));
        String string3 = StringUtils.trim((String)pageContext.getPostQueryValue("nutanix_ssh_key_path"));
        String string4 = StringUtils.trim((String)pageContext.getPostQueryValue("nutanix_ssh_key_passphrase"));
        NutanixDetails nutanixDetails = new NutanixDetails(string, string2, null, string3, string4);
        nutanixDetails.setClusterUsername(this.services.getNutanixUtils().getClusterUsernameFromConfig());
        return nutanixDetails;
    }

    private VMWareDetails getVCenterDetailsFromPage(PageContext pageContext) {
        String string = pageContext.getPostQueryValue("vcenter_server_ip");
        String string2 = this.validateServerProtocol(pageContext.getPostQueryValue("vcenter_server_protocol"));
        String string3 = pageContext.getPostQueryValue("vcenter_server_port");
        String string4 = pageContext.getPostQueryValue("vcenter_server_username");
        String string5 = pageContext.getPostQueryValue("vcenter_server_password");
        VMWareDetails vMWareDetails = new VMWareDetails(string2, string3, string, string4, string5, false);
        return vMWareDetails;
    }

    private String validateServerProtocol(String string) {
        String string2 = "https";
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)string, (CharSequence[])new CharSequence[]{"https", "http"})) {
            string2 = StringUtils.lowerCase((String)string);
        }
        return string2;
    }

    private VMWareDetails getESXiDetailsFromPage(PageContext pageContext) {
        String string = pageContext.getPostQueryValue("esxi_host_ip");
        String string2 = this.validateServerProtocol(pageContext.getPostQueryValue("esxi_host_protocol"));
        String string3 = pageContext.getPostQueryValue("esxi_host_port");
        String string4 = pageContext.getPostQueryValue("esxi_host_username");
        String string5 = pageContext.getPostQueryValue("esxi_host_password");
        VMWareDetails vMWareDetails = new VMWareDetails(string2, string3, string, string4, string5, false);
        return vMWareDetails;
    }
}

