/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.servlets;

import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.servlets.AJAXServlet;
import com.apcc.m11.components.webserver.util.HostNMCMappingHelper;
import com.apcc.m11.components.webserver.util.HostSelectionHTMLHelper;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.m11.components.webserver.util.virtualization.nutanix.NutanixUtils;
import com.apcc.pcns.ServiceManager;
import java.io.IOException;
import javax.servlet.ServletException;

public class AJAXHostNMCMapping
extends AJAXServlet {
    private static final long serialVersionUID = 6785127993080657912L;
    private HostNMCMappingHelper helper;
    private HostSelectionHTMLHelper htmlHelper;
    private Division container = null;

    public AJAXHostNMCMapping(ServiceManager serviceManager) {
        super(serviceManager);
    }

    @Override
    protected void doPost(PageContext pageContext) throws ServletException, IOException {
        boolean bl = false;
        boolean bl2 = false;
        if (pageContext.getPostQueryValue("ismainui") != null) {
            bl = Boolean.valueOf(pageContext.getPostQueryValue("ismainui"));
        }
        if (pageContext.getPostQueryValue("isvmsettings") != null) {
            bl2 = Boolean.valueOf(pageContext.getPostQueryValue("isvmsettings"));
        }
        this.helper = new HostNMCMappingHelper(this.services.getAdvancedSetupHelper().readUPSSetupsFromConfig(), Utils.getNMCList(pageContext, true, true), this.services.getAdvancedSetupHelper().readMappedHostsFromConfig(), this.services);
        this.htmlHelper = new HostSelectionHTMLHelper(pageContext.getLocale(), bl, bl2, this.services);
        this.container = new Division();
        this.createHostNMCMappingPage(pageContext, bl, bl2);
        if (this.services.getVirtualConfigurationManager().isNutanixAHV() || this.services.getVirtualConfigurationManager().isNutanixESXi()) {
            new NutanixUtils().saveClusterDetailsToConfig();
        }
        pageContext.writeHTML(this.container);
    }

    private void createHostNMCMappingPage(PageContext pageContext, boolean bl, boolean bl2) {
        this.helper.initialize();
        this.helper.refreshMappedHosts();
        if (this.services.getVirtualConfigurationManager().isESXi()) {
            this.htmlHelper.createVMWareMessages(pageContext, this.container, this.helper);
        } else if (this.services.getVirtualConfigurationManager().isNutanixAHV()) {
            this.htmlHelper.createNutanixMessages(pageContext, this.container, this.helper);
        }
        if (!bl2) {
            this.htmlHelper.createNoHostSelectedWarning(pageContext, this.container);
        }
        this.htmlHelper.displayOutletOffWarningDiv(this.container, pageContext);
        this.htmlHelper.displayOutletPendingOffWarningDiv(this.container, pageContext);
        this.htmlHelper.displayRegistrationResultDiv(this.container, pageContext);
        this.htmlHelper.createHostNMCMappingLists(pageContext, this.container, this.helper);
        this.htmlHelper.createWaitMessage(pageContext, this.container);
    }
}

