/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.servlets;

import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.Text;
import com.apcc.m11.components.webserver.model.VMPrioritizationOperations;
import com.apcc.m11.components.webserver.servlets.AJAXServlet;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.m11.components.webserver.util.VMPriorityTreeHelper;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.io.IOException;
import java.util.Locale;
import javax.servlet.ServletException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AJAXPrioritizedVM
extends AJAXServlet {
    private static final long serialVersionUID = 7238086118855865483L;
    private static final Logger logger = LogManager.getLogger(AJAXPrioritizedVM.class);
    private static final String QUERY_INVENTORY = "inventory";
    private static final String QUERY_PRIORITY = "priority";
    private static final String QUERY_LIST = "list";
    private String theNodeLabelHighText;
    private String theNodeLabelMediumText;
    private String theNodeLabelLowText;
    private String theNodeLabelGroup1Text;
    private String theNodeLabelGroup2Text;
    private String theNodeTooltipHighText;
    private String theNodeTooltipMediumText;
    private String theNodeTooltipLowText;
    private String theNodeTooltipGroup1Text;
    private String theNodeTooltipGroup2Text;

    public AJAXPrioritizedVM(ServiceManager serviceManager) {
        super(serviceManager);
    }

    private void setupLanguage(Locale locale) {
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        this.theNodeLabelHighText = Utils.getResourceString(resourceBundleWrapper, "VMPrioritization.PriorityTreeNodeLabelHigh");
        this.theNodeLabelMediumText = Utils.getResourceString(resourceBundleWrapper, "VMPrioritization.PriorityTreeNodeLabelMedium");
        this.theNodeLabelLowText = Utils.getResourceString(resourceBundleWrapper, "VMPrioritization.PriorityTreeNodeLabelLow");
        this.theNodeLabelGroup1Text = Utils.getResourceString(resourceBundleWrapper, "VMPrioritization.PriorityTreeNodeLabelGroup1");
        this.theNodeLabelGroup2Text = Utils.getResourceString(resourceBundleWrapper, "VMPrioritization.PriorityTreeNodeLabelGroup2");
        this.theNodeTooltipHighText = Utils.getResourceString(resourceBundleWrapper, "VMPrioritization.PriorityTreeNodeTooltipHigh");
        this.theNodeTooltipMediumText = Utils.getResourceString(resourceBundleWrapper, "VMPrioritization.PriorityTreeNodeTooltipMedium");
        this.theNodeTooltipLowText = Utils.getResourceString(resourceBundleWrapper, "VMPrioritization.PriorityTreeNodeTooltipLow");
        this.theNodeTooltipGroup1Text = Utils.getResourceString(resourceBundleWrapper, "VMPrioritization.PriorityTreeNodeTooltipGroup1");
        this.theNodeTooltipGroup2Text = Utils.getResourceString(resourceBundleWrapper, "VMPrioritization.PriorityTreeNodeTooltipGroup2");
    }

    @Override
    protected void doPost(PageContext pageContext) throws ServletException, IOException {
        if (this.verifyFormToken(pageContext, false)) {
            this.setupLanguage(pageContext.getLocale());
            VMPriorityTreeHelper vMPriorityTreeHelper = this.services.getVMPriorityTreeHelper();
            vMPriorityTreeHelper.refreshCache(pageContext.getLocale());
            if (QUERY_PRIORITY.equalsIgnoreCase(pageContext.getPostQueryValue(QUERY_LIST))) {
                VMPrioritizationOperations vMPrioritizationOperations = (VMPrioritizationOperations)pageContext.getValue("VMPrioritizationData");
                if (vMPrioritizationOperations == null) {
                    vMPrioritizationOperations = this.services.getVMPrioritizationUtils().readVMPrioritizationFromConfig(vMPriorityTreeHelper.getInventoryList());
                    pageContext.setValue("VMPrioritizationData", vMPrioritizationOperations);
                }
                String[] stringArray = new String[]{this.theNodeLabelHighText, this.theNodeLabelMediumText, this.theNodeLabelLowText, this.theNodeLabelGroup1Text, this.theNodeLabelGroup2Text};
                String[] stringArray2 = new String[]{this.theNodeTooltipHighText, this.theNodeTooltipMediumText, this.theNodeTooltipLowText, this.theNodeTooltipGroup1Text, this.theNodeTooltipGroup2Text};
                pageContext.writeHTML(vMPriorityTreeHelper.getPriorityTreeHTML(vMPrioritizationOperations.getSequencedVMs(), stringArray, stringArray2));
            } else if (!vMPriorityTreeHelper.hasInventoryList()) {
                pageContext.writeHTML(new Text("99"));
            } else if (vMPriorityTreeHelper.getInventoryVMListSize() == 0) {
                pageContext.writeHTML(new Text("98"));
            } else {
                pageContext.writeHTML(vMPriorityTreeHelper.getInventoryTreeHTML());
            }
        } else {
            pageContext.getResponse().sendError(401);
        }
    }
}

