/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.servlets;

import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.servlets.AJAXServlet;
import com.apcc.pcns.ServiceManager;
import com.github.cliftonlabs.json_simple.JsonObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AJAXSimplivityOVCFinder
extends AJAXServlet {
    private static final Logger logger = LogManager.getLogger(AJAXSimplivityOVCFinder.class);
    private static final long serialVersionUID = 7539591711348244310L;

    public AJAXSimplivityOVCFinder(ServiceManager serviceManager) {
        super(serviceManager);
    }

    @Override
    protected void doPost(PageContext pageContext) throws ServletException, IOException {
        try {
            if (this.verifyFormToken(pageContext, false)) {
                pageContext.getResponse().setContentType("application/json");
                PrintWriter printWriter = new PrintWriter(pageContext.getOutputWriter());
                Set<String> set = this.parseHostSet(pageContext);
                JsonObject jsonObject = this.services.getSimplivityUtils().checkOvcConnections(set);
                printWriter.print(jsonObject.toJson());
                printWriter.close();
            } else {
                pageContext.getResponse().sendError(401);
            }
        }
        catch (IOException iOException) {
            logger.warn((Object)iOException);
        }
    }

    private Set<String> parseHostSet(PageContext pageContext) {
        String string = pageContext.getPostQueryValue("hosts");
        HashSet<String> hashSet = new HashSet<String>();
        for (String string2 : StringUtils.split((String)string)) {
            hashSet.add(string2);
        }
        return hashSet;
    }
}

