/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.servlets;

import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.apc.ApcStatusIcon;
import com.apcc.m11.components.webserver.servlets.AJAXServlet;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.m11.ds.services.softwareupdate.SoftwareUpdateGroup;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.licensing.LicenseDetails;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Optional;
import javax.servlet.ServletException;

public class AJAXStatusIconTray
extends AJAXServlet {
    private static final long serialVersionUID = -4816359688511797038L;
    private static final String kPrefixId = "StatusIcons.";
    private static final String kUpdatesNoneId = "StatusIcons.UpdatesNone";
    private static final String kUpdatesAvailableId = "StatusIcons.UpdatesAvailable";
    private static final String LICENSE_EXPIRED = "Licensing.ExpiredMessage";
    private static final String LICENSE_PRE_EXPIRY = "Licensing.DaysRemainingTillExpiration";
    private static String theUpdatesNoneText;
    private static String theUpdatesAvailableText;
    private static String theLicenseExpiredText;
    private static String theLicensePreExpiryText;

    public AJAXStatusIconTray(ServiceManager serviceManager) {
        super(serviceManager);
        licensingManager = this.services.getLicensingManager();
        licensingManager.init();
    }

    @Override
    protected void doPost(PageContext pageContext) throws ServletException, IOException {
        AJAXStatusIconTray.setupLanguage(pageContext.getLocale());
        Integer n = (Integer)pageContext.get(SoftwareUpdateGroup.UpdateStatus.getObjectId());
        boolean bl = licensingManager.isLicenseRequired();
        ApcStatusIcon apcStatusIcon = new ApcStatusIcon("License");
        apcStatusIcon.setStatus(4);
        apcStatusIcon.setTarget("_self");
        apcStatusIcon.setHypertextReference("/licensing");
        if (licensingManager.isInPreExpiryPeriod()) {
            long l = 0L;
            Optional<LicenseDetails> optional = licensingManager.getLicense();
            if (optional.isPresent()) {
                LicenseDetails licenseDetails = optional.get();
                l = licenseDetails.getNumberOfDaysTillLicenseExpires();
            }
            apcStatusIcon.setText(MessageFormat.format(theLicensePreExpiryText, l));
            pageContext.writeHTML(apcStatusIcon);
        } else if (licensingManager.isLicenseExpired()) {
            apcStatusIcon.setText(theLicenseExpiredText);
            pageContext.writeHTML(apcStatusIcon);
        } else if (n == 1 && !bl) {
            ApcStatusIcon apcStatusIcon2 = new ApcStatusIcon("Updates");
            String string = (String)pageContext.get(SoftwareUpdateGroup.UpdateURL.getObjectId());
            String string2 = (String)pageContext.get(SoftwareUpdateGroup.UpdateDescription.getObjectId());
            if (string2 == null && string == null) {
                apcStatusIcon2.setStatus(0);
                apcStatusIcon2.setText(theUpdatesNoneText);
                apcStatusIcon2.setTarget("_self");
                apcStatusIcon2.setHypertextReference("/updates");
            } else {
                apcStatusIcon2.setStatus(2);
                apcStatusIcon2.setText(theUpdatesAvailableText);
                apcStatusIcon2.setTarget("_blank");
                apcStatusIcon2.setHypertextReference(string);
            }
            pageContext.writeHTML(apcStatusIcon2);
        }
    }

    public static void setupLanguage(Locale locale) {
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        theUpdatesNoneText = Utils.getResourceString(resourceBundleWrapper, kUpdatesNoneId);
        theUpdatesAvailableText = Utils.getResourceString(resourceBundleWrapper, kUpdatesAvailableId);
        theLicenseExpiredText = Utils.getResourceString(resourceBundleWrapper, LICENSE_EXPIRED);
        theLicensePreExpiryText = Utils.getResourceString(resourceBundleWrapper, LICENSE_PRE_EXPIRY);
    }
}

