/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.servlets;

import com.apcc.m11.arch.storage.IPermanentStorage;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.model.SSHSettings;
import com.apcc.m11.components.webserver.model.UPSSetup;
import com.apcc.m11.components.webserver.pages.AdvancedSSHSettingsPage;
import com.apcc.m11.components.webserver.servlets.M11Servlet;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.SSHActionConfigurator;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AdvancedSSHSettingsServlet
extends M11Servlet {
    private static final long serialVersionUID = -8401146337013479365L;
    private static final Logger logger = LogManager.getLogger(AdvancedSSHSettingsServlet.class);
    public static final String SETUP_ID = "setup";
    public static final String PARAM_SETUP = "param_setup";
    private SSHActionConfigurator configHelper;

    public AdvancedSSHSettingsServlet(IPermanentStorage iPermanentStorage, ServiceManager serviceManager) {
        super(serviceManager);
        if (iPermanentStorage == null) {
            throw new IllegalArgumentException("Storage reference can't be null.");
        }
        this.configHelper = new SSHActionConfigurator(this.services.getConfigurationManager(), this.services.getAuthHelper(), this.services.getAdvancedSetupHelper());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void doGet(PageContext pageContext) throws ServletException, IOException {
        if (!this.services.getAdvancedSetupHelper().isAdvancedShutdownMode()) {
            pageContext.getResponse().sendError(404);
            return;
        }
        Integer n = AdvancedSSHSettingsServlet.getSetupId(pageContext);
        if (n == null) {
            pageContext.getResponse().sendError(404);
            return;
        }
        pageContext.getSession().setAttribute(PARAM_SETUP, (Object)n);
        this.setFormToken(pageContext.getRequest());
        boolean bl = false;
        List<SSHSettings> list = this.configHelper.readAll(bl);
        UPSSetup uPSSetup = this.services.getAdvancedSetupHelper().readUPSSetupFromConfig(n);
        Map<String, Boolean> map = uPSSetup.getSSHSettings();
        if (list != null && map != null) {
            pageContext.setValue(SETUP_ID, n);
            AdvancedSSHSettingsPage advancedSSHSettingsPage = new AdvancedSSHSettingsPage(list, map, this.services);
            pageContext.writeHTML(advancedSSHSettingsPage);
            return;
        }
        pageContext.getResponse().sendError(404);
    }

    @Override
    protected void doPost(PageContext pageContext) throws ServletException, IOException {
        if (this.verifyFormToken(pageContext)) {
            this.updateSSHSettings(pageContext);
            String string = pageContext.getPostQueryValue(SETUP_ID);
            pageContext.getSession().setAttribute(PARAM_SETUP, (Object)string);
            pageContext.getResponse().sendRedirect(pageContext.getResponse().encodeRedirectURL("/advancedsshsettings?setup=" + string));
        }
    }

    private void updateSSHSettings(PageContext pageContext) {
        Integer n = AdvancedSSHSettingsServlet.getSetupId(pageContext);
        if (n != null) {
            UPSSetup uPSSetup = this.services.getAdvancedSetupHelper().readUPSSetupFromConfig(n);
            Map<String, Boolean> map = uPSSetup.getSSHSettings();
            uPSSetup.setSSHSettings(this.parseConfigFromContext(pageContext, map));
            this.services.getAdvancedSetupHelper().saveUPSSetupToConfig(uPSSetup, n);
        }
    }

    public static Integer getSetupId(PageContext pageContext) {
        String string = pageContext.getPostQueryValue(SETUP_ID);
        Integer n = null;
        if (string != null) {
            try {
                n = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                logger.error("getSetupId " + numberFormatException.getMessage());
            }
        } else if (pageContext.getSession().getAttribute(PARAM_SETUP) != null) {
            try {
                n = Integer.parseInt(pageContext.getSession().getAttribute(PARAM_SETUP).toString());
            }
            catch (NumberFormatException numberFormatException) {
                logger.error((Object)numberFormatException);
                n = null;
            }
        }
        return n;
    }

    private Map<String, Boolean> parseConfigFromContext(PageContext pageContext, Map<String, Boolean> map) {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        map.entrySet().stream().forEach(entry -> hashMap.put((String)entry.getKey(), StringUtils.trim((String)pageContext.getPostQueryValue((String)entry.getKey())) != null));
        return hashMap;
    }
}

