/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.servlets;

import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.model.UPSSetup;
import com.apcc.m11.components.webserver.pages.OmahaAdvancedShutdown;
import com.apcc.m11.components.webserver.servlets.M11Servlet;
import com.apcc.m11.components.webserver.util.NotificationHelper;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.ServiceManager;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AdvancedShutdown
extends M11Servlet {
    private static final Logger logger = LogManager.getLogger(AdvancedShutdown.class);
    public static final String VALUE_SETUP_GROUPS = "setupgroups";

    public AdvancedShutdown(ServiceManager serviceManager) {
        super(serviceManager);
    }

    @Override
    protected void doGet(PageContext pageContext) throws ServletException, IOException {
        if (this.services.getAdvancedSetupHelper().isAdvancedShutdownMode()) {
            Object object;
            this.setFormToken(pageContext.getRequest());
            pageContext.setValue(VALUE_SETUP_GROUPS, this.services.getAdvancedSetupHelper().readUPSSetupsFromConfig());
            Object object2 = pageContext.getSession().getAttribute("activeAcc");
            if (object2 != null) {
                pageContext.setValue("activeAcc", object2);
                pageContext.getSession().removeAttribute("activeAcc");
            }
            Boolean bl = Utils.isBroadcastSupported() && !this.services.getVirtualConfigurationManager().isESXi() && !this.services.getVirtualConfigurationManager().isHyperV();
            pageContext.setValue("is_broadcast_supported", bl);
            if (bl.booleanValue() && (object = NotificationHelper.getShutdownNotificationRecipient(pageContext)) != null) {
                pageContext.setValue("recipient", object);
            }
            object = new OmahaAdvancedShutdown(this.services);
            pageContext.writeHTML((HTML)object);
        } else {
            pageContext.getResponse().sendError(404);
        }
    }

    @Override
    protected void doPost(PageContext pageContext) throws ServletException, IOException {
        if (this.verifyFormToken(pageContext)) {
            this.setUPSGroups(pageContext);
            NotificationHelper.setShutdownNotification(pageContext);
            pageContext.getSession().setAttribute("activeAcc", (Object)pageContext.getPostQueryValue("activeAcc"));
            pageContext.getResponse().sendRedirect(pageContext.getResponse().encodeRedirectURL("/advancedshutdown"));
        }
    }

    private void setUPSGroups(PageContext pageContext) {
        if (pageContext.getPostQueryValue("upsRequired") != null) {
            List<UPSSetup> list = this.services.getAdvancedSetupHelper().readUPSSetupsFromConfig();
            this.services.getAdvancedSetupHelper().storeUPSSetupRequestValues(list, pageContext);
            this.services.getAdvancedSetupHelper().saveUPSSetupsToConfig(list);
        }
    }
}

