/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.servlets;

import com.apcc.m11.arch.storage.IPermanentStorage;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.model.SSHActionTrigger;
import com.apcc.m11.components.webserver.model.SSHSettings;
import com.apcc.m11.components.webserver.servlets.AJAXServlet;
import com.apcc.m11.components.webserver.servlets.SSHSettingsServlet;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.SSHActionConfigurator;
import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AjaxSSHSettingsServlet
extends AJAXServlet {
    private static final Logger logger = LogManager.getLogger(SSHSettingsServlet.class);
    private static final String TRIGGER_PARAM = "trigger";
    private static final String ENABLED_PARAM = "enabled";
    private static final String DELAY_PARAM = "delay";
    private static final String DURATION_PARAM = "duration";
    private static final String PORT_PARAM = "port";
    private static final String SSH_KEY_PASSWORD_PARAM = "sshKeyPassword";
    private static final String SSH_KEY_FILE_PARAM = "sshKeyFile";
    private static final String PASSWORD_PARAM = "password";
    private static final String INDEX_PARAM = "index";
    private static final String HOST_PARAM = "host";
    private static final String COMMAND_FILE_PATH_PARAM = "commandFilePath";
    private static final String USERNAME_PARAM = "username";
    private static final String NAME_PARAM = "name";
    private static final String CREATE = "create";
    private static final String DELETE = "delete";
    private static final String UPDATE = "edit";
    private static final String READ_ONE = "read";
    private static final String ACTION_PARAM = "action";
    private SSHActionConfigurator configHelper;

    public AjaxSSHSettingsServlet(IPermanentStorage iPermanentStorage, ServiceManager serviceManager) {
        super(serviceManager);
        if (iPermanentStorage == null) {
            throw new IllegalArgumentException("Storage reference can't be null.");
        }
        this.configHelper = new SSHActionConfigurator(serviceManager.getConfigurationManager(), serviceManager.getAuthHelper(), serviceManager.getAdvancedSetupHelper());
    }

    @Override
    protected void doGet(PageContext pageContext) throws ServletException, IOException {
        this.sendNotImplemented(pageContext);
    }

    @Override
    protected void doPost(PageContext pageContext) throws ServletException, IOException {
        if (this.verifyFormToken(pageContext, false)) {
            String string = pageContext.getPostQueryValue(ACTION_PARAM);
            logger.debug("doPost() - Requesting action: {}", (Object)string);
            switch (string) {
                case "create": {
                    this.createHandler(pageContext);
                    break;
                }
                case "read": {
                    this.readById(pageContext);
                    break;
                }
                case "edit": {
                    this.updateHandler(pageContext);
                    break;
                }
                case "delete": {
                    this.deleteHandler(pageContext);
                    break;
                }
                default: {
                    pageContext.getResponse().sendError(400);
                    break;
                }
            }
        } else {
            logger.warn("doPost() - Invalid form token. Request is unauthorized");
            pageContext.getResponse().sendError(401);
        }
    }

    private void deleteHandler(PageContext pageContext) throws IOException {
        try {
            String string = StringUtils.trim((String)pageContext.getPostQueryValue(INDEX_PARAM));
            if (StringUtils.isNotEmpty((CharSequence)string)) {
                int n = Integer.parseInt(string);
                this.configHelper.delete(n);
            } else {
                pageContext.getResponse().sendError(400);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            pageContext.getResponse().sendError(400);
        }
    }

    private void updateHandler(PageContext pageContext) throws IOException {
        try {
            SSHSettings sSHSettings = this.parseConfigFromContext(pageContext);
            this.configHelper.update(sSHSettings.getIndex(), sSHSettings);
            pageContext.getResponse().setStatus(200);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            pageContext.getResponse().sendError(400);
        }
    }

    private void createHandler(PageContext pageContext) throws IOException {
        logger.debug("createHandler() - start");
        try {
            SSHSettings sSHSettings = this.parseConfigFromContext(pageContext);
            logger.debug("createHandler() - parsed ssh action from params: {}", (Object)(sSHSettings != null ? 1 : 0));
            this.configHelper.create(sSHSettings);
            logger.debug("createHandler() - saved ssh action");
            logger.debug("createHandler() - respond with success");
            pageContext.getResponse().setStatus(200);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.warn("createHandler() - Failed to create ssh action. Cause: ", (Throwable)illegalArgumentException);
            pageContext.getResponse().sendError(400);
        }
    }

    private void readById(PageContext pageContext) throws IOException {
        String string = pageContext.getPostQueryValue(INDEX_PARAM);
        if (StringUtils.isEmpty((CharSequence)string)) {
            pageContext.getResponse().sendError(400);
        }
        try {
            int n = Integer.parseInt(string);
            boolean bl = true;
            SSHSettings sSHSettings = this.configHelper.read(n, bl);
            if (sSHSettings != null) {
                pageContext.getResponse().setContentType("application/json");
                pageContext.getResponse().setStatus(200);
                pageContext.getOutputWriter().print(sSHSettings.toJson());
            } else {
                logger.info("Failed to find setting with id:{}", (Object)n);
                pageContext.getResponse().sendError(404);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.info("Failed to read ID from post request parameters.", (Throwable)illegalArgumentException);
            pageContext.getResponse().sendError(400);
        }
    }

    private SSHSettings parseConfigFromContext(PageContext pageContext) {
        try {
            String string;
            String string2;
            String string3;
            String string4;
            String string5;
            String string6;
            String string7;
            String string8;
            String string9 = StringUtils.trim((String)pageContext.getPostQueryValue(NAME_PARAM));
            String string10 = StringUtils.trim((String)pageContext.getPostQueryValue(USERNAME_PARAM));
            String string11 = StringUtils.trim((String)pageContext.getPostQueryValue(COMMAND_FILE_PATH_PARAM));
            String string12 = StringUtils.trim((String)pageContext.getPostQueryValue(HOST_PARAM));
            SSHSettings sSHSettings = new SSHSettings(string9, string10, string12, string11);
            sSHSettings.setIndex(-1);
            String string13 = StringUtils.trim((String)pageContext.getPostQueryValue(INDEX_PARAM));
            if (StringUtils.isNotEmpty((CharSequence)string13)) {
                int n = Integer.parseInt(string13);
                sSHSettings.setIndex(n);
            }
            if (StringUtils.isNotEmpty((CharSequence)(string8 = StringUtils.trim((String)pageContext.getPostQueryValue(PASSWORD_PARAM))))) {
                sSHSettings.setPassword(string8);
                string8 = null;
            }
            if (StringUtils.isNotEmpty((CharSequence)(string7 = StringUtils.trim((String)pageContext.getPostQueryValue(SSH_KEY_FILE_PARAM))))) {
                sSHSettings.setSshKeyPath(string7);
            }
            if (StringUtils.isNotEmpty((CharSequence)(string6 = StringUtils.trim((String)pageContext.getPostQueryValue(SSH_KEY_PASSWORD_PARAM))))) {
                sSHSettings.setSshKeyPassword(string6);
                string6 = null;
            }
            if (StringUtils.isNotEmpty((CharSequence)(string5 = StringUtils.trim((String)pageContext.getPostQueryValue(PORT_PARAM))))) {
                int n = Integer.parseInt(string5);
                sSHSettings.setPort(n);
            }
            if (StringUtils.isNotEmpty((CharSequence)(string4 = StringUtils.trim((String)pageContext.getPostQueryValue(DELAY_PARAM))))) {
                int n = Integer.parseInt(string4);
                sSHSettings.setDelay(n);
            }
            if (StringUtils.isNotEmpty((CharSequence)(string3 = StringUtils.trim((String)pageContext.getPostQueryValue(DURATION_PARAM))))) {
                int n = Integer.parseInt(string3);
                sSHSettings.setDuration(n);
            }
            if (StringUtils.isNotEmpty((CharSequence)(string2 = StringUtils.trim((String)pageContext.getPostQueryValue(ENABLED_PARAM))))) {
                boolean bl = Boolean.parseBoolean(string2);
                sSHSettings.setEnabled(bl);
            }
            if (StringUtils.isNotEmpty((CharSequence)(string = StringUtils.trim((String)pageContext.getPostQueryValue(TRIGGER_PARAM))))) {
                SSHActionTrigger sSHActionTrigger = SSHActionTrigger.fromIniSetting(string);
                sSHSettings.setTrigger(sSHActionTrigger);
            }
            return sSHSettings;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.info("Failed to create an SSH action. Invalid values passed from client.");
            throw illegalArgumentException;
        }
    }
}

